import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface VpcIpamOrganizationAdminAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_organization_admin_account#delegated_admin_account_id VpcIpamOrganizationAdminAccount#delegated_admin_account_id}
    */
    readonly delegatedAdminAccountId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_organization_admin_account aws_vpc_ipam_organization_admin_account}
*/
export declare class VpcIpamOrganizationAdminAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_vpc_ipam_organization_admin_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_organization_admin_account aws_vpc_ipam_organization_admin_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcIpamOrganizationAdminAccountConfig
    */
    constructor(scope: Construct, id: string, config: VpcIpamOrganizationAdminAccountConfig);
    get arn(): string;
    private _delegatedAdminAccountId?;
    get delegatedAdminAccountId(): string;
    set delegatedAdminAccountId(value: string);
    get delegatedAdminAccountIdInput(): string | undefined;
    get email(): string;
    get id(): string;
    get name(): string;
    get servicePrincipal(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=vpc-ipam-organization-admin-account.d.ts.map