import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface VpcIpamPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#address_family VpcIpamPool#address_family}
    */
    readonly addressFamily: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#allocation_default_netmask_length VpcIpamPool#allocation_default_netmask_length}
    */
    readonly allocationDefaultNetmaskLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#allocation_max_netmask_length VpcIpamPool#allocation_max_netmask_length}
    */
    readonly allocationMaxNetmaskLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#allocation_min_netmask_length VpcIpamPool#allocation_min_netmask_length}
    */
    readonly allocationMinNetmaskLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#allocation_resource_tags VpcIpamPool#allocation_resource_tags}
    */
    readonly allocationResourceTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#auto_import VpcIpamPool#auto_import}
    */
    readonly autoImport?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#aws_service VpcIpamPool#aws_service}
    */
    readonly awsService?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#description VpcIpamPool#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#ipam_scope_id VpcIpamPool#ipam_scope_id}
    */
    readonly ipamScopeId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#locale VpcIpamPool#locale}
    */
    readonly locale?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#publicly_advertisable VpcIpamPool#publicly_advertisable}
    */
    readonly publiclyAdvertisable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#source_ipam_pool_id VpcIpamPool#source_ipam_pool_id}
    */
    readonly sourceIpamPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#tags VpcIpamPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool#tags_all VpcIpamPool#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool aws_vpc_ipam_pool}
*/
export declare class VpcIpamPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_vpc_ipam_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam_pool aws_vpc_ipam_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcIpamPoolConfig
    */
    constructor(scope: Construct, id: string, config: VpcIpamPoolConfig);
    private _addressFamily?;
    get addressFamily(): string;
    set addressFamily(value: string);
    get addressFamilyInput(): string | undefined;
    private _allocationDefaultNetmaskLength?;
    get allocationDefaultNetmaskLength(): number;
    set allocationDefaultNetmaskLength(value: number);
    resetAllocationDefaultNetmaskLength(): void;
    get allocationDefaultNetmaskLengthInput(): number | undefined;
    private _allocationMaxNetmaskLength?;
    get allocationMaxNetmaskLength(): number;
    set allocationMaxNetmaskLength(value: number);
    resetAllocationMaxNetmaskLength(): void;
    get allocationMaxNetmaskLengthInput(): number | undefined;
    private _allocationMinNetmaskLength?;
    get allocationMinNetmaskLength(): number;
    set allocationMinNetmaskLength(value: number);
    resetAllocationMinNetmaskLength(): void;
    get allocationMinNetmaskLengthInput(): number | undefined;
    private _allocationResourceTags?;
    get allocationResourceTags(): {
        [key: string]: string;
    };
    set allocationResourceTags(value: {
        [key: string]: string;
    });
    resetAllocationResourceTags(): void;
    get allocationResourceTagsInput(): {
        [key: string]: string;
    } | undefined;
    get arn(): string;
    private _autoImport?;
    get autoImport(): boolean | cdktf.IResolvable;
    set autoImport(value: boolean | cdktf.IResolvable);
    resetAutoImport(): void;
    get autoImportInput(): boolean | cdktf.IResolvable | undefined;
    private _awsService?;
    get awsService(): string;
    set awsService(value: string);
    resetAwsService(): void;
    get awsServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _ipamScopeId?;
    get ipamScopeId(): string;
    set ipamScopeId(value: string);
    get ipamScopeIdInput(): string | undefined;
    get ipamScopeType(): string;
    private _locale?;
    get locale(): string;
    set locale(value: string);
    resetLocale(): void;
    get localeInput(): string | undefined;
    get poolDepth(): number;
    private _publiclyAdvertisable?;
    get publiclyAdvertisable(): boolean | cdktf.IResolvable;
    set publiclyAdvertisable(value: boolean | cdktf.IResolvable);
    resetPubliclyAdvertisable(): void;
    get publiclyAdvertisableInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceIpamPoolId?;
    get sourceIpamPoolId(): string;
    set sourceIpamPoolId(value: string);
    resetSourceIpamPoolId(): void;
    get sourceIpamPoolIdInput(): string | undefined;
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=vpc-ipam-pool.d.ts.map