import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface VpcIpamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#cascade VpcIpam#cascade}
    */
    readonly cascade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#description VpcIpam#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#tags VpcIpam#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#tags_all VpcIpam#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * operating_regions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#operating_regions VpcIpam#operating_regions}
    */
    readonly operatingRegions: VpcIpamOperatingRegions[] | cdktf.IResolvable;
}
export interface VpcIpamOperatingRegions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam#region_name VpcIpam#region_name}
    */
    readonly regionName: string;
}
export declare function vpcIpamOperatingRegionsToTerraform(struct?: VpcIpamOperatingRegions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam aws_vpc_ipam}
*/
export declare class VpcIpam extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_vpc_ipam";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/vpc_ipam aws_vpc_ipam} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcIpamConfig
    */
    constructor(scope: Construct, id: string, config: VpcIpamConfig);
    get arn(): string;
    private _cascade?;
    get cascade(): boolean | cdktf.IResolvable;
    set cascade(value: boolean | cdktf.IResolvable);
    resetCascade(): void;
    get cascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get privateDefaultScopeId(): string;
    get publicDefaultScopeId(): string;
    get scopeCount(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingRegions?;
    get operatingRegions(): VpcIpamOperatingRegions[] | cdktf.IResolvable;
    set operatingRegions(value: VpcIpamOperatingRegions[] | cdktf.IResolvable);
    get operatingRegionsInput(): cdktf.IResolvable | VpcIpamOperatingRegions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=vpc-ipam.d.ts.map