import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF
*/
export interface DataAwsWafIpsetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/waf_ipset#name DataAwsWafIpset#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/waf_ipset aws_waf_ipset}
*/
export declare class DataAwsWafIpset extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_waf_ipset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/waf_ipset aws_waf_ipset} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsWafIpsetConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsWafIpsetConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-waf-ipset.d.ts.map