import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF
*/
export interface WafIpsetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset#name WafIpset#name}
    */
    readonly name: string;
    /**
    * ip_set_descriptors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset#ip_set_descriptors WafIpset#ip_set_descriptors}
    */
    readonly ipSetDescriptors?: WafIpsetIpSetDescriptors[] | cdktf.IResolvable;
}
export interface WafIpsetIpSetDescriptors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset#type WafIpset#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset#value WafIpset#value}
    */
    readonly value: string;
}
export declare function wafIpsetIpSetDescriptorsToTerraform(struct?: WafIpsetIpSetDescriptors | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset aws_waf_ipset}
*/
export declare class WafIpset extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_waf_ipset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/waf_ipset aws_waf_ipset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafIpsetConfig
    */
    constructor(scope: Construct, id: string, config: WafIpsetConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipSetDescriptors?;
    get ipSetDescriptors(): WafIpsetIpSetDescriptors[] | cdktf.IResolvable;
    set ipSetDescriptors(value: WafIpsetIpSetDescriptors[] | cdktf.IResolvable);
    resetIpSetDescriptors(): void;
    get ipSetDescriptorsInput(): cdktf.IResolvable | WafIpsetIpSetDescriptors[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=waf-ipset.d.ts.map