import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF Regional
*/
export interface WafregionalIpsetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset#name WafregionalIpset#name}
    */
    readonly name: string;
    /**
    * ip_set_descriptor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset#ip_set_descriptor WafregionalIpset#ip_set_descriptor}
    */
    readonly ipSetDescriptor?: WafregionalIpsetIpSetDescriptor[] | cdktf.IResolvable;
}
export interface WafregionalIpsetIpSetDescriptor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset#type WafregionalIpset#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset#value WafregionalIpset#value}
    */
    readonly value: string;
}
export declare function wafregionalIpsetIpSetDescriptorToTerraform(struct?: WafregionalIpsetIpSetDescriptor | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset aws_wafregional_ipset}
*/
export declare class WafregionalIpset extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_wafregional_ipset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/wafregional_ipset aws_wafregional_ipset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafregionalIpsetConfig
    */
    constructor(scope: Construct, id: string, config: WafregionalIpsetConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipSetDescriptor?;
    get ipSetDescriptor(): WafregionalIpsetIpSetDescriptor[] | cdktf.IResolvable;
    set ipSetDescriptor(value: WafregionalIpsetIpSetDescriptor[] | cdktf.IResolvable);
    resetIpSetDescriptor(): void;
    get ipSetDescriptorInput(): cdktf.IResolvable | WafregionalIpsetIpSetDescriptor[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=wafregional-ipset.d.ts.map