import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF V2
*/
export interface DataAwsWafv2RegexPatternSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/wafv2_regex_pattern_set#name DataAwsWafv2RegexPatternSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/wafv2_regex_pattern_set#scope DataAwsWafv2RegexPatternSet#scope}
    */
    readonly scope: string;
}
export interface DataAwsWafv2RegexPatternSetRegularExpression {
}
export declare function dataAwsWafv2RegexPatternSetRegularExpressionToTerraform(struct?: DataAwsWafv2RegexPatternSetRegularExpression): any;
export declare class DataAwsWafv2RegexPatternSetRegularExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsWafv2RegexPatternSetRegularExpression | undefined;
    set internalValue(value: DataAwsWafv2RegexPatternSetRegularExpression | undefined);
    get regexString(): string;
}
export declare class DataAwsWafv2RegexPatternSetRegularExpressionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsWafv2RegexPatternSetRegularExpressionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/wafv2_regex_pattern_set aws_wafv2_regex_pattern_set}
*/
export declare class DataAwsWafv2RegexPatternSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_wafv2_regex_pattern_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/wafv2_regex_pattern_set aws_wafv2_regex_pattern_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsWafv2RegexPatternSetConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsWafv2RegexPatternSetConfig);
    get arn(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _regularExpression;
    get regularExpression(): DataAwsWafv2RegexPatternSetRegularExpressionList;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-wafv2-regex-pattern-set.d.ts.map