import { Wafv2RuleGroupCustomResponseBody, Wafv2RuleGroupRule, Wafv2RuleGroupVisibilityConfig } from './wafv2-rule-group-structs';
import { Wafv2RuleGroupVisibilityConfigOutputReference } from './wafv2-rule-group-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF V2
*/
export interface Wafv2RuleGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#capacity Wafv2RuleGroup#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#description Wafv2RuleGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#name Wafv2RuleGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#scope Wafv2RuleGroup#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#tags Wafv2RuleGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#tags_all Wafv2RuleGroup#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * custom_response_body block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#custom_response_body Wafv2RuleGroup#custom_response_body}
    */
    readonly customResponseBody?: Wafv2RuleGroupCustomResponseBody[] | cdktf.IResolvable;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#rule Wafv2RuleGroup#rule}
    */
    readonly rule?: Wafv2RuleGroupRule[] | cdktf.IResolvable;
    /**
    * visibility_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group#visibility_config Wafv2RuleGroup#visibility_config}
    */
    readonly visibilityConfig: Wafv2RuleGroupVisibilityConfig;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group aws_wafv2_rule_group}
*/
export declare class Wafv2RuleGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_wafv2_rule_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/wafv2_rule_group aws_wafv2_rule_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Wafv2RuleGroupConfig
    */
    constructor(scope: Construct, id: string, config: Wafv2RuleGroupConfig);
    get arn(): string;
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get lockToken(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _customResponseBody?;
    get customResponseBody(): Wafv2RuleGroupCustomResponseBody[] | cdktf.IResolvable;
    set customResponseBody(value: Wafv2RuleGroupCustomResponseBody[] | cdktf.IResolvable);
    resetCustomResponseBody(): void;
    get customResponseBodyInput(): cdktf.IResolvable | Wafv2RuleGroupCustomResponseBody[] | undefined;
    private _rule?;
    get rule(): Wafv2RuleGroupRule[] | cdktf.IResolvable;
    set rule(value: Wafv2RuleGroupRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | Wafv2RuleGroupRule[] | undefined;
    private _visibilityConfig;
    get visibilityConfig(): Wafv2RuleGroupVisibilityConfigOutputReference;
    putVisibilityConfig(value: Wafv2RuleGroupVisibilityConfig): void;
    get visibilityConfigInput(): Wafv2RuleGroupVisibilityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=wafv2-rule-group.d.ts.map