import { Wafv2WebAclCustomResponseBody, Wafv2WebAclDefaultAction, Wafv2WebAclRule, Wafv2WebAclVisibilityConfig } from './wafv2-web-acl-structs';
import { Wafv2WebAclDefaultActionOutputReference, Wafv2WebAclVisibilityConfigOutputReference } from './wafv2-web-acl-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS WAF V2
*/
export interface Wafv2WebAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#description Wafv2WebAcl#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#name Wafv2WebAcl#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#scope Wafv2WebAcl#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#tags Wafv2WebAcl#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#tags_all Wafv2WebAcl#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * custom_response_body block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#custom_response_body Wafv2WebAcl#custom_response_body}
    */
    readonly customResponseBody?: Wafv2WebAclCustomResponseBody[] | cdktf.IResolvable;
    /**
    * default_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#default_action Wafv2WebAcl#default_action}
    */
    readonly defaultAction: Wafv2WebAclDefaultAction;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#rule Wafv2WebAcl#rule}
    */
    readonly rule?: Wafv2WebAclRule[] | cdktf.IResolvable;
    /**
    * visibility_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl#visibility_config Wafv2WebAcl#visibility_config}
    */
    readonly visibilityConfig: Wafv2WebAclVisibilityConfig;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl aws_wafv2_web_acl}
*/
export declare class Wafv2WebAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_wafv2_web_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl aws_wafv2_web_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Wafv2WebAclConfig
    */
    constructor(scope: Construct, id: string, config: Wafv2WebAclConfig);
    get arn(): string;
    get capacity(): number;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get lockToken(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _customResponseBody?;
    get customResponseBody(): Wafv2WebAclCustomResponseBody[] | cdktf.IResolvable;
    set customResponseBody(value: Wafv2WebAclCustomResponseBody[] | cdktf.IResolvable);
    resetCustomResponseBody(): void;
    get customResponseBodyInput(): cdktf.IResolvable | Wafv2WebAclCustomResponseBody[] | undefined;
    private _defaultAction;
    get defaultAction(): Wafv2WebAclDefaultActionOutputReference;
    putDefaultAction(value: Wafv2WebAclDefaultAction): void;
    get defaultActionInput(): Wafv2WebAclDefaultAction | undefined;
    private _rule?;
    get rule(): Wafv2WebAclRule[] | cdktf.IResolvable;
    set rule(value: Wafv2WebAclRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | Wafv2WebAclRule[] | undefined;
    private _visibilityConfig;
    get visibilityConfig(): Wafv2WebAclVisibilityConfigOutputReference;
    putVisibilityConfig(value: Wafv2WebAclVisibilityConfig): void;
    get visibilityConfigInput(): Wafv2WebAclVisibilityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=wafv2-web-acl.d.ts.map