"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspacesDirectory = exports.WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference = exports.workspacesDirectoryWorkspaceCreationPropertiesToTerraform = exports.WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference = exports.workspacesDirectoryWorkspaceAccessPropertiesToTerraform = exports.WorkspacesDirectorySelfServicePermissionsOutputReference = exports.workspacesDirectorySelfServicePermissionsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function workspacesDirectorySelfServicePermissionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_compute_type: cdktf.booleanToTerraform(struct.changeComputeType),
        increase_volume_size: cdktf.booleanToTerraform(struct.increaseVolumeSize),
        rebuild_workspace: cdktf.booleanToTerraform(struct.rebuildWorkspace),
        restart_workspace: cdktf.booleanToTerraform(struct.restartWorkspace),
        switch_running_mode: cdktf.booleanToTerraform(struct.switchRunningMode),
    };
}
exports.workspacesDirectorySelfServicePermissionsToTerraform = workspacesDirectorySelfServicePermissionsToTerraform;
class WorkspacesDirectorySelfServicePermissionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeComputeType !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeComputeType = this._changeComputeType;
        }
        if (this._increaseVolumeSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.increaseVolumeSize = this._increaseVolumeSize;
        }
        if (this._rebuildWorkspace !== undefined) {
            hasAnyValues = true;
            internalValueResult.rebuildWorkspace = this._rebuildWorkspace;
        }
        if (this._restartWorkspace !== undefined) {
            hasAnyValues = true;
            internalValueResult.restartWorkspace = this._restartWorkspace;
        }
        if (this._switchRunningMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.switchRunningMode = this._switchRunningMode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeComputeType = undefined;
            this._increaseVolumeSize = undefined;
            this._rebuildWorkspace = undefined;
            this._restartWorkspace = undefined;
            this._switchRunningMode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeComputeType = value.changeComputeType;
            this._increaseVolumeSize = value.increaseVolumeSize;
            this._rebuildWorkspace = value.rebuildWorkspace;
            this._restartWorkspace = value.restartWorkspace;
            this._switchRunningMode = value.switchRunningMode;
        }
    }
    get changeComputeType() {
        return this.getBooleanAttribute('change_compute_type');
    }
    set changeComputeType(value) {
        this._changeComputeType = value;
    }
    resetChangeComputeType() {
        this._changeComputeType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeComputeTypeInput() {
        return this._changeComputeType;
    }
    get increaseVolumeSize() {
        return this.getBooleanAttribute('increase_volume_size');
    }
    set increaseVolumeSize(value) {
        this._increaseVolumeSize = value;
    }
    resetIncreaseVolumeSize() {
        this._increaseVolumeSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get increaseVolumeSizeInput() {
        return this._increaseVolumeSize;
    }
    get rebuildWorkspace() {
        return this.getBooleanAttribute('rebuild_workspace');
    }
    set rebuildWorkspace(value) {
        this._rebuildWorkspace = value;
    }
    resetRebuildWorkspace() {
        this._rebuildWorkspace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rebuildWorkspaceInput() {
        return this._rebuildWorkspace;
    }
    get restartWorkspace() {
        return this.getBooleanAttribute('restart_workspace');
    }
    set restartWorkspace(value) {
        this._restartWorkspace = value;
    }
    resetRestartWorkspace() {
        this._restartWorkspace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restartWorkspaceInput() {
        return this._restartWorkspace;
    }
    get switchRunningMode() {
        return this.getBooleanAttribute('switch_running_mode');
    }
    set switchRunningMode(value) {
        this._switchRunningMode = value;
    }
    resetSwitchRunningMode() {
        this._switchRunningMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get switchRunningModeInput() {
        return this._switchRunningMode;
    }
}
exports.WorkspacesDirectorySelfServicePermissionsOutputReference = WorkspacesDirectorySelfServicePermissionsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
WorkspacesDirectorySelfServicePermissionsOutputReference[_a] = { fqn: "@cdktf/provider-aws.workspaces.WorkspacesDirectorySelfServicePermissionsOutputReference", version: "7.0.64" };
function workspacesDirectoryWorkspaceAccessPropertiesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        device_type_android: cdktf.stringToTerraform(struct.deviceTypeAndroid),
        device_type_chromeos: cdktf.stringToTerraform(struct.deviceTypeChromeos),
        device_type_ios: cdktf.stringToTerraform(struct.deviceTypeIos),
        device_type_linux: cdktf.stringToTerraform(struct.deviceTypeLinux),
        device_type_osx: cdktf.stringToTerraform(struct.deviceTypeOsx),
        device_type_web: cdktf.stringToTerraform(struct.deviceTypeWeb),
        device_type_windows: cdktf.stringToTerraform(struct.deviceTypeWindows),
        device_type_zeroclient: cdktf.stringToTerraform(struct.deviceTypeZeroclient),
    };
}
exports.workspacesDirectoryWorkspaceAccessPropertiesToTerraform = workspacesDirectoryWorkspaceAccessPropertiesToTerraform;
class WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deviceTypeAndroid !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeAndroid = this._deviceTypeAndroid;
        }
        if (this._deviceTypeChromeos !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeChromeos = this._deviceTypeChromeos;
        }
        if (this._deviceTypeIos !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeIos = this._deviceTypeIos;
        }
        if (this._deviceTypeLinux !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeLinux = this._deviceTypeLinux;
        }
        if (this._deviceTypeOsx !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeOsx = this._deviceTypeOsx;
        }
        if (this._deviceTypeWeb !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeWeb = this._deviceTypeWeb;
        }
        if (this._deviceTypeWindows !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeWindows = this._deviceTypeWindows;
        }
        if (this._deviceTypeZeroclient !== undefined) {
            hasAnyValues = true;
            internalValueResult.deviceTypeZeroclient = this._deviceTypeZeroclient;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deviceTypeAndroid = undefined;
            this._deviceTypeChromeos = undefined;
            this._deviceTypeIos = undefined;
            this._deviceTypeLinux = undefined;
            this._deviceTypeOsx = undefined;
            this._deviceTypeWeb = undefined;
            this._deviceTypeWindows = undefined;
            this._deviceTypeZeroclient = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deviceTypeAndroid = value.deviceTypeAndroid;
            this._deviceTypeChromeos = value.deviceTypeChromeos;
            this._deviceTypeIos = value.deviceTypeIos;
            this._deviceTypeLinux = value.deviceTypeLinux;
            this._deviceTypeOsx = value.deviceTypeOsx;
            this._deviceTypeWeb = value.deviceTypeWeb;
            this._deviceTypeWindows = value.deviceTypeWindows;
            this._deviceTypeZeroclient = value.deviceTypeZeroclient;
        }
    }
    get deviceTypeAndroid() {
        return this.getStringAttribute('device_type_android');
    }
    set deviceTypeAndroid(value) {
        this._deviceTypeAndroid = value;
    }
    resetDeviceTypeAndroid() {
        this._deviceTypeAndroid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeAndroidInput() {
        return this._deviceTypeAndroid;
    }
    get deviceTypeChromeos() {
        return this.getStringAttribute('device_type_chromeos');
    }
    set deviceTypeChromeos(value) {
        this._deviceTypeChromeos = value;
    }
    resetDeviceTypeChromeos() {
        this._deviceTypeChromeos = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeChromeosInput() {
        return this._deviceTypeChromeos;
    }
    get deviceTypeIos() {
        return this.getStringAttribute('device_type_ios');
    }
    set deviceTypeIos(value) {
        this._deviceTypeIos = value;
    }
    resetDeviceTypeIos() {
        this._deviceTypeIos = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeIosInput() {
        return this._deviceTypeIos;
    }
    get deviceTypeLinux() {
        return this.getStringAttribute('device_type_linux');
    }
    set deviceTypeLinux(value) {
        this._deviceTypeLinux = value;
    }
    resetDeviceTypeLinux() {
        this._deviceTypeLinux = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeLinuxInput() {
        return this._deviceTypeLinux;
    }
    get deviceTypeOsx() {
        return this.getStringAttribute('device_type_osx');
    }
    set deviceTypeOsx(value) {
        this._deviceTypeOsx = value;
    }
    resetDeviceTypeOsx() {
        this._deviceTypeOsx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeOsxInput() {
        return this._deviceTypeOsx;
    }
    get deviceTypeWeb() {
        return this.getStringAttribute('device_type_web');
    }
    set deviceTypeWeb(value) {
        this._deviceTypeWeb = value;
    }
    resetDeviceTypeWeb() {
        this._deviceTypeWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeWebInput() {
        return this._deviceTypeWeb;
    }
    get deviceTypeWindows() {
        return this.getStringAttribute('device_type_windows');
    }
    set deviceTypeWindows(value) {
        this._deviceTypeWindows = value;
    }
    resetDeviceTypeWindows() {
        this._deviceTypeWindows = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeWindowsInput() {
        return this._deviceTypeWindows;
    }
    get deviceTypeZeroclient() {
        return this.getStringAttribute('device_type_zeroclient');
    }
    set deviceTypeZeroclient(value) {
        this._deviceTypeZeroclient = value;
    }
    resetDeviceTypeZeroclient() {
        this._deviceTypeZeroclient = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceTypeZeroclientInput() {
        return this._deviceTypeZeroclient;
    }
}
exports.WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference = WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference[_b] = { fqn: "@cdktf/provider-aws.workspaces.WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference", version: "7.0.64" };
function workspacesDirectoryWorkspaceCreationPropertiesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        custom_security_group_id: cdktf.stringToTerraform(struct.customSecurityGroupId),
        default_ou: cdktf.stringToTerraform(struct.defaultOu),
        enable_internet_access: cdktf.booleanToTerraform(struct.enableInternetAccess),
        enable_maintenance_mode: cdktf.booleanToTerraform(struct.enableMaintenanceMode),
        user_enabled_as_local_administrator: cdktf.booleanToTerraform(struct.userEnabledAsLocalAdministrator),
    };
}
exports.workspacesDirectoryWorkspaceCreationPropertiesToTerraform = workspacesDirectoryWorkspaceCreationPropertiesToTerraform;
class WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._customSecurityGroupId !== undefined) {
            hasAnyValues = true;
            internalValueResult.customSecurityGroupId = this._customSecurityGroupId;
        }
        if (this._defaultOu !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultOu = this._defaultOu;
        }
        if (this._enableInternetAccess !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableInternetAccess = this._enableInternetAccess;
        }
        if (this._enableMaintenanceMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableMaintenanceMode = this._enableMaintenanceMode;
        }
        if (this._userEnabledAsLocalAdministrator !== undefined) {
            hasAnyValues = true;
            internalValueResult.userEnabledAsLocalAdministrator = this._userEnabledAsLocalAdministrator;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._customSecurityGroupId = undefined;
            this._defaultOu = undefined;
            this._enableInternetAccess = undefined;
            this._enableMaintenanceMode = undefined;
            this._userEnabledAsLocalAdministrator = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._customSecurityGroupId = value.customSecurityGroupId;
            this._defaultOu = value.defaultOu;
            this._enableInternetAccess = value.enableInternetAccess;
            this._enableMaintenanceMode = value.enableMaintenanceMode;
            this._userEnabledAsLocalAdministrator = value.userEnabledAsLocalAdministrator;
        }
    }
    get customSecurityGroupId() {
        return this.getStringAttribute('custom_security_group_id');
    }
    set customSecurityGroupId(value) {
        this._customSecurityGroupId = value;
    }
    resetCustomSecurityGroupId() {
        this._customSecurityGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customSecurityGroupIdInput() {
        return this._customSecurityGroupId;
    }
    get defaultOu() {
        return this.getStringAttribute('default_ou');
    }
    set defaultOu(value) {
        this._defaultOu = value;
    }
    resetDefaultOu() {
        this._defaultOu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultOuInput() {
        return this._defaultOu;
    }
    get enableInternetAccess() {
        return this.getBooleanAttribute('enable_internet_access');
    }
    set enableInternetAccess(value) {
        this._enableInternetAccess = value;
    }
    resetEnableInternetAccess() {
        this._enableInternetAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableInternetAccessInput() {
        return this._enableInternetAccess;
    }
    get enableMaintenanceMode() {
        return this.getBooleanAttribute('enable_maintenance_mode');
    }
    set enableMaintenanceMode(value) {
        this._enableMaintenanceMode = value;
    }
    resetEnableMaintenanceMode() {
        this._enableMaintenanceMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMaintenanceModeInput() {
        return this._enableMaintenanceMode;
    }
    get userEnabledAsLocalAdministrator() {
        return this.getBooleanAttribute('user_enabled_as_local_administrator');
    }
    set userEnabledAsLocalAdministrator(value) {
        this._userEnabledAsLocalAdministrator = value;
    }
    resetUserEnabledAsLocalAdministrator() {
        this._userEnabledAsLocalAdministrator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userEnabledAsLocalAdministratorInput() {
        return this._userEnabledAsLocalAdministrator;
    }
}
exports.WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference = WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference[_c] = { fqn: "@cdktf/provider-aws.workspaces.WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference", version: "7.0.64" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/workspaces_directory aws_workspaces_directory}
*/
class WorkspacesDirectory extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/workspaces_directory aws_workspaces_directory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkspacesDirectoryConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_workspaces_directory',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // self_service_permissions - computed: false, optional: true, required: false
        this._selfServicePermissions = new WorkspacesDirectorySelfServicePermissionsOutputReference(this, "self_service_permissions");
        // workspace_access_properties - computed: false, optional: true, required: false
        this._workspaceAccessProperties = new WorkspacesDirectoryWorkspaceAccessPropertiesOutputReference(this, "workspace_access_properties");
        // workspace_creation_properties - computed: false, optional: true, required: false
        this._workspaceCreationProperties = new WorkspacesDirectoryWorkspaceCreationPropertiesOutputReference(this, "workspace_creation_properties");
        this._directoryId = config.directoryId;
        this._ipGroupIds = config.ipGroupIds;
        this._subnetIds = config.subnetIds;
        this._tags = config.tags;
        this._tagsAll = config.tagsAll;
        this._selfServicePermissions.internalValue = config.selfServicePermissions;
        this._workspaceAccessProperties.internalValue = config.workspaceAccessProperties;
        this._workspaceCreationProperties.internalValue = config.workspaceCreationProperties;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // alias - computed: true, optional: false, required: false
    get alias() {
        return this.getStringAttribute('alias');
    }
    // customer_user_name - computed: true, optional: false, required: false
    get customerUserName() {
        return this.getStringAttribute('customer_user_name');
    }
    get directoryId() {
        return this.getStringAttribute('directory_id');
    }
    set directoryId(value) {
        this._directoryId = value;
    }
    // Temporarily expose input value. Use with caution.
    get directoryIdInput() {
        return this._directoryId;
    }
    // directory_name - computed: true, optional: false, required: false
    get directoryName() {
        return this.getStringAttribute('directory_name');
    }
    // directory_type - computed: true, optional: false, required: false
    get directoryType() {
        return this.getStringAttribute('directory_type');
    }
    // dns_ip_addresses - computed: true, optional: false, required: false
    get dnsIpAddresses() {
        return cdktf.Fn.tolist(this.getListAttribute('dns_ip_addresses'));
    }
    // iam_role_id - computed: true, optional: false, required: false
    get iamRoleId() {
        return this.getStringAttribute('iam_role_id');
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ipGroupIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ip_group_ids'));
    }
    set ipGroupIds(value) {
        this._ipGroupIds = value;
    }
    resetIpGroupIds() {
        this._ipGroupIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipGroupIdsInput() {
        return this._ipGroupIds;
    }
    // registration_code - computed: true, optional: false, required: false
    get registrationCode() {
        return this.getStringAttribute('registration_code');
    }
    get subnetIds() {
        return cdktf.Fn.tolist(this.getListAttribute('subnet_ids'));
    }
    set subnetIds(value) {
        this._subnetIds = value;
    }
    resetSubnetIds() {
        this._subnetIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetIdsInput() {
        return this._subnetIds;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get tagsAll() {
        return this.getStringMapAttribute('tags_all');
    }
    set tagsAll(value) {
        this._tagsAll = value;
    }
    resetTagsAll() {
        this._tagsAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsAllInput() {
        return this._tagsAll;
    }
    // workspace_security_group_id - computed: true, optional: false, required: false
    get workspaceSecurityGroupId() {
        return this.getStringAttribute('workspace_security_group_id');
    }
    get selfServicePermissions() {
        return this._selfServicePermissions;
    }
    putSelfServicePermissions(value) {
        this._selfServicePermissions.internalValue = value;
    }
    resetSelfServicePermissions() {
        this._selfServicePermissions.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get selfServicePermissionsInput() {
        return this._selfServicePermissions.internalValue;
    }
    get workspaceAccessProperties() {
        return this._workspaceAccessProperties;
    }
    putWorkspaceAccessProperties(value) {
        this._workspaceAccessProperties.internalValue = value;
    }
    resetWorkspaceAccessProperties() {
        this._workspaceAccessProperties.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceAccessPropertiesInput() {
        return this._workspaceAccessProperties.internalValue;
    }
    get workspaceCreationProperties() {
        return this._workspaceCreationProperties;
    }
    putWorkspaceCreationProperties(value) {
        this._workspaceCreationProperties.internalValue = value;
    }
    resetWorkspaceCreationProperties() {
        this._workspaceCreationProperties.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceCreationPropertiesInput() {
        return this._workspaceCreationProperties.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            directory_id: cdktf.stringToTerraform(this._directoryId),
            ip_group_ids: cdktf.listMapper(cdktf.stringToTerraform)(this._ipGroupIds),
            subnet_ids: cdktf.listMapper(cdktf.stringToTerraform)(this._subnetIds),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            tags_all: cdktf.hashMapper(cdktf.stringToTerraform)(this._tagsAll),
            self_service_permissions: workspacesDirectorySelfServicePermissionsToTerraform(this._selfServicePermissions.internalValue),
            workspace_access_properties: workspacesDirectoryWorkspaceAccessPropertiesToTerraform(this._workspaceAccessProperties.internalValue),
            workspace_creation_properties: workspacesDirectoryWorkspaceCreationPropertiesToTerraform(this._workspaceCreationProperties.internalValue),
        };
    }
}
exports.WorkspacesDirectory = WorkspacesDirectory;
_d = JSII_RTTI_SYMBOL_1;
WorkspacesDirectory[_d] = { fqn: "@cdktf/provider-aws.workspaces.WorkspacesDirectory", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
WorkspacesDirectory.tfResourceType = "aws_workspaces_directory";
//# sourceMappingURL=data:application/json;base64,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