# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'DatabaseReadReplicaArgs',
    'DatabaseReadReplicaArgsDict',
    'DatabaseUserAccessControlArgs',
    'DatabaseUserAccessControlArgsDict',
    'InstanceBackupsScheduleArgs',
    'InstanceBackupsScheduleArgsDict',
    'KubernetesNodePoolsArgs',
    'KubernetesNodePoolsArgsDict',
    'KubernetesNodePoolsNodeArgs',
    'KubernetesNodePoolsNodeArgsDict',
    'KubernetesNodePoolsTaintArgs',
    'KubernetesNodePoolsTaintArgsDict',
    'LoadBalancerFirewallRuleArgs',
    'LoadBalancerFirewallRuleArgsDict',
    'LoadBalancerForwardingRuleArgs',
    'LoadBalancerForwardingRuleArgsDict',
    'LoadBalancerHealthCheckArgs',
    'LoadBalancerHealthCheckArgsDict',
    'LoadBalancerSslArgs',
    'LoadBalancerSslArgsDict',
    'VirtualFileSystemStorageAttachmentArgs',
    'VirtualFileSystemStorageAttachmentArgsDict',
    'GetApplicationFilterArgs',
    'GetApplicationFilterArgsDict',
    'GetBackupFilterArgs',
    'GetBackupFilterArgsDict',
    'GetBareMetalPlanFilterArgs',
    'GetBareMetalPlanFilterArgsDict',
    'GetBareMetalServerFilterArgs',
    'GetBareMetalServerFilterArgsDict',
    'GetBlockStorageFilterArgs',
    'GetBlockStorageFilterArgsDict',
    'GetContainerRegistryFilterArgs',
    'GetContainerRegistryFilterArgsDict',
    'GetDatabaseFilterArgs',
    'GetDatabaseFilterArgsDict',
    'GetFirewallGroupFilterArgs',
    'GetFirewallGroupFilterArgsDict',
    'GetInferenceFilterArgs',
    'GetInferenceFilterArgsDict',
    'GetInstanceFilterArgs',
    'GetInstanceFilterArgsDict',
    'GetInstanceIpv4FilterArgs',
    'GetInstanceIpv4FilterArgsDict',
    'GetInstancesFilterArgs',
    'GetInstancesFilterArgsDict',
    'GetIsoPrivateFilterArgs',
    'GetIsoPrivateFilterArgsDict',
    'GetIsoPublicFilterArgs',
    'GetIsoPublicFilterArgsDict',
    'GetKubernetesFilterArgs',
    'GetKubernetesFilterArgsDict',
    'GetLoadBalancerFilterArgs',
    'GetLoadBalancerFilterArgsDict',
    'GetObjectStorageClusterFilterArgs',
    'GetObjectStorageClusterFilterArgsDict',
    'GetObjectStorageFilterArgs',
    'GetObjectStorageFilterArgsDict',
    'GetObjectStorageTierFilterArgs',
    'GetObjectStorageTierFilterArgsDict',
    'GetOsFilterArgs',
    'GetOsFilterArgsDict',
    'GetPlanFilterArgs',
    'GetPlanFilterArgsDict',
    'GetRegionFilterArgs',
    'GetRegionFilterArgsDict',
    'GetReservedIpFilterArgs',
    'GetReservedIpFilterArgsDict',
    'GetReverseIpv4FilterArgs',
    'GetReverseIpv4FilterArgsDict',
    'GetReverseIpv6FilterArgs',
    'GetReverseIpv6FilterArgsDict',
    'GetSnapshotFilterArgs',
    'GetSnapshotFilterArgsDict',
    'GetSshKeyFilterArgs',
    'GetSshKeyFilterArgsDict',
    'GetStartupScriptFilterArgs',
    'GetStartupScriptFilterArgsDict',
    'GetUserFilterArgs',
    'GetUserFilterArgsDict',
    'GetVirtualFileSystemStorageFilterArgs',
    'GetVirtualFileSystemStorageFilterArgsDict',
    'GetVpc2FilterArgs',
    'GetVpc2FilterArgsDict',
    'GetVpcFilterArgs',
    'GetVpcFilterArgsDict',
]

MYPY = False

if not MYPY:
    class DatabaseReadReplicaArgsDict(TypedDict):
        label: pulumi.Input[_builtins.str]
        """
        A label for the managed database.
        """
        region: pulumi.Input[_builtins.str]
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        backup_hour: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        backup_minute: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        cluster_time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        database_engine: NotRequired[pulumi.Input[_builtins.str]]
        """
        The database engine of the new managed database.
        """
        database_engine_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The database engine version of the new managed database.
        """
        date_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date the managed database was added to your Vultr account.
        """
        dbname: NotRequired[pulumi.Input[_builtins.str]]
        """
        The managed database's default logical database.
        """
        eviction_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        ferretdb_credentials: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The hostname assigned to the managed database.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the managed database.
        """
        latest_backup: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date of the latest backup available on the managed database.
        """
        maintenance_dow: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred maintenance day of week for the managed database.
        """
        maintenance_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred maintenance time for the managed database.
        """
        mysql_long_query_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        mysql_require_primary_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        mysql_slow_query_log: NotRequired[pulumi.Input[_builtins.bool]]
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        mysql_sql_modes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        The password for the managed database's primary admin user.
        """
        plan: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        plan_disk: NotRequired[pulumi.Input[_builtins.int]]
        """
        The description of the disk(s) on the managed database.
        """
        plan_ram: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of memory available on the managed database in MB.
        """
        plan_replicas: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        plan_vcpus: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of virtual CPUs available on the managed database.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection port for the managed database.
        """
        public_host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        tag: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag to assign to the managed database.
        """
        trusted_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of allowed IP addresses for the managed database.
        """
        user: NotRequired[pulumi.Input[_builtins.str]]
        """
        The primary admin user for the managed database.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
elif False:
    DatabaseReadReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseReadReplicaArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 dbname: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_vcpus: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] label: A label for the managed database.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the new managed database.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the new managed database.
        :param pulumi.Input[_builtins.str] date_created: The date the managed database was added to your Vultr account.
        :param pulumi.Input[_builtins.str] dbname: The managed database's default logical database.
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param pulumi.Input[_builtins.str] host: The hostname assigned to the managed database.
        :param pulumi.Input[_builtins.str] id: The ID of the managed database.
        :param pulumi.Input[_builtins.str] latest_backup: The date of the latest backup available on the managed database.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param pulumi.Input[_builtins.str] password: The password for the managed database's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database.
        :param pulumi.Input[_builtins.int] plan_ram: The amount of memory available on the managed database in MB.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param pulumi.Input[_builtins.int] plan_vcpus: The number of virtual CPUs available on the managed database.
        :param pulumi.Input[_builtins.str] port: The connection port for the managed database.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param pulumi.Input[_builtins.str] status: The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database.
        :param pulumi.Input[_builtins.str] user: The primary admin user for the managed database.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if database_engine is not None:
            pulumi.set(__self__, "database_engine", database_engine)
        if database_engine_version is not None:
            pulumi.set(__self__, "database_engine_version", database_engine_version)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if latest_backup is not None:
            pulumi.set(__self__, "latest_backup", latest_backup)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_ram is not None:
            pulumi.set(__self__, "plan_ram", plan_ram)
        if plan_replicas is not None:
            pulumi.set(__self__, "plan_replicas", plan_replicas)
        if plan_vcpus is not None:
            pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A label for the managed database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine of the new managed database.
        """
        return pulumi.get(self, "database_engine")

    @database_engine.setter
    def database_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine version of the new managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @database_engine_version.setter
    def database_engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine_version", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbname", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ferretdb_credentials")

    @ferretdb_credentials.setter
    def ferretdb_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ferretdb_credentials", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the managed database.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @latest_backup.setter
    def latest_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_backup", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @mysql_long_query_time.setter
    def mysql_long_query_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @mysql_require_primary_key.setter
    def mysql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @mysql_slow_query_log.setter
    def mysql_slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @mysql_sql_modes.setter
    def mysql_sql_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_sql_modes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @plan_disk.setter
    def plan_disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_disk", value)

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @plan_ram.setter
    def plan_ram(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_ram", value)

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        return pulumi.get(self, "plan_replicas")

    @plan_replicas.setter
    def plan_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_replicas", value)

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @plan_vcpus.setter
    def plan_vcpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_vcpus", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @public_host.setter
    def public_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_host", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to assign to the managed database.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @trusted_ips.setter
    def trusted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_ips", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class DatabaseUserAccessControlArgsDict(TypedDict):
        acl_categories: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of command category rules for this managed database user.
        """
        acl_channels: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of publish/subscribe channel patterns for this managed database user.
        """
        acl_commands: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of individual command rules for this managed database user.
        """
        acl_keys: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of access rules for this managed database user.
        """
elif False:
    DatabaseUserAccessControlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseUserAccessControlArgs:
    def __init__(__self__, *,
                 acl_categories: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 acl_channels: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 acl_commands: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 acl_keys: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_categories: The list of command category rules for this managed database user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_channels: The list of publish/subscribe channel patterns for this managed database user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_commands: The list of individual command rules for this managed database user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_keys: The list of access rules for this managed database user.
        """
        pulumi.set(__self__, "acl_categories", acl_categories)
        pulumi.set(__self__, "acl_channels", acl_channels)
        pulumi.set(__self__, "acl_commands", acl_commands)
        pulumi.set(__self__, "acl_keys", acl_keys)

    @_builtins.property
    @pulumi.getter(name="aclCategories")
    def acl_categories(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of command category rules for this managed database user.
        """
        return pulumi.get(self, "acl_categories")

    @acl_categories.setter
    def acl_categories(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "acl_categories", value)

    @_builtins.property
    @pulumi.getter(name="aclChannels")
    def acl_channels(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of publish/subscribe channel patterns for this managed database user.
        """
        return pulumi.get(self, "acl_channels")

    @acl_channels.setter
    def acl_channels(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "acl_channels", value)

    @_builtins.property
    @pulumi.getter(name="aclCommands")
    def acl_commands(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of individual command rules for this managed database user.
        """
        return pulumi.get(self, "acl_commands")

    @acl_commands.setter
    def acl_commands(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "acl_commands", value)

    @_builtins.property
    @pulumi.getter(name="aclKeys")
    def acl_keys(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of access rules for this managed database user.
        """
        return pulumi.get(self, "acl_keys")

    @acl_keys.setter
    def acl_keys(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "acl_keys", value)


if not MYPY:
    class InstanceBackupsScheduleArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        """
        dom: NotRequired[pulumi.Input[_builtins.int]]
        """
        Day of month to run. Use values between 1 and 28.
        """
        dow: NotRequired[pulumi.Input[_builtins.int]]
        """
        Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        """
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Hour of day to run in UTC.
        """
elif False:
    InstanceBackupsScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBackupsScheduleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 dom: Optional[pulumi.Input[_builtins.int]] = None,
                 dow: Optional[pulumi.Input[_builtins.int]] = None,
                 hour: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        :param pulumi.Input[_builtins.int] dom: Day of month to run. Use values between 1 and 28.
        :param pulumi.Input[_builtins.int] dow: Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        :param pulumi.Input[_builtins.int] hour: Hour of day to run in UTC.
        """
        pulumi.set(__self__, "type", type)
        if dom is not None:
            pulumi.set(__self__, "dom", dom)
        if dow is not None:
            pulumi.set(__self__, "dow", dow)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def dom(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Day of month to run. Use values between 1 and 28.
        """
        return pulumi.get(self, "dom")

    @dom.setter
    def dom(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dom", value)

    @_builtins.property
    @pulumi.getter
    def dow(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        """
        return pulumi.get(self, "dow")

    @dow.setter
    def dow(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dow", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Hour of day to run in UTC.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)


if not MYPY:
    class KubernetesNodePoolsArgsDict(TypedDict):
        label: pulumi.Input[_builtins.str]
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        node_quantity: pulumi.Input[_builtins.int]
        """
        The number of nodes in this node pool.
        """
        plan: pulumi.Input[_builtins.str]
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        auto_scaler: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable the auto scaler for the default node pool.
        """
        date_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date node was created.
        """
        date_updated: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date of node pool updates.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of node.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        max_nodes: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of nodes to use with the auto scaler.
        """
        min_nodes: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum number of nodes to use with the auto scaler.
        """
        nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgsDict']]]]
        """
        Array that contains information about nodes within this node pool.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Status of node.
        """
        tag: NotRequired[pulumi.Input[_builtins.str]]
        """
        Tag for node pool.
        """
        taints: NotRequired[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgsDict']]]]
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        user_data: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    KubernetesNodePoolsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubernetesNodePoolsArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 node_quantity: pulumi.Input[_builtins.int],
                 plan: pulumi.Input[_builtins.str],
                 auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[_builtins.int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[_builtins.str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[_builtins.bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.str] date_updated: Date of node pool updates.
        :param pulumi.Input[_builtins.str] id: ID of node.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value pairs for Kubernetes node labels.
        :param pulumi.Input[_builtins.int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]] nodes: Array that contains information about nodes within this node pool.
        :param pulumi.Input[_builtins.str] status: Status of node.
        :param pulumi.Input[_builtins.str] tag: Tag for node pool.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "plan", plan)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> pulumi.Input[_builtins.int]:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @node_quantity.setter
    def node_quantity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_quantity", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @auto_scaler.setter
    def auto_scaler(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaler", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @date_updated.setter
    def date_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_updated", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]:
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


if not MYPY:
    class KubernetesNodePoolsNodeArgsDict(TypedDict):
        date_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date node was created.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of node.
        """
        label: NotRequired[pulumi.Input[_builtins.str]]
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Status of node.
        """
elif False:
    KubernetesNodePoolsNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubernetesNodePoolsNodeArgs:
    def __init__(__self__, *,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.str] id: ID of node.
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[_builtins.str] status: Status of node.
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class KubernetesNodePoolsTaintArgsDict(TypedDict):
        effect: pulumi.Input[_builtins.str]
        key: pulumi.Input[_builtins.str]
        value: pulumi.Input[_builtins.str]
elif False:
    KubernetesNodePoolsTaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubernetesNodePoolsTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LoadBalancerFirewallRuleArgsDict(TypedDict):
        ip_type: pulumi.Input[_builtins.str]
        """
        The type of ip this rule is - may be either v4 or v6.
        """
        port: pulumi.Input[_builtins.int]
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        source: pulumi.Input[_builtins.str]
        """
        IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The load balancer ID.
        """
elif False:
    LoadBalancerFirewallRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerFirewallRuleArgs:
    def __init__(__self__, *,
                 ip_type: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 source: pulumi.Input[_builtins.str],
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_type: The type of ip this rule is - may be either v4 or v6.
        :param pulumi.Input[_builtins.int] port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param pulumi.Input[_builtins.str] source: IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        :param pulumi.Input[_builtins.str] id: The load balancer ID.
        """
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source", source)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of ip this rule is - may be either v4 or v6.
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class LoadBalancerForwardingRuleArgsDict(TypedDict):
        backend_port: pulumi.Input[_builtins.int]
        """
        Port on instance side.
        """
        backend_protocol: pulumi.Input[_builtins.str]
        """
        Protocol on instance side. Possible values: "http", "https", "tcp".
        """
        frontend_port: pulumi.Input[_builtins.int]
        """
        Port on load balancer side.
        """
        frontend_protocol: pulumi.Input[_builtins.str]
        """
        Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        rule_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    LoadBalancerForwardingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerForwardingRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[_builtins.int],
                 backend_protocol: pulumi.Input[_builtins.str],
                 frontend_port: pulumi.Input[_builtins.int],
                 frontend_protocol: pulumi.Input[_builtins.str],
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] backend_port: Port on instance side.
        :param pulumi.Input[_builtins.str] backend_protocol: Protocol on instance side. Possible values: "http", "https", "tcp".
        :param pulumi.Input[_builtins.int] frontend_port: Port on load balancer side.
        :param pulumi.Input[_builtins.str] frontend_protocol: Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "backend_protocol", backend_protocol)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "frontend_protocol", frontend_protocol)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[_builtins.int]:
        """
        Port on instance side.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backend_port", value)

    @_builtins.property
    @pulumi.getter(name="backendProtocol")
    def backend_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol on instance side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "backend_protocol")

    @backend_protocol.setter
    def backend_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_protocol", value)

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[_builtins.int]:
        """
        Port on load balancer side.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "frontend_port", value)

    @_builtins.property
    @pulumi.getter(name="frontendProtocol")
    def frontend_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "frontend_protocol")

    @frontend_protocol.setter
    def frontend_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frontend_protocol", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)


if not MYPY:
    class LoadBalancerHealthCheckArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        """
        check_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds to perform health check. Default value is 15.
        """
        healthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        response_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds to wait for a health check response. Default value is 5.
        """
        unhealthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
elif False:
    LoadBalancerHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerHealthCheckArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param pulumi.Input[_builtins.str] protocol: The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        :param pulumi.Input[_builtins.int] check_interval: Time in seconds to perform health check. Default value is 15.
        :param pulumi.Input[_builtins.int] healthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param pulumi.Input[_builtins.str] path: The path on the attached instances that the load balancer should check against. Default value is `/`
        :param pulumi.Input[_builtins.int] response_timeout: Time in seconds to wait for a health check response. Default value is 5.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds to perform health check. Default value is 15.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds to wait for a health check response. Default value is 5.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "response_timeout", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


if not MYPY:
    class LoadBalancerSslArgsDict(TypedDict):
        certificate: pulumi.Input[_builtins.str]
        """
        The SSL Certificate.
        """
        private_key: pulumi.Input[_builtins.str]
        """
        The SSL certificates private key.
        """
        chain: NotRequired[pulumi.Input[_builtins.str]]
        """
        The SSL certificate chain.
        """
elif False:
    LoadBalancerSslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerSslArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 chain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] certificate: The SSL Certificate.
        :param pulumi.Input[_builtins.str] private_key: The SSL certificates private key.
        :param pulumi.Input[_builtins.str] chain: The SSL certificate chain.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The SSL Certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The SSL certificates private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL certificate chain.
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)


if not MYPY:
    class VirtualFileSystemStorageAttachmentArgsDict(TypedDict):
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        mount: NotRequired[pulumi.Input[_builtins.int]]
        state: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    VirtualFileSystemStorageAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualFileSystemStorageAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class GetApplicationFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetApplicationFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetApplicationFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetBackupFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetBackupFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBackupFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetBareMetalPlanFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetBareMetalPlanFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBareMetalPlanFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetBareMetalServerFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetBareMetalServerFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBareMetalServerFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetBlockStorageFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetBlockStorageFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBlockStorageFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetContainerRegistryFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetContainerRegistryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetContainerRegistryFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetDatabaseFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetDatabaseFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDatabaseFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetFirewallGroupFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetFirewallGroupFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFirewallGroupFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetInferenceFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetInferenceFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInferenceFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetInstanceFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetInstanceFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInstanceFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetInstanceIpv4FilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values to filter with.
        """
elif False:
    GetInstanceIpv4FilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInstanceIpv4FilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetInstancesFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetInstancesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInstancesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetIsoPrivateFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetIsoPrivateFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIsoPrivateFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetIsoPublicFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetIsoPublicFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIsoPublicFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetKubernetesFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetKubernetesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetKubernetesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetLoadBalancerFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetLoadBalancerFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLoadBalancerFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetObjectStorageClusterFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetObjectStorageClusterFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetObjectStorageClusterFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetObjectStorageFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetObjectStorageFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetObjectStorageFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetObjectStorageTierFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetObjectStorageTierFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetObjectStorageTierFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetOsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetOsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetPlanFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetPlanFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPlanFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetRegionFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetRegionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetRegionFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetReservedIpFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetReservedIpFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetReservedIpFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetReverseIpv4FilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values to filter with.
        """
elif False:
    GetReverseIpv4FilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetReverseIpv4FilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetReverseIpv6FilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values to filter with.
        """
elif False:
    GetReverseIpv6FilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetReverseIpv6FilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetSnapshotFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetSnapshotFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSnapshotFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetSshKeyFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetSshKeyFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSshKeyFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetStartupScriptFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetStartupScriptFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetStartupScriptFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetUserFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetUserFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetUserFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetVirtualFileSystemStorageFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetVirtualFileSystemStorageFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVirtualFileSystemStorageFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetVpc2FilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetVpc2FilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVpc2FilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetVpcFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Attribute name to filter with.
        """
        values: Sequence[_builtins.str]
        """
        One or more values filter with.
        """
elif False:
    GetVpcFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetVpcFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


