# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BareMetalServerArgs', 'BareMetalServer']

@pulumi.input_type
class BareMetalServerArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[_builtins.int]] = None,
                 app_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mdisk_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 os_id: Optional[pulumi.Input[_builtins.int]] = None,
                 persistent_pxe: Optional[pulumi.Input[_builtins.bool]] = None,
                 reserved_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc2_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BareMetalServer resource.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[_builtins.str] region: The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[_builtins.int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_variables: A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[_builtins.str] hostname: The hostname to assign to the server.
        :param pulumi.Input[_builtins.str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[_builtins.str] label: A label for the server.
        :param pulumi.Input[_builtins.int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[_builtins.str] reserved_ipv4: The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        :param pulumi.Input[_builtins.str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the servier.
        :param pulumi.Input[_builtins.str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[_builtins.str] user_scheme: The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc2_ids: A list of VPC 2.0 IDs to be attached to the server.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID to use when creating the server.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if activation_email is not None:
            pulumi.set(__self__, "activation_email", activation_email)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_variables is not None:
            pulumi.set(__self__, "app_variables", app_variables)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mdisk_mode is not None:
            pulumi.set(__self__, "mdisk_mode", mdisk_mode)
        if os_id is not None:
            pulumi.set(__self__, "os_id", os_id)
        if persistent_pxe is not None:
            pulumi.set(__self__, "persistent_pxe", persistent_pxe)
        if reserved_ipv4 is not None:
            pulumi.set(__self__, "reserved_ipv4", reserved_ipv4)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_scheme is not None:
            pulumi.set(__self__, "user_scheme", user_scheme)
        if vpc2_ids is not None:
            warnings.warn("""VPC2 is deprecated and will be removed in a future release. Use VPC instead""", DeprecationWarning)
            pulumi.log.warn("""vpc2_ids is deprecated: VPC2 is deprecated and will be removed in a future release. Use VPC instead""")
        if vpc2_ids is not None:
            pulumi.set(__self__, "vpc2_ids", vpc2_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @activation_email.setter
    def activation_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activation_email", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="appVariables")
    def app_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        """
        return pulumi.get(self, "app_variables")

    @app_variables.setter
    def app_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_variables", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="mdiskMode")
    def mdisk_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mdisk_mode")

    @mdisk_mode.setter
    def mdisk_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdisk_mode", value)

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @os_id.setter
    def os_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_id", value)

    @_builtins.property
    @pulumi.getter(name="persistentPxe")
    def persistent_pxe(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "persistent_pxe")

    @persistent_pxe.setter
    def persistent_pxe(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "persistent_pxe", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpv4")
    def reserved_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        """
        return pulumi.get(self, "reserved_ipv4")

    @reserved_ipv4.setter
    def reserved_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the servier.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @user_scheme.setter
    def user_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_scheme", value)

    @_builtins.property
    @pulumi.getter(name="vpc2Ids")
    @_utilities.deprecated("""VPC2 is deprecated and will be removed in a future release. Use VPC instead""")
    def vpc2_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of VPC 2.0 IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc2_ids")

    @vpc2_ids.setter
    def vpc2_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc2_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID to use when creating the server.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _BareMetalServerState:
    def __init__(__self__, *,
                 activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[_builtins.int]] = None,
                 app_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 default_password: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_v4: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.int]] = None,
                 main_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 mdisk_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 netmask_v4: Optional[pulumi.Input[_builtins.str]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 os_id: Optional[pulumi.Input[_builtins.int]] = None,
                 persistent_pxe: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 ram: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 v6_main_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 v6_network: Optional[pulumi.Input[_builtins.str]] = None,
                 v6_network_size: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc2_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BareMetalServer resources.
        :param pulumi.Input[_builtins.bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[_builtins.int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_variables: A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        :param pulumi.Input[_builtins.int] cpu_count: The number of CPUs available on the server.
        :param pulumi.Input[_builtins.str] date_created: The date the server was added to your Vultr account.
        :param pulumi.Input[_builtins.str] default_password: The server's default password.
        :param pulumi.Input[_builtins.str] disk: The description of the disk(s) on the server.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[_builtins.str] gateway_v4: The server's IPv4 gateway.
        :param pulumi.Input[_builtins.str] hostname: The hostname to assign to the server.
        :param pulumi.Input[_builtins.str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[_builtins.str] label: A label for the server.
        :param pulumi.Input[_builtins.int] mac_address: The MAC address associated with the server.
        :param pulumi.Input[_builtins.str] main_ip: The server's main IP address.
        :param pulumi.Input[_builtins.str] netmask_v4: The server's IPv4 netmask.
        :param pulumi.Input[_builtins.str] os: The string description of the operating system installed on the server.
        :param pulumi.Input[_builtins.int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[_builtins.str] ram: The amount of memory available on the server in MB.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] reserved_ipv4: The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        :param pulumi.Input[_builtins.str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[_builtins.str] status: The status of the server's subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the servier.
        :param pulumi.Input[_builtins.str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[_builtins.str] user_scheme: The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        :param pulumi.Input[_builtins.str] v6_main_ip: The main IPv6 network address.
        :param pulumi.Input[_builtins.str] v6_network: The IPv6 subnet.
        :param pulumi.Input[_builtins.int] v6_network_size: The IPv6 network size in bits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc2_ids: A list of VPC 2.0 IDs to be attached to the server.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID to use when creating the server.
        """
        if activation_email is not None:
            pulumi.set(__self__, "activation_email", activation_email)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_variables is not None:
            pulumi.set(__self__, "app_variables", app_variables)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if default_password is not None:
            pulumi.set(__self__, "default_password", default_password)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if gateway_v4 is not None:
            pulumi.set(__self__, "gateway_v4", gateway_v4)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if main_ip is not None:
            pulumi.set(__self__, "main_ip", main_ip)
        if mdisk_mode is not None:
            pulumi.set(__self__, "mdisk_mode", mdisk_mode)
        if netmask_v4 is not None:
            pulumi.set(__self__, "netmask_v4", netmask_v4)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_id is not None:
            pulumi.set(__self__, "os_id", os_id)
        if persistent_pxe is not None:
            pulumi.set(__self__, "persistent_pxe", persistent_pxe)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ipv4 is not None:
            pulumi.set(__self__, "reserved_ipv4", reserved_ipv4)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_scheme is not None:
            pulumi.set(__self__, "user_scheme", user_scheme)
        if v6_main_ip is not None:
            pulumi.set(__self__, "v6_main_ip", v6_main_ip)
        if v6_network is not None:
            pulumi.set(__self__, "v6_network", v6_network)
        if v6_network_size is not None:
            pulumi.set(__self__, "v6_network_size", v6_network_size)
        if vpc2_ids is not None:
            warnings.warn("""VPC2 is deprecated and will be removed in a future release. Use VPC instead""", DeprecationWarning)
            pulumi.log.warn("""vpc2_ids is deprecated: VPC2 is deprecated and will be removed in a future release. Use VPC instead""")
        if vpc2_ids is not None:
            pulumi.set(__self__, "vpc2_ids", vpc2_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @activation_email.setter
    def activation_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activation_email", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="appVariables")
    def app_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        """
        return pulumi.get(self, "app_variables")

    @app_variables.setter
    def app_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_variables", value)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPUs available on the server.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="defaultPassword")
    def default_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server's default password.
        """
        return pulumi.get(self, "default_password")

    @default_password.setter
    def default_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_password", value)

    @_builtins.property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk", value)

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @gateway_v4.setter
    def gateway_v4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_v4", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The MAC address associated with the server.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @main_ip.setter
    def main_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_ip", value)

    @_builtins.property
    @pulumi.getter(name="mdiskMode")
    def mdisk_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mdisk_mode")

    @mdisk_mode.setter
    def mdisk_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdisk_mode", value)

    @_builtins.property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @netmask_v4.setter
    def netmask_v4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmask_v4", value)

    @_builtins.property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string description of the operating system installed on the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os", value)

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @os_id.setter
    def os_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_id", value)

    @_builtins.property
    @pulumi.getter(name="persistentPxe")
    def persistent_pxe(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "persistent_pxe")

    @persistent_pxe.setter
    def persistent_pxe(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "persistent_pxe", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def ram(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of memory available on the server in MB.
        """
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpv4")
    def reserved_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        """
        return pulumi.get(self, "reserved_ipv4")

    @reserved_ipv4.setter
    def reserved_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the servier.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @user_scheme.setter
    def user_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_scheme", value)

    @_builtins.property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @v6_main_ip.setter
    def v6_main_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "v6_main_ip", value)

    @_builtins.property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @v6_network.setter
    def v6_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "v6_network", value)

    @_builtins.property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @v6_network_size.setter
    def v6_network_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "v6_network_size", value)

    @_builtins.property
    @pulumi.getter(name="vpc2Ids")
    @_utilities.deprecated("""VPC2 is deprecated and will be removed in a future release. Use VPC instead""")
    def vpc2_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of VPC 2.0 IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc2_ids")

    @vpc2_ids.setter
    def vpc2_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc2_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID to use when creating the server.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("vultr:index/bareMetalServer:BareMetalServer")
class BareMetalServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[_builtins.int]] = None,
                 app_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mdisk_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 os_id: Optional[pulumi.Input[_builtins.int]] = None,
                 persistent_pxe: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc2_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr bare metal server resource. This can be used to create, read, modify, and delete bare metal servers on your Vultr account.

        ## Example Usage

        Create a new bare metal server:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_server = vultr.BareMetalServer("myServer",
            os_id=1743,
            plan="vbm-4c-32gb",
            region="ewr")
        ```

        Create a new bare metal server with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_server = vultr.BareMetalServer("myServer",
            activation_email=False,
            enable_ipv6=True,
            hostname="my-server-hostname",
            label="my-server-label",
            os_id=1743,
            plan="vbm-4c-32gb",
            region="ewr",
            tags=["my-server-tag"],
            user_data="this is my user data")
        ```

        ## Import

        Bare Metal Servers can be imported using the server `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/bareMetalServer:BareMetalServer my_server b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[_builtins.int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_variables: A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[_builtins.str] hostname: The hostname to assign to the server.
        :param pulumi.Input[_builtins.str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[_builtins.str] label: A label for the server.
        :param pulumi.Input[_builtins.int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[_builtins.str] region: The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] reserved_ipv4: The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        :param pulumi.Input[_builtins.str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the servier.
        :param pulumi.Input[_builtins.str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[_builtins.str] user_scheme: The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc2_ids: A list of VPC 2.0 IDs to be attached to the server.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID to use when creating the server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BareMetalServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr bare metal server resource. This can be used to create, read, modify, and delete bare metal servers on your Vultr account.

        ## Example Usage

        Create a new bare metal server:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_server = vultr.BareMetalServer("myServer",
            os_id=1743,
            plan="vbm-4c-32gb",
            region="ewr")
        ```

        Create a new bare metal server with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_server = vultr.BareMetalServer("myServer",
            activation_email=False,
            enable_ipv6=True,
            hostname="my-server-hostname",
            label="my-server-label",
            os_id=1743,
            plan="vbm-4c-32gb",
            region="ewr",
            tags=["my-server-tag"],
            user_data="this is my user data")
        ```

        ## Import

        Bare Metal Servers can be imported using the server `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/bareMetalServer:BareMetalServer my_server b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param BareMetalServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BareMetalServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_id: Optional[pulumi.Input[_builtins.int]] = None,
                 app_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mdisk_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 os_id: Optional[pulumi.Input[_builtins.int]] = None,
                 persistent_pxe: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc2_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BareMetalServerArgs.__new__(BareMetalServerArgs)

            __props__.__dict__["activation_email"] = activation_email
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["app_variables"] = app_variables
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["label"] = label
            __props__.__dict__["mdisk_mode"] = mdisk_mode
            __props__.__dict__["os_id"] = os_id
            __props__.__dict__["persistent_pxe"] = persistent_pxe
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_ipv4"] = reserved_ipv4
            __props__.__dict__["script_id"] = script_id
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["ssh_key_ids"] = ssh_key_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_scheme"] = user_scheme
            __props__.__dict__["vpc2_ids"] = vpc2_ids
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["default_password"] = None
            __props__.__dict__["disk"] = None
            __props__.__dict__["gateway_v4"] = None
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["main_ip"] = None
            __props__.__dict__["netmask_v4"] = None
            __props__.__dict__["os"] = None
            __props__.__dict__["ram"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["v6_main_ip"] = None
            __props__.__dict__["v6_network"] = None
            __props__.__dict__["v6_network_size"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["defaultPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BareMetalServer, __self__).__init__(
            'vultr:index/bareMetalServer:BareMetalServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
            app_id: Optional[pulumi.Input[_builtins.int]] = None,
            app_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            default_password: Optional[pulumi.Input[_builtins.str]] = None,
            disk: Optional[pulumi.Input[_builtins.str]] = None,
            enable_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            gateway_v4: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.int]] = None,
            main_ip: Optional[pulumi.Input[_builtins.str]] = None,
            mdisk_mode: Optional[pulumi.Input[_builtins.str]] = None,
            netmask_v4: Optional[pulumi.Input[_builtins.str]] = None,
            os: Optional[pulumi.Input[_builtins.str]] = None,
            os_id: Optional[pulumi.Input[_builtins.int]] = None,
            persistent_pxe: Optional[pulumi.Input[_builtins.bool]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            ram: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
            script_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            user_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            v6_main_ip: Optional[pulumi.Input[_builtins.str]] = None,
            v6_network: Optional[pulumi.Input[_builtins.str]] = None,
            v6_network_size: Optional[pulumi.Input[_builtins.int]] = None,
            vpc2_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BareMetalServer':
        """
        Get an existing BareMetalServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[_builtins.int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_variables: A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        :param pulumi.Input[_builtins.int] cpu_count: The number of CPUs available on the server.
        :param pulumi.Input[_builtins.str] date_created: The date the server was added to your Vultr account.
        :param pulumi.Input[_builtins.str] default_password: The server's default password.
        :param pulumi.Input[_builtins.str] disk: The description of the disk(s) on the server.
        :param pulumi.Input[_builtins.bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[_builtins.str] gateway_v4: The server's IPv4 gateway.
        :param pulumi.Input[_builtins.str] hostname: The hostname to assign to the server.
        :param pulumi.Input[_builtins.str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[_builtins.str] label: A label for the server.
        :param pulumi.Input[_builtins.int] mac_address: The MAC address associated with the server.
        :param pulumi.Input[_builtins.str] main_ip: The server's main IP address.
        :param pulumi.Input[_builtins.str] netmask_v4: The server's IPv4 netmask.
        :param pulumi.Input[_builtins.str] os: The string description of the operating system installed on the server.
        :param pulumi.Input[_builtins.int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[_builtins.str] ram: The amount of memory available on the server in MB.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] reserved_ipv4: The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        :param pulumi.Input[_builtins.str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[_builtins.str] status: The status of the server's subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the servier.
        :param pulumi.Input[_builtins.str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[_builtins.str] user_scheme: The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        :param pulumi.Input[_builtins.str] v6_main_ip: The main IPv6 network address.
        :param pulumi.Input[_builtins.str] v6_network: The IPv6 subnet.
        :param pulumi.Input[_builtins.int] v6_network_size: The IPv6 network size in bits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc2_ids: A list of VPC 2.0 IDs to be attached to the server.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID to use when creating the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BareMetalServerState.__new__(_BareMetalServerState)

        __props__.__dict__["activation_email"] = activation_email
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_variables"] = app_variables
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["default_password"] = default_password
        __props__.__dict__["disk"] = disk
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["gateway_v4"] = gateway_v4
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["label"] = label
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["main_ip"] = main_ip
        __props__.__dict__["mdisk_mode"] = mdisk_mode
        __props__.__dict__["netmask_v4"] = netmask_v4
        __props__.__dict__["os"] = os
        __props__.__dict__["os_id"] = os_id
        __props__.__dict__["persistent_pxe"] = persistent_pxe
        __props__.__dict__["plan"] = plan
        __props__.__dict__["ram"] = ram
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_ipv4"] = reserved_ipv4
        __props__.__dict__["script_id"] = script_id
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_scheme"] = user_scheme
        __props__.__dict__["v6_main_ip"] = v6_main_ip
        __props__.__dict__["v6_network"] = v6_network
        __props__.__dict__["v6_network_size"] = v6_network_size
        __props__.__dict__["vpc2_ids"] = vpc2_ids
        __props__.__dict__["vpc_id"] = vpc_id
        return BareMetalServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appVariables")
    def app_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of user-supplied variable keys and values for Vultr Marketplace apps. [See List Marketplace App Variables](https://www.vultr.com/api/#tag/marketplace/operation/list-marketplace-app-variables)
        """
        return pulumi.get(self, "app_variables")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPUs available on the server.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="defaultPassword")
    def default_password(self) -> pulumi.Output[_builtins.str]:
        """
        The server's default password.
        """
        return pulumi.get(self, "default_password")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @_builtins.property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> pulumi.Output[_builtins.str]:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.int]:
        """
        The MAC address associated with the server.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @_builtins.property
    @pulumi.getter(name="mdiskMode")
    def mdisk_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "mdisk_mode")

    @_builtins.property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> pulumi.Output[_builtins.str]:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @_builtins.property
    @pulumi.getter
    def os(self) -> pulumi.Output[_builtins.str]:
        """
        The string description of the operating system installed on the server.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter(name="persistentPxe")
    def persistent_pxe(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "persistent_pxe")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the plan that you want the server to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of memory available on the server in MB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region that the server is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedIpv4")
    def reserved_ipv4(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the floating IP to use as the main IP of this server. [See Reserved IPs](https://www.vultr.com/api/#operation/list-reserved-ips)
        """
        return pulumi.get(self, "reserved_ipv4")

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to apply to the servier.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[_builtins.str]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scheme used for the default user. Possible values are `root` or `limited` (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @_builtins.property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @_builtins.property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @_builtins.property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> pulumi.Output[_builtins.int]:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @_builtins.property
    @pulumi.getter(name="vpc2Ids")
    @_utilities.deprecated("""VPC2 is deprecated and will be removed in a future release. Use VPC instead""")
    def vpc2_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of VPC 2.0 IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc2_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VPC ID to use when creating the server.
        """
        return pulumi.get(self, "vpc_id")

