# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContainerRegistryArgs', 'ContainerRegistry']

@pulumi.input_type
class ContainerRegistryArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[_builtins.str],
                 public: pulumi.Input[_builtins.bool],
                 region: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ContainerRegistry resource.
        :param pulumi.Input[_builtins.str] plan: The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        :param pulumi.Input[_builtins.bool] public: Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        :param pulumi.Input[_builtins.str] region: The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        :param pulumi.Input[_builtins.str] name: The name for your container registry.  Must be lowercase and only alphanumeric characters.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "public", public)
        pulumi.set(__self__, "region", region)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Input[_builtins.bool]:
        """
        Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for your container registry.  Must be lowercase and only alphanumeric characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ContainerRegistryState:
    def __init__(__self__, *,
                 container_registry_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_user: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ContainerRegistry resources.
        :param pulumi.Input[_builtins.str] container_registry_urn: The URN of the container registry.
        :param pulumi.Input[_builtins.str] date_created: A date-time of when the root user was created.
        :param pulumi.Input[_builtins.str] name: The name for your container registry.  Must be lowercase and only alphanumeric characters.
        :param pulumi.Input[_builtins.str] plan: The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        :param pulumi.Input[_builtins.bool] public: Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        :param pulumi.Input[_builtins.str] region: The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] root_user: The user associated with the container registry.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] storage: A listing of current storage usage relevant to the container registry.
        """
        if container_registry_urn is not None:
            pulumi.set(__self__, "container_registry_urn", container_registry_urn)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_user is not None:
            pulumi.set(__self__, "root_user", root_user)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @_builtins.property
    @pulumi.getter(name="containerRegistryURN")
    def container_registry_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URN of the container registry.
        """
        return pulumi.get(self, "container_registry_urn")

    @container_registry_urn.setter
    def container_registry_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_urn", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A date-time of when the root user was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for your container registry.  Must be lowercase and only alphanumeric characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootUser")
    def root_user(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The user associated with the container registry.
        """
        return pulumi.get(self, "root_user")

    @root_user.setter
    def root_user(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "root_user", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A listing of current storage usage relevant to the container registry.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage", value)


@pulumi.type_token("vultr:index/containerRegistry:ContainerRegistry")
class ContainerRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create and update a Vultr container registry.

        ## Example Usage

        Create a new container registry:

        ```python
        import pulumi
        import ediri_vultr as vultr

        vcr1 = vultr.ContainerRegistry("vcr1",
            plan="start_up",
            public=False,
            region="sjc")
        ```

        The `name` for container registries must be all lowercase and only contain alphanumeric characters.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name for your container registry.  Must be lowercase and only alphanumeric characters.
        :param pulumi.Input[_builtins.str] plan: The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        :param pulumi.Input[_builtins.bool] public: Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        :param pulumi.Input[_builtins.str] region: The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create and update a Vultr container registry.

        ## Example Usage

        Create a new container registry:

        ```python
        import pulumi
        import ediri_vultr as vultr

        vcr1 = vultr.ContainerRegistry("vcr1",
            plan="start_up",
            public=False,
            region="sjc")
        ```

        The `name` for container registries must be all lowercase and only contain alphanumeric characters.

        :param str resource_name: The name of the resource.
        :param ContainerRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRegistryArgs.__new__(ContainerRegistryArgs)

            __props__.__dict__["name"] = name
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if public is None and not opts.urn:
                raise TypeError("Missing required property 'public'")
            __props__.__dict__["public"] = public
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["container_registry_urn"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["root_user"] = None
            __props__.__dict__["storage"] = None
        super(ContainerRegistry, __self__).__init__(
            'vultr:index/containerRegistry:ContainerRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_registry_urn: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            public: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_user: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            storage: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ContainerRegistry':
        """
        Get an existing ContainerRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_urn: The URN of the container registry.
        :param pulumi.Input[_builtins.str] date_created: A date-time of when the root user was created.
        :param pulumi.Input[_builtins.str] name: The name for your container registry.  Must be lowercase and only alphanumeric characters.
        :param pulumi.Input[_builtins.str] plan: The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        :param pulumi.Input[_builtins.bool] public: Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        :param pulumi.Input[_builtins.str] region: The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] root_user: The user associated with the container registry.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] storage: A listing of current storage usage relevant to the container registry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRegistryState.__new__(_ContainerRegistryState)

        __props__.__dict__["container_registry_urn"] = container_registry_urn
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["name"] = name
        __props__.__dict__["plan"] = plan
        __props__.__dict__["public"] = public
        __props__.__dict__["region"] = region
        __props__.__dict__["root_user"] = root_user
        __props__.__dict__["storage"] = storage
        return ContainerRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="containerRegistryURN")
    def container_registry_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The URN of the container registry.
        """
        return pulumi.get(self, "container_registry_urn")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        A date-time of when the root user was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for your container registry.  Must be lowercase and only alphanumeric characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The billing plan for the container registry. [See available plans](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-plans)
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating if the container registry should be created with public visibility or if it should require credentials.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where your container registry will be deployed. [See available regions](https://www.vultr.com/api/#tag/Container-Registry/operation/list-registry-regions)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootUser")
    def root_user(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The user associated with the container registry.
        """
        return pulumi.get(self, "root_user")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A listing of current storage usage relevant to the container registry.
        """
        return pulumi.get(self, "storage")

