# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 database_engine: pulumi.Input[_builtins.str],
                 database_engine_version: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 plan: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 access_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_kafka_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_kafka_rest: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_schema_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_rest_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_brokers: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]] = None,
                 sasl_port: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_registry_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the new managed database.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the new managed database.
        :param pulumi.Input[_builtins.str] label: A label for the managed database.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] access_cert: The certificate to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] access_key: The private key to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param pulumi.Input[_builtins.bool] enable_kafka_connect: The configuration value for Kafka Connect support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_kafka_rest: The configuration value for Kafka REST support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_schema_registry: The configuration value for Schema Registry support (Kafka engine types only).
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param pulumi.Input[_builtins.str] kafka_rest_uri: The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param pulumi.Input[_builtins.str] password: The password for the managed database's primary admin user.
        :param pulumi.Input[_builtins.int] plan_brokers: The number of brokers available on the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]] read_replicas: A list of read replicas attached to the managed database.
        :param pulumi.Input[_builtins.str] sasl_port: The SASL connection port for the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.str] schema_registry_uri: The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        pulumi.set(__self__, "database_engine", database_engine)
        pulumi.set(__self__, "database_engine_version", database_engine_version)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if access_cert is not None:
            pulumi.set(__self__, "access_cert", access_cert)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if enable_kafka_connect is not None:
            pulumi.set(__self__, "enable_kafka_connect", enable_kafka_connect)
        if enable_kafka_rest is not None:
            pulumi.set(__self__, "enable_kafka_rest", enable_kafka_rest)
        if enable_schema_registry is not None:
            pulumi.set(__self__, "enable_schema_registry", enable_schema_registry)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if kafka_rest_uri is not None:
            pulumi.set(__self__, "kafka_rest_uri", kafka_rest_uri)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan_brokers is not None:
            pulumi.set(__self__, "plan_brokers", plan_brokers)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_replicas is not None:
            pulumi.set(__self__, "plan_replicas", plan_replicas)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if sasl_port is not None:
            pulumi.set(__self__, "sasl_port", sasl_port)
        if schema_registry_uri is not None:
            pulumi.set(__self__, "schema_registry_uri", schema_registry_uri)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> pulumi.Input[_builtins.str]:
        """
        The database engine of the new managed database.
        """
        return pulumi.get(self, "database_engine")

    @database_engine.setter
    def database_engine(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_engine", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        The database engine version of the new managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @database_engine_version.setter
    def database_engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_engine_version", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A label for the managed database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_cert")

    @access_cert.setter
    def access_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_cert", value)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="enableKafkaConnect")
    def enable_kafka_connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Kafka Connect support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_connect")

    @enable_kafka_connect.setter
    def enable_kafka_connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_kafka_connect", value)

    @_builtins.property
    @pulumi.getter(name="enableKafkaRest")
    def enable_kafka_rest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Kafka REST support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_rest")

    @enable_kafka_rest.setter
    def enable_kafka_rest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_kafka_rest", value)

    @_builtins.property
    @pulumi.getter(name="enableSchemaRegistry")
    def enable_schema_registry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Schema Registry support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_schema_registry")

    @enable_schema_registry.setter
    def enable_schema_registry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_schema_registry", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ferretdb_credentials")

    @ferretdb_credentials.setter
    def ferretdb_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ferretdb_credentials", value)

    @_builtins.property
    @pulumi.getter(name="kafkaRestUri")
    def kafka_rest_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "kafka_rest_uri")

    @kafka_rest_uri.setter
    def kafka_rest_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kafka_rest_uri", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @mysql_long_query_time.setter
    def mysql_long_query_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @mysql_require_primary_key.setter
    def mysql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @mysql_slow_query_log.setter
    def mysql_slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @mysql_sql_modes.setter
    def mysql_sql_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_sql_modes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="planBrokers")
    def plan_brokers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of brokers available on the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "plan_brokers")

    @plan_brokers.setter
    def plan_brokers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_brokers", value)

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @plan_disk.setter
    def plan_disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_disk", value)

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        return pulumi.get(self, "plan_replicas")

    @plan_replicas.setter
    def plan_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_replicas", value)

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @public_host.setter
    def public_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_host", value)

    @_builtins.property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]]:
        """
        A list of read replicas attached to the managed database.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]]):
        pulumi.set(self, "read_replicas", value)

    @_builtins.property
    @pulumi.getter(name="saslPort")
    def sasl_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SASL connection port for the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "sasl_port")

    @sasl_port.setter
    def sasl_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_port", value)

    @_builtins.property
    @pulumi.getter(name="schemaRegistryUri")
    def schema_registry_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "schema_registry_uri")

    @schema_registry_uri.setter
    def schema_registry_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_registry_uri", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to assign to the managed database.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @trusted_ips.setter
    def trusted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_ips", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 access_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 dbname: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_kafka_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_kafka_rest: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_schema_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_rest_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_brokers: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_vcpus: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_port: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_registry_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.str] access_cert: The certificate to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] access_key: The private key to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the new managed database.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the new managed database.
        :param pulumi.Input[_builtins.str] date_created: The date the managed database was added to your Vultr account.
        :param pulumi.Input[_builtins.str] dbname: The managed database's default logical database.
        :param pulumi.Input[_builtins.bool] enable_kafka_connect: The configuration value for Kafka Connect support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_kafka_rest: The configuration value for Kafka REST support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_schema_registry: The configuration value for Schema Registry support (Kafka engine types only).
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param pulumi.Input[_builtins.str] host: The hostname assigned to the managed database.
        :param pulumi.Input[_builtins.str] kafka_rest_uri: The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] label: A label for the managed database.
        :param pulumi.Input[_builtins.str] latest_backup: The date of the latest backup available on the managed database.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param pulumi.Input[_builtins.str] password: The password for the managed database's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param pulumi.Input[_builtins.int] plan_brokers: The number of brokers available on the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database.
        :param pulumi.Input[_builtins.int] plan_ram: The amount of memory available on the managed database in MB.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param pulumi.Input[_builtins.int] plan_vcpus: The number of virtual CPUs available on the managed database.
        :param pulumi.Input[_builtins.str] port: The connection port for the managed database.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]] read_replicas: A list of read replicas attached to the managed database.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] sasl_port: The SASL connection port for the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.str] schema_registry_uri: The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] status: The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database.
        :param pulumi.Input[_builtins.str] user: The primary admin user for the managed database.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        if access_cert is not None:
            pulumi.set(__self__, "access_cert", access_cert)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if database_engine is not None:
            pulumi.set(__self__, "database_engine", database_engine)
        if database_engine_version is not None:
            pulumi.set(__self__, "database_engine_version", database_engine_version)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if enable_kafka_connect is not None:
            pulumi.set(__self__, "enable_kafka_connect", enable_kafka_connect)
        if enable_kafka_rest is not None:
            pulumi.set(__self__, "enable_kafka_rest", enable_kafka_rest)
        if enable_schema_registry is not None:
            pulumi.set(__self__, "enable_schema_registry", enable_schema_registry)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if kafka_rest_uri is not None:
            pulumi.set(__self__, "kafka_rest_uri", kafka_rest_uri)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_backup is not None:
            pulumi.set(__self__, "latest_backup", latest_backup)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_brokers is not None:
            pulumi.set(__self__, "plan_brokers", plan_brokers)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_ram is not None:
            pulumi.set(__self__, "plan_ram", plan_ram)
        if plan_replicas is not None:
            pulumi.set(__self__, "plan_replicas", plan_replicas)
        if plan_vcpus is not None:
            pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sasl_port is not None:
            pulumi.set(__self__, "sasl_port", sasl_port)
        if schema_registry_uri is not None:
            pulumi.set(__self__, "schema_registry_uri", schema_registry_uri)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_cert")

    @access_cert.setter
    def access_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_cert", value)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine of the new managed database.
        """
        return pulumi.get(self, "database_engine")

    @database_engine.setter
    def database_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine version of the new managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @database_engine_version.setter
    def database_engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine_version", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbname", value)

    @_builtins.property
    @pulumi.getter(name="enableKafkaConnect")
    def enable_kafka_connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Kafka Connect support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_connect")

    @enable_kafka_connect.setter
    def enable_kafka_connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_kafka_connect", value)

    @_builtins.property
    @pulumi.getter(name="enableKafkaRest")
    def enable_kafka_rest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Kafka REST support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_rest")

    @enable_kafka_rest.setter
    def enable_kafka_rest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_kafka_rest", value)

    @_builtins.property
    @pulumi.getter(name="enableSchemaRegistry")
    def enable_schema_registry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for Schema Registry support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_schema_registry")

    @enable_schema_registry.setter
    def enable_schema_registry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_schema_registry", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ferretdb_credentials")

    @ferretdb_credentials.setter
    def ferretdb_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ferretdb_credentials", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="kafkaRestUri")
    def kafka_rest_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "kafka_rest_uri")

    @kafka_rest_uri.setter
    def kafka_rest_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kafka_rest_uri", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the managed database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @latest_backup.setter
    def latest_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_backup", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @mysql_long_query_time.setter
    def mysql_long_query_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @mysql_require_primary_key.setter
    def mysql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @mysql_slow_query_log.setter
    def mysql_slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @mysql_sql_modes.setter
    def mysql_sql_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_sql_modes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="planBrokers")
    def plan_brokers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of brokers available on the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "plan_brokers")

    @plan_brokers.setter
    def plan_brokers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_brokers", value)

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @plan_disk.setter
    def plan_disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_disk", value)

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @plan_ram.setter
    def plan_ram(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_ram", value)

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        return pulumi.get(self, "plan_replicas")

    @plan_replicas.setter
    def plan_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_replicas", value)

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @plan_vcpus.setter
    def plan_vcpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_vcpus", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @public_host.setter
    def public_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_host", value)

    @_builtins.property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]]:
        """
        A list of read replicas attached to the managed database.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseReadReplicaArgs']]]]):
        pulumi.set(self, "read_replicas", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="saslPort")
    def sasl_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SASL connection port for the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "sasl_port")

    @sasl_port.setter
    def sasl_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_port", value)

    @_builtins.property
    @pulumi.getter(name="schemaRegistryUri")
    def schema_registry_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "schema_registry_uri")

    @schema_registry_uri.setter
    def schema_registry_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_registry_uri", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to assign to the managed database.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @trusted_ips.setter
    def trusted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_ips", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("vultr:index/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_kafka_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_kafka_rest: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_schema_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_rest_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_brokers: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseReadReplicaArgs', 'DatabaseReadReplicaArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_port: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_registry_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr database resource. This can be used to create, read, modify, and delete managed databases on your Vultr account.

        ## Example Usage

        Create a new database:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database = vultr.Database("myDatabase",
            database_engine="pg",
            database_engine_version="15",
            label="my_database_label",
            plan="vultr-dbaas-startup-cc-1-55-2",
            region="ewr")
        ```

        Create a new database with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database = vultr.Database("myDatabase",
            cluster_time_zone="America/New_York",
            database_engine="pg",
            database_engine_version="15",
            label="my_database_label",
            maintenance_dow="sunday",
            maintenance_time="01:00",
            plan="vultr-dbaas-startup-cc-1-55-2",
            region="ewr",
            tag="some tag")
        ```

        ## Import

        Database can be imported using the database `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/database:Database my_database b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_cert: The certificate to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] access_key: The private key to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the new managed database.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the new managed database.
        :param pulumi.Input[_builtins.bool] enable_kafka_connect: The configuration value for Kafka Connect support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_kafka_rest: The configuration value for Kafka REST support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_schema_registry: The configuration value for Schema Registry support (Kafka engine types only).
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param pulumi.Input[_builtins.str] kafka_rest_uri: The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] label: A label for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param pulumi.Input[_builtins.str] password: The password for the managed database's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param pulumi.Input[_builtins.int] plan_brokers: The number of brokers available on the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseReadReplicaArgs', 'DatabaseReadReplicaArgsDict']]]] read_replicas: A list of read replicas attached to the managed database.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] sasl_port: The SASL connection port for the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.str] schema_registry_uri: The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database resource. This can be used to create, read, modify, and delete managed databases on your Vultr account.

        ## Example Usage

        Create a new database:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database = vultr.Database("myDatabase",
            database_engine="pg",
            database_engine_version="15",
            label="my_database_label",
            plan="vultr-dbaas-startup-cc-1-55-2",
            region="ewr")
        ```

        Create a new database with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database = vultr.Database("myDatabase",
            cluster_time_zone="America/New_York",
            database_engine="pg",
            database_engine_version="15",
            label="my_database_label",
            maintenance_dow="sunday",
            maintenance_time="01:00",
            plan="vultr-dbaas-startup-cc-1-55-2",
            region="ewr",
            tag="some tag")
        ```

        ## Import

        Database can be imported using the database `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/database:Database my_database b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_kafka_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_kafka_rest: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_schema_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kafka_rest_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_brokers: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseReadReplicaArgs', 'DatabaseReadReplicaArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_port: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_registry_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["access_cert"] = access_cert
            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["backup_hour"] = backup_hour
            __props__.__dict__["backup_minute"] = backup_minute
            __props__.__dict__["cluster_time_zone"] = cluster_time_zone
            if database_engine is None and not opts.urn:
                raise TypeError("Missing required property 'database_engine'")
            __props__.__dict__["database_engine"] = database_engine
            if database_engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'database_engine_version'")
            __props__.__dict__["database_engine_version"] = database_engine_version
            __props__.__dict__["enable_kafka_connect"] = enable_kafka_connect
            __props__.__dict__["enable_kafka_rest"] = enable_kafka_rest
            __props__.__dict__["enable_schema_registry"] = enable_schema_registry
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["ferretdb_credentials"] = ferretdb_credentials
            __props__.__dict__["kafka_rest_uri"] = kafka_rest_uri
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["maintenance_dow"] = maintenance_dow
            __props__.__dict__["maintenance_time"] = maintenance_time
            __props__.__dict__["mysql_long_query_time"] = mysql_long_query_time
            __props__.__dict__["mysql_require_primary_key"] = mysql_require_primary_key
            __props__.__dict__["mysql_slow_query_log"] = mysql_slow_query_log
            __props__.__dict__["mysql_sql_modes"] = mysql_sql_modes
            __props__.__dict__["password"] = password
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["plan_brokers"] = plan_brokers
            __props__.__dict__["plan_disk"] = plan_disk
            __props__.__dict__["plan_replicas"] = plan_replicas
            __props__.__dict__["public_host"] = public_host
            __props__.__dict__["read_replicas"] = read_replicas
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["sasl_port"] = sasl_port
            __props__.__dict__["schema_registry_uri"] = schema_registry_uri
            __props__.__dict__["tag"] = tag
            __props__.__dict__["trusted_ips"] = trusted_ips
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["date_created"] = None
            __props__.__dict__["dbname"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["latest_backup"] = None
            __props__.__dict__["plan_ram"] = None
            __props__.__dict__["plan_vcpus"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user"] = None
        super(Database, __self__).__init__(
            'vultr:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_cert: Optional[pulumi.Input[_builtins.str]] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
            backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            database_engine: Optional[pulumi.Input[_builtins.str]] = None,
            database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            dbname: Optional[pulumi.Input[_builtins.str]] = None,
            enable_kafka_connect: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_kafka_rest: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_schema_registry: Optional[pulumi.Input[_builtins.bool]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_rest_uri: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            latest_backup: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
            mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
            mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
            mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
            mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            plan_brokers: Optional[pulumi.Input[_builtins.int]] = None,
            plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
            plan_ram: Optional[pulumi.Input[_builtins.int]] = None,
            plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
            plan_vcpus: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            public_host: Optional[pulumi.Input[_builtins.str]] = None,
            read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseReadReplicaArgs', 'DatabaseReadReplicaArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sasl_port: Optional[pulumi.Input[_builtins.str]] = None,
            schema_registry_uri: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_cert: The certificate to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] access_key: The private key to authenticate the default user (Kafka engine types only).
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the new managed database.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the new managed database.
        :param pulumi.Input[_builtins.str] date_created: The date the managed database was added to your Vultr account.
        :param pulumi.Input[_builtins.str] dbname: The managed database's default logical database.
        :param pulumi.Input[_builtins.bool] enable_kafka_connect: The configuration value for Kafka Connect support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_kafka_rest: The configuration value for Kafka REST support (Kafka engine types only).
        :param pulumi.Input[_builtins.bool] enable_schema_registry: The configuration value for Schema Registry support (Kafka engine types only).
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param pulumi.Input[_builtins.str] host: The hostname assigned to the managed database.
        :param pulumi.Input[_builtins.str] kafka_rest_uri: The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] label: A label for the managed database.
        :param pulumi.Input[_builtins.str] latest_backup: The date of the latest backup available on the managed database.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param pulumi.Input[_builtins.str] password: The password for the managed database's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param pulumi.Input[_builtins.int] plan_brokers: The number of brokers available on the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database.
        :param pulumi.Input[_builtins.int] plan_ram: The amount of memory available on the managed database in MB.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param pulumi.Input[_builtins.int] plan_vcpus: The number of virtual CPUs available on the managed database.
        :param pulumi.Input[_builtins.str] port: The connection port for the managed database.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseReadReplicaArgs', 'DatabaseReadReplicaArgsDict']]]] read_replicas: A list of read replicas attached to the managed database.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] sasl_port: The SASL connection port for the managed database (Kafka engine types only).
        :param pulumi.Input[_builtins.str] schema_registry_uri: The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        :param pulumi.Input[_builtins.str] status: The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database.
        :param pulumi.Input[_builtins.str] user: The primary admin user for the managed database.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["access_cert"] = access_cert
        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["backup_hour"] = backup_hour
        __props__.__dict__["backup_minute"] = backup_minute
        __props__.__dict__["cluster_time_zone"] = cluster_time_zone
        __props__.__dict__["database_engine"] = database_engine
        __props__.__dict__["database_engine_version"] = database_engine_version
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["dbname"] = dbname
        __props__.__dict__["enable_kafka_connect"] = enable_kafka_connect
        __props__.__dict__["enable_kafka_rest"] = enable_kafka_rest
        __props__.__dict__["enable_schema_registry"] = enable_schema_registry
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["ferretdb_credentials"] = ferretdb_credentials
        __props__.__dict__["host"] = host
        __props__.__dict__["kafka_rest_uri"] = kafka_rest_uri
        __props__.__dict__["label"] = label
        __props__.__dict__["latest_backup"] = latest_backup
        __props__.__dict__["maintenance_dow"] = maintenance_dow
        __props__.__dict__["maintenance_time"] = maintenance_time
        __props__.__dict__["mysql_long_query_time"] = mysql_long_query_time
        __props__.__dict__["mysql_require_primary_key"] = mysql_require_primary_key
        __props__.__dict__["mysql_slow_query_log"] = mysql_slow_query_log
        __props__.__dict__["mysql_sql_modes"] = mysql_sql_modes
        __props__.__dict__["password"] = password
        __props__.__dict__["plan"] = plan
        __props__.__dict__["plan_brokers"] = plan_brokers
        __props__.__dict__["plan_disk"] = plan_disk
        __props__.__dict__["plan_ram"] = plan_ram
        __props__.__dict__["plan_replicas"] = plan_replicas
        __props__.__dict__["plan_vcpus"] = plan_vcpus
        __props__.__dict__["port"] = port
        __props__.__dict__["public_host"] = public_host
        __props__.__dict__["read_replicas"] = read_replicas
        __props__.__dict__["region"] = region
        __props__.__dict__["sasl_port"] = sasl_port
        __props__.__dict__["schema_registry_uri"] = schema_registry_uri
        __props__.__dict__["status"] = status
        __props__.__dict__["tag"] = tag
        __props__.__dict__["trusted_ips"] = trusted_ips
        __props__.__dict__["user"] = user
        __props__.__dict__["vpc_id"] = vpc_id
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_cert")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        return pulumi.get(self, "cluster_time_zone")

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> pulumi.Output[_builtins.str]:
        """
        The database engine of the new managed database.
        """
        return pulumi.get(self, "database_engine")

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The database engine version of the new managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter(name="enableKafkaConnect")
    def enable_kafka_connect(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The configuration value for Kafka Connect support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_connect")

    @_builtins.property
    @pulumi.getter(name="enableKafkaRest")
    def enable_kafka_rest(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The configuration value for Kafka REST support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_rest")

    @_builtins.property
    @pulumi.getter(name="enableSchemaRegistry")
    def enable_schema_registry(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The configuration value for Schema Registry support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_schema_registry")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "ferretdb_credentials")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="kafkaRestUri")
    def kafka_rest_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "kafka_rest_uri")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A label for the managed database.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> pulumi.Output[_builtins.str]:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> pulumi.Output[_builtins.int]:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> pulumi.Output[_builtins.bool]:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planBrokers")
    def plan_brokers(self) -> pulumi.Output[_builtins.int]:
        """
        The number of brokers available on the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "plan_brokers")

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> pulumi.Output[_builtins.int]:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> pulumi.Output[_builtins.int]:
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        return pulumi.get(self, "plan_replicas")

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> pulumi.Output[_builtins.int]:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> pulumi.Output[_builtins.str]:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @_builtins.property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> pulumi.Output[Sequence['outputs.DatabaseReadReplica']]:
        """
        A list of read replicas attached to the managed database.
        """
        return pulumi.get(self, "read_replicas")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="saslPort")
    def sasl_port(self) -> pulumi.Output[_builtins.str]:
        """
        The SASL connection port for the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "sasl_port")

    @_builtins.property
    @pulumi.getter(name="schemaRegistryUri")
    def schema_registry_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "schema_registry_uri")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The tag to assign to the managed database.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")

