# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseConnectorArgs', 'DatabaseConnector']

@pulumi.input_type
class DatabaseConnectorArgs:
    def __init__(__self__, *,
                 class_: pulumi.Input[_builtins.str],
                 database_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 topics: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseConnector resource.
        :param pulumi.Input[_builtins.str] class_: The class for the new managed database connector.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this connector to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database connector.
        :param pulumi.Input[_builtins.str] topics: A comma-separated list of topics to use with the new managed database connector.
        :param pulumi.Input[_builtins.str] config: A JSON string containing the configuration properties you wish to use with the new managed database connector.
        """
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topics", topics)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> pulumi.Input[_builtins.str]:
        """
        The class for the new managed database connector.
        """
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "class_", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this connector to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the new managed database connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def topics(self) -> pulumi.Input[_builtins.str]:
        """
        A comma-separated list of topics to use with the new managed database connector.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topics", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON string containing the configuration properties you wish to use with the new managed database connector.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class _DatabaseConnectorState:
    def __init__(__self__, *,
                 class_: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseConnector resources.
        :param pulumi.Input[_builtins.str] class_: The class for the new managed database connector.
        :param pulumi.Input[_builtins.str] config: A JSON string containing the configuration properties you wish to use with the new managed database connector.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this connector to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database connector.
        :param pulumi.Input[_builtins.str] topics: A comma-separated list of topics to use with the new managed database connector.
        """
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The class for the new managed database connector.
        """
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "class_", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON string containing the configuration properties you wish to use with the new managed database connector.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this connector to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the new managed database connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated list of topics to use with the new managed database connector.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topics", value)


@pulumi.type_token("vultr:index/databaseConnector:DatabaseConnector")
class DatabaseConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 class_: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr database connector resource. This can be used to create, read, modify, and delete connectors for a managed database on your Vultr account. Note: The managed database must be configured with `enable_kafka_connect = true`.

        ## Example Usage

        Create a new database connector:

        ```python
        import pulumi
        import ediri_vultr as vultr
        import json

        my_database_connector = vultr.DatabaseConnector("myDatabaseConnector",
            database_id=vultr_database["my_database"]["id"],
            name="my_database_connector",
            class_="com.couchbase.connect.kafka.CouchbaseSinkConnector",
            topics="my_database_topic",
            config=json.dumps({
                "couchbase.seed.nodes": "3",
                "couchbase.username": "some_username",
                "couchbase.password": "some_password",
            }))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] class_: The class for the new managed database connector.
        :param pulumi.Input[_builtins.str] config: A JSON string containing the configuration properties you wish to use with the new managed database connector.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this connector to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database connector.
        :param pulumi.Input[_builtins.str] topics: A comma-separated list of topics to use with the new managed database connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database connector resource. This can be used to create, read, modify, and delete connectors for a managed database on your Vultr account. Note: The managed database must be configured with `enable_kafka_connect = true`.

        ## Example Usage

        Create a new database connector:

        ```python
        import pulumi
        import ediri_vultr as vultr
        import json

        my_database_connector = vultr.DatabaseConnector("myDatabaseConnector",
            database_id=vultr_database["my_database"]["id"],
            name="my_database_connector",
            class_="com.couchbase.connect.kafka.CouchbaseSinkConnector",
            topics="my_database_topic",
            config=json.dumps({
                "couchbase.seed.nodes": "3",
                "couchbase.username": "some_username",
                "couchbase.password": "some_password",
            }))
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 class_: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseConnectorArgs.__new__(DatabaseConnectorArgs)

            if class_ is None and not opts.urn:
                raise TypeError("Missing required property 'class_'")
            __props__.__dict__["class_"] = class_
            __props__.__dict__["config"] = config
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if topics is None and not opts.urn:
                raise TypeError("Missing required property 'topics'")
            __props__.__dict__["topics"] = topics
        super(DatabaseConnector, __self__).__init__(
            'vultr:index/databaseConnector:DatabaseConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            class_: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            topics: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseConnector':
        """
        Get an existing DatabaseConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] class_: The class for the new managed database connector.
        :param pulumi.Input[_builtins.str] config: A JSON string containing the configuration properties you wish to use with the new managed database connector.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this connector to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database connector.
        :param pulumi.Input[_builtins.str] topics: A comma-separated list of topics to use with the new managed database connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseConnectorState.__new__(_DatabaseConnectorState)

        __props__.__dict__["class_"] = class_
        __props__.__dict__["config"] = config
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["name"] = name
        __props__.__dict__["topics"] = topics
        return DatabaseConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> pulumi.Output[_builtins.str]:
        """
        The class for the new managed database connector.
        """
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON string containing the configuration properties you wish to use with the new managed database connector.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this connector to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the new managed database connector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> pulumi.Output[_builtins.str]:
        """
        A comma-separated list of topics to use with the new managed database connector.
        """
        return pulumi.get(self, "topics")

