# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseDbArgs', 'DatabaseDb']

@pulumi.input_type
class DatabaseDbArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseDb resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this logical DB to.
        :param pulumi.Input[_builtins.str] name: The name of the new managed database logical DB.
        """
        pulumi.set(__self__, "database_id", database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this logical DB to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the new managed database logical DB.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DatabaseDbState:
    def __init__(__self__, *,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseDb resources.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this logical DB to.
        :param pulumi.Input[_builtins.str] name: The name of the new managed database logical DB.
        """
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this logical DB to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the new managed database logical DB.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("vultr:index/databaseDb:DatabaseDb")
class DatabaseDb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr database DB resource. This can be used to create, read, and delete logical DBs for a managed database on your Vultr account.

        ## Example Usage

        Create a new database DB:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_db = vultr.DatabaseDb("myDatabaseDb", database_id=vultr_database["my_database"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this logical DB to.
        :param pulumi.Input[_builtins.str] name: The name of the new managed database logical DB.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseDbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database DB resource. This can be used to create, read, and delete logical DBs for a managed database on your Vultr account.

        ## Example Usage

        Create a new database DB:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_db = vultr.DatabaseDb("myDatabaseDb", database_id=vultr_database["my_database"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseDbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseDbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseDbArgs.__new__(DatabaseDbArgs)

            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["name"] = name
        super(DatabaseDb, __self__).__init__(
            'vultr:index/databaseDb:DatabaseDb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseDb':
        """
        Get an existing DatabaseDb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this logical DB to.
        :param pulumi.Input[_builtins.str] name: The name of the new managed database logical DB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseDbState.__new__(_DatabaseDbState)

        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["name"] = name
        return DatabaseDb(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this logical DB to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the new managed database logical DB.
        """
        return pulumi.get(self, "name")

