# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseQuotaArgs', 'DatabaseQuota']

@pulumi.input_type
class DatabaseQuotaArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 consumer_byte_rate: pulumi.Input[_builtins.int],
                 database_id: pulumi.Input[_builtins.str],
                 producer_byte_rate: pulumi.Input[_builtins.int],
                 request_percentage: pulumi.Input[_builtins.int],
                 user: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DatabaseQuota resource.
        :param pulumi.Input[_builtins.str] client_id: The client ID for the new database quota.
        :param pulumi.Input[_builtins.int] consumer_byte_rate: The consumer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this quota to.
        :param pulumi.Input[_builtins.int] producer_byte_rate: The producer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.int] request_percentage: The CPU request percentage for the new managed database quota.
        :param pulumi.Input[_builtins.str] user: The user for the new managed database quota.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "consumer_byte_rate", consumer_byte_rate)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "producer_byte_rate", producer_byte_rate)
        pulumi.set(__self__, "request_percentage", request_percentage)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client ID for the new database quota.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> pulumi.Input[_builtins.int]:
        """
        The consumer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @consumer_byte_rate.setter
    def consumer_byte_rate(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "consumer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this quota to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> pulumi.Input[_builtins.int]:
        """
        The producer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "producer_byte_rate")

    @producer_byte_rate.setter
    def producer_byte_rate(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "producer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> pulumi.Input[_builtins.int]:
        """
        The CPU request percentage for the new managed database quota.
        """
        return pulumi.get(self, "request_percentage")

    @request_percentage.setter
    def request_percentage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "request_percentage", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The user for the new managed database quota.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _DatabaseQuotaState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseQuota resources.
        :param pulumi.Input[_builtins.str] client_id: The client ID for the new database quota.
        :param pulumi.Input[_builtins.int] consumer_byte_rate: The consumer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this quota to.
        :param pulumi.Input[_builtins.int] producer_byte_rate: The producer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.int] request_percentage: The CPU request percentage for the new managed database quota.
        :param pulumi.Input[_builtins.str] user: The user for the new managed database quota.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if consumer_byte_rate is not None:
            pulumi.set(__self__, "consumer_byte_rate", consumer_byte_rate)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if producer_byte_rate is not None:
            pulumi.set(__self__, "producer_byte_rate", producer_byte_rate)
        if request_percentage is not None:
            pulumi.set(__self__, "request_percentage", request_percentage)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID for the new database quota.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The consumer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @consumer_byte_rate.setter
    def consumer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this quota to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The producer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "producer_byte_rate")

    @producer_byte_rate.setter
    def producer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "producer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CPU request percentage for the new managed database quota.
        """
        return pulumi.get(self, "request_percentage")

    @request_percentage.setter
    def request_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_percentage", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user for the new managed database quota.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("vultr:index/databaseQuota:DatabaseQuota")
class DatabaseQuota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr database quota resource. This can be used to create, read, modify, and delete quotas for a managed database on your Vultr account.

        ## Example Usage

        Create a new database quota:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_quota = vultr.DatabaseQuota("myDatabaseQuota",
            database_id=vultr_database["my_database"]["id"],
            client_id="my_database_quota",
            consumer_byte_rate=3,
            producer_byte_rate=2,
            request_percentage=120,
            user="my_database_user")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: The client ID for the new database quota.
        :param pulumi.Input[_builtins.int] consumer_byte_rate: The consumer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this quota to.
        :param pulumi.Input[_builtins.int] producer_byte_rate: The producer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.int] request_percentage: The CPU request percentage for the new managed database quota.
        :param pulumi.Input[_builtins.str] user: The user for the new managed database quota.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseQuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database quota resource. This can be used to create, read, modify, and delete quotas for a managed database on your Vultr account.

        ## Example Usage

        Create a new database quota:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_quota = vultr.DatabaseQuota("myDatabaseQuota",
            database_id=vultr_database["my_database"]["id"],
            client_id="my_database_quota",
            consumer_byte_rate=3,
            producer_byte_rate=2,
            request_percentage=120,
            user="my_database_user")
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseQuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseQuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseQuotaArgs.__new__(DatabaseQuotaArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if consumer_byte_rate is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_byte_rate'")
            __props__.__dict__["consumer_byte_rate"] = consumer_byte_rate
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if producer_byte_rate is None and not opts.urn:
                raise TypeError("Missing required property 'producer_byte_rate'")
            __props__.__dict__["producer_byte_rate"] = producer_byte_rate
            if request_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'request_percentage'")
            __props__.__dict__["request_percentage"] = request_percentage
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
        super(DatabaseQuota, __self__).__init__(
            'vultr:index/databaseQuota:DatabaseQuota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
            request_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseQuota':
        """
        Get an existing DatabaseQuota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: The client ID for the new database quota.
        :param pulumi.Input[_builtins.int] consumer_byte_rate: The consumer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this quota to.
        :param pulumi.Input[_builtins.int] producer_byte_rate: The producer byte rate for the new managed database quota.
        :param pulumi.Input[_builtins.int] request_percentage: The CPU request percentage for the new managed database quota.
        :param pulumi.Input[_builtins.str] user: The user for the new managed database quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseQuotaState.__new__(_DatabaseQuotaState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["consumer_byte_rate"] = consumer_byte_rate
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["producer_byte_rate"] = producer_byte_rate
        __props__.__dict__["request_percentage"] = request_percentage
        __props__.__dict__["user"] = user
        return DatabaseQuota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client ID for the new database quota.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> pulumi.Output[_builtins.int]:
        """
        The consumer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this quota to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> pulumi.Output[_builtins.int]:
        """
        The producer byte rate for the new managed database quota.
        """
        return pulumi.get(self, "producer_byte_rate")

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The CPU request percentage for the new managed database quota.
        """
        return pulumi.get(self, "request_percentage")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The user for the new managed database quota.
        """
        return pulumi.get(self, "user")

