# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseReplicaArgs', 'DatabaseReplica']

@pulumi.input_type
class DatabaseReplicaArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DatabaseReplica resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this replica to.
        :param pulumi.Input[_builtins.str] label: A label for the managed database read replica.
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database read replica.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database read replica (VPC-attached only).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database read replica.
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this replica to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A label for the managed database read replica.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ferretdb_credentials")

    @ferretdb_credentials.setter
    def ferretdb_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ferretdb_credentials", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @mysql_long_query_time.setter
    def mysql_long_query_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @mysql_require_primary_key.setter
    def mysql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @mysql_slow_query_log.setter
    def mysql_slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @mysql_sql_modes.setter
    def mysql_sql_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_sql_modes", value)

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The description of the disk(s) on the managed database read replica.
        """
        return pulumi.get(self, "plan_disk")

    @plan_disk.setter
    def plan_disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_disk", value)

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public hostname assigned to the managed database read replica (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @public_host.setter
    def public_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_host", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to assign to the managed database read replica.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed IP addresses for the managed database read replica.
        """
        return pulumi.get(self, "trusted_ips")

    @trusted_ips.setter
    def trusted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_ips", value)


@pulumi.input_type
class _DatabaseReplicaState:
    def __init__(__self__, *,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 dbname: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_vcpus: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseReplica resources.
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the managed database read replica in TZ database format.
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the managed database read replica.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the managed database read replica.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this replica to.
        :param pulumi.Input[_builtins.str] date_created: The date the managed database read replica was added to your Vultr account.
        :param pulumi.Input[_builtins.str] dbname: The managed database read replica's default logical database.
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        :param pulumi.Input[_builtins.str] host: The hostname assigned to the managed database read replica.
        :param pulumi.Input[_builtins.str] label: A label for the managed database read replica.
        :param pulumi.Input[_builtins.str] latest_backup: The date of the latest backup available on the managed database read replica.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database read replica.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database read replica.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.str] password: The password for the managed database read replica's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The managed database read replica's plan ID.
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database read replica.
        :param pulumi.Input[_builtins.int] plan_ram: The amount of memory available on the managed database read replica in MB.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database read replica.
        :param pulumi.Input[_builtins.int] plan_vcpus: The number of virtual CPUs available on the managed database read replica.
        :param pulumi.Input[_builtins.str] port: The connection port for the managed database read replica.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database read replica (VPC-attached only).
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] status: The current status of the managed database read replica (poweroff, rebuilding, rebalancing, configuring, running).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database read replica.
        :param pulumi.Input[_builtins.str] user: The primary admin user for the managed database read replica.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network attached to the managed database read replica.
        """
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if database_engine is not None:
            pulumi.set(__self__, "database_engine", database_engine)
        if database_engine_version is not None:
            pulumi.set(__self__, "database_engine_version", database_engine_version)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_backup is not None:
            pulumi.set(__self__, "latest_backup", latest_backup)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_ram is not None:
            pulumi.set(__self__, "plan_ram", plan_ram)
        if plan_replicas is not None:
            pulumi.set(__self__, "plan_replicas", plan_replicas)
        if plan_vcpus is not None:
            pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone for the managed database read replica in TZ database format.
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine of the managed database read replica.
        """
        return pulumi.get(self, "database_engine")

    @database_engine.setter
    def database_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine", value)

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database engine version of the managed database read replica.
        """
        return pulumi.get(self, "database_engine_version")

    @database_engine_version.setter
    def database_engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_engine_version", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this replica to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the managed database read replica was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database read replica's default logical database.
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbname", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ferretdb_credentials")

    @ferretdb_credentials.setter
    def ferretdb_credentials(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ferretdb_credentials", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname assigned to the managed database read replica.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the managed database read replica.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date of the latest backup available on the managed database read replica.
        """
        return pulumi.get(self, "latest_backup")

    @latest_backup.setter
    def latest_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_backup", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance day of week for the managed database read replica.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred maintenance time for the managed database read replica.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @mysql_long_query_time.setter
    def mysql_long_query_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_long_query_time", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @mysql_require_primary_key.setter
    def mysql_require_primary_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_require_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @mysql_slow_query_log.setter
    def mysql_slow_query_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mysql_slow_query_log", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @mysql_sql_modes.setter
    def mysql_sql_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mysql_sql_modes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the managed database read replica's primary admin user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database read replica's plan ID.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The description of the disk(s) on the managed database read replica.
        """
        return pulumi.get(self, "plan_disk")

    @plan_disk.setter
    def plan_disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_disk", value)

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory available on the managed database read replica in MB.
        """
        return pulumi.get(self, "plan_ram")

    @plan_ram.setter
    def plan_ram(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_ram", value)

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of standby nodes available on the managed database read replica.
        """
        return pulumi.get(self, "plan_replicas")

    @plan_replicas.setter
    def plan_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_replicas", value)

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of virtual CPUs available on the managed database read replica.
        """
        return pulumi.get(self, "plan_vcpus")

    @plan_vcpus.setter
    def plan_vcpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "plan_vcpus", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection port for the managed database read replica.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public hostname assigned to the managed database read replica (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @public_host.setter
    def public_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_host", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the managed database read replica (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to assign to the managed database read replica.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed IP addresses for the managed database read replica.
        """
        return pulumi.get(self, "trusted_ips")

    @trusted_ips.setter
    def trusted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_ips", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary admin user for the managed database read replica.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC Network attached to the managed database read replica.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("vultr:index/databaseReplica:DatabaseReplica")
class DatabaseReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Vultr database replica resource. This can be used to create, read, modify, and delete managed database read replicas on your Vultr account.

        ## Example Usage

        Create a new database replica:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_replica = vultr.DatabaseReplica("myDatabaseReplica",
            database_id=vultr_database["my_database"]["id"],
            region="sea",
            label="my_database_replica_label",
            tag="test tag")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this replica to.
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        :param pulumi.Input[_builtins.str] label: A label for the managed database read replica.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database read replica.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database read replica (VPC-attached only).
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database read replica.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseReplicaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database replica resource. This can be used to create, read, modify, and delete managed database read replicas on your Vultr account.

        ## Example Usage

        Create a new database replica:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_replica = vultr.DatabaseReplica("myDatabaseReplica",
            database_id=vultr_database["my_database"]["id"],
            region="sea",
            label="my_database_replica_label",
            tag="test tag")
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseReplicaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseReplicaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
                 mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
                 public_host: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseReplicaArgs.__new__(DatabaseReplicaArgs)

            __props__.__dict__["backup_hour"] = backup_hour
            __props__.__dict__["backup_minute"] = backup_minute
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["ferretdb_credentials"] = ferretdb_credentials
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["mysql_long_query_time"] = mysql_long_query_time
            __props__.__dict__["mysql_require_primary_key"] = mysql_require_primary_key
            __props__.__dict__["mysql_slow_query_log"] = mysql_slow_query_log
            __props__.__dict__["mysql_sql_modes"] = mysql_sql_modes
            __props__.__dict__["plan_disk"] = plan_disk
            __props__.__dict__["public_host"] = public_host
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["tag"] = tag
            __props__.__dict__["trusted_ips"] = trusted_ips
            __props__.__dict__["cluster_time_zone"] = None
            __props__.__dict__["database_engine"] = None
            __props__.__dict__["database_engine_version"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["dbname"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["latest_backup"] = None
            __props__.__dict__["maintenance_dow"] = None
            __props__.__dict__["maintenance_time"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["plan"] = None
            __props__.__dict__["plan_ram"] = None
            __props__.__dict__["plan_replicas"] = None
            __props__.__dict__["plan_vcpus"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user"] = None
            __props__.__dict__["vpc_id"] = None
        super(DatabaseReplica, __self__).__init__(
            'vultr:index/databaseReplica:DatabaseReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_hour: Optional[pulumi.Input[_builtins.str]] = None,
            backup_minute: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            database_engine: Optional[pulumi.Input[_builtins.str]] = None,
            database_engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            dbname: Optional[pulumi.Input[_builtins.str]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            ferretdb_credentials: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            latest_backup: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
            mysql_long_query_time: Optional[pulumi.Input[_builtins.int]] = None,
            mysql_require_primary_key: Optional[pulumi.Input[_builtins.bool]] = None,
            mysql_slow_query_log: Optional[pulumi.Input[_builtins.bool]] = None,
            mysql_sql_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            plan_disk: Optional[pulumi.Input[_builtins.int]] = None,
            plan_ram: Optional[pulumi.Input[_builtins.int]] = None,
            plan_replicas: Optional[pulumi.Input[_builtins.int]] = None,
            plan_vcpus: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            public_host: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseReplica':
        """
        Get an existing DatabaseReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param pulumi.Input[_builtins.str] cluster_time_zone: The configured time zone for the managed database read replica in TZ database format.
        :param pulumi.Input[_builtins.str] database_engine: The database engine of the managed database read replica.
        :param pulumi.Input[_builtins.str] database_engine_version: The database engine version of the managed database read replica.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this replica to.
        :param pulumi.Input[_builtins.str] date_created: The date the managed database read replica was added to your Vultr account.
        :param pulumi.Input[_builtins.str] dbname: The managed database read replica's default logical database.
        :param pulumi.Input[_builtins.str] eviction_policy: The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        :param pulumi.Input[_builtins.str] host: The hostname assigned to the managed database read replica.
        :param pulumi.Input[_builtins.str] label: A label for the managed database read replica.
        :param pulumi.Input[_builtins.str] latest_backup: The date of the latest backup available on the managed database read replica.
        :param pulumi.Input[_builtins.str] maintenance_dow: The preferred maintenance day of week for the managed database read replica.
        :param pulumi.Input[_builtins.str] maintenance_time: The preferred maintenance time for the managed database read replica.
        :param pulumi.Input[_builtins.int] mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.bool] mysql_slow_query_log: The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mysql_sql_modes: A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        :param pulumi.Input[_builtins.str] password: The password for the managed database read replica's primary admin user.
        :param pulumi.Input[_builtins.str] plan: The managed database read replica's plan ID.
        :param pulumi.Input[_builtins.int] plan_disk: The description of the disk(s) on the managed database read replica.
        :param pulumi.Input[_builtins.int] plan_ram: The amount of memory available on the managed database read replica in MB.
        :param pulumi.Input[_builtins.int] plan_replicas: The number of standby nodes available on the managed database read replica.
        :param pulumi.Input[_builtins.int] plan_vcpus: The number of virtual CPUs available on the managed database read replica.
        :param pulumi.Input[_builtins.str] port: The connection port for the managed database read replica.
        :param pulumi.Input[_builtins.str] public_host: The public hostname assigned to the managed database read replica (VPC-attached only).
        :param pulumi.Input[_builtins.str] region: The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[_builtins.str] status: The current status of the managed database read replica (poweroff, rebuilding, rebalancing, configuring, running).
        :param pulumi.Input[_builtins.str] tag: The tag to assign to the managed database read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_ips: A list of allowed IP addresses for the managed database read replica.
        :param pulumi.Input[_builtins.str] user: The primary admin user for the managed database read replica.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC Network attached to the managed database read replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseReplicaState.__new__(_DatabaseReplicaState)

        __props__.__dict__["backup_hour"] = backup_hour
        __props__.__dict__["backup_minute"] = backup_minute
        __props__.__dict__["cluster_time_zone"] = cluster_time_zone
        __props__.__dict__["database_engine"] = database_engine
        __props__.__dict__["database_engine_version"] = database_engine_version
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["dbname"] = dbname
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["ferretdb_credentials"] = ferretdb_credentials
        __props__.__dict__["host"] = host
        __props__.__dict__["label"] = label
        __props__.__dict__["latest_backup"] = latest_backup
        __props__.__dict__["maintenance_dow"] = maintenance_dow
        __props__.__dict__["maintenance_time"] = maintenance_time
        __props__.__dict__["mysql_long_query_time"] = mysql_long_query_time
        __props__.__dict__["mysql_require_primary_key"] = mysql_require_primary_key
        __props__.__dict__["mysql_slow_query_log"] = mysql_slow_query_log
        __props__.__dict__["mysql_sql_modes"] = mysql_sql_modes
        __props__.__dict__["password"] = password
        __props__.__dict__["plan"] = plan
        __props__.__dict__["plan_disk"] = plan_disk
        __props__.__dict__["plan_ram"] = plan_ram
        __props__.__dict__["plan_replicas"] = plan_replicas
        __props__.__dict__["plan_vcpus"] = plan_vcpus
        __props__.__dict__["port"] = port
        __props__.__dict__["public_host"] = public_host
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tag"] = tag
        __props__.__dict__["trusted_ips"] = trusted_ips
        __props__.__dict__["user"] = user
        __props__.__dict__["vpc_id"] = vpc_id
        return DatabaseReplica(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The configured time zone for the managed database read replica in TZ database format.
        """
        return pulumi.get(self, "cluster_time_zone")

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> pulumi.Output[_builtins.str]:
        """
        The database engine of the managed database read replica.
        """
        return pulumi.get(self, "database_engine")

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The database engine version of the managed database read replica.
        """
        return pulumi.get(self, "database_engine_version")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this replica to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the managed database read replica was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database read replica's default logical database.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration value for the data eviction policy on the managed database read replica (Valkey engine types only).
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "ferretdb_credentials")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname assigned to the managed database read replica.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A label for the managed database read replica.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> pulumi.Output[_builtins.str]:
        """
        The date of the latest backup available on the managed database read replica.
        """
        return pulumi.get(self, "latest_backup")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred maintenance day of week for the managed database read replica.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred maintenance time for the managed database read replica.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> pulumi.Output[_builtins.int]:
        """
        The configuration value for the long query time (in seconds) on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> pulumi.Output[_builtins.bool]:
        """
        The configuration value for whether primary keys are required on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> pulumi.Output[_builtins.bool]:
        """
        The configuration value for slow query logging on the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of SQL modes currently configured for the managed database read replica (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the managed database read replica's primary admin user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database read replica's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> pulumi.Output[_builtins.int]:
        """
        The description of the disk(s) on the managed database read replica.
        """
        return pulumi.get(self, "plan_disk")

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory available on the managed database read replica in MB.
        """
        return pulumi.get(self, "plan_ram")

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> pulumi.Output[_builtins.int]:
        """
        The number of standby nodes available on the managed database read replica.
        """
        return pulumi.get(self, "plan_replicas")

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> pulumi.Output[_builtins.int]:
        """
        The number of virtual CPUs available on the managed database read replica.
        """
        return pulumi.get(self, "plan_vcpus")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        The connection port for the managed database read replica.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> pulumi.Output[_builtins.str]:
        """
        The public hostname assigned to the managed database read replica (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region that the managed database read replica is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the managed database read replica (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Output[_builtins.str]:
        """
        The tag to assign to the managed database read replica.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of allowed IP addresses for the managed database read replica.
        """
        return pulumi.get(self, "trusted_ips")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The primary admin user for the managed database read replica.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC Network attached to the managed database read replica.
        """
        return pulumi.get(self, "vpc_id")

