# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseTopicArgs', 'DatabaseTopic']

@pulumi.input_type
class DatabaseTopicArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 partitions: pulumi.Input[_builtins.int],
                 replication: pulumi.Input[_builtins.int],
                 retention_bytes: pulumi.Input[_builtins.int],
                 retention_hours: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a DatabaseTopic resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this topic to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database topic.
        :param pulumi.Input[_builtins.int] partitions: The number of partitions for the new managed database topic.
        :param pulumi.Input[_builtins.int] replication: The replication factor for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_bytes: The retention bytes for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_hours: The retention hours for the new managed database topic.
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "retention_bytes", retention_bytes)
        pulumi.set(__self__, "retention_hours", retention_hours)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this topic to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the new managed database topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[_builtins.int]:
        """
        The number of partitions for the new managed database topic.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> pulumi.Input[_builtins.int]:
        """
        The replication factor for the new managed database topic.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="retentionBytes")
    def retention_bytes(self) -> pulumi.Input[_builtins.int]:
        """
        The retention bytes for the new managed database topic.
        """
        return pulumi.get(self, "retention_bytes")

    @retention_bytes.setter
    def retention_bytes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_bytes", value)

    @_builtins.property
    @pulumi.getter(name="retentionHours")
    def retention_hours(self) -> pulumi.Input[_builtins.int]:
        """
        The retention hours for the new managed database topic.
        """
        return pulumi.get(self, "retention_hours")

    @retention_hours.setter
    def retention_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_hours", value)


@pulumi.input_type
class _DatabaseTopicState:
    def __init__(__self__, *,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_hours: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DatabaseTopic resources.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this topic to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database topic.
        :param pulumi.Input[_builtins.int] partitions: The number of partitions for the new managed database topic.
        :param pulumi.Input[_builtins.int] replication: The replication factor for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_bytes: The retention bytes for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_hours: The retention hours for the new managed database topic.
        """
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if retention_bytes is not None:
            pulumi.set(__self__, "retention_bytes", retention_bytes)
        if retention_hours is not None:
            pulumi.set(__self__, "retention_hours", retention_hours)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this topic to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the new managed database topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions for the new managed database topic.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The replication factor for the new managed database topic.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="retentionBytes")
    def retention_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention bytes for the new managed database topic.
        """
        return pulumi.get(self, "retention_bytes")

    @retention_bytes.setter
    def retention_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_bytes", value)

    @_builtins.property
    @pulumi.getter(name="retentionHours")
    def retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention hours for the new managed database topic.
        """
        return pulumi.get(self, "retention_hours")

    @retention_hours.setter
    def retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_hours", value)


@pulumi.type_token("vultr:index/databaseTopic:DatabaseTopic")
class DatabaseTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Vultr database topic resource. This can be used to create, read, modify, and delete topics for a managed database on your Vultr account.

        ## Example Usage

        Create a new database topic:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_topic = vultr.DatabaseTopic("myDatabaseTopic",
            database_id=vultr_database["my_database"]["id"],
            name="my_database_topic",
            partitions=3,
            replication=2,
            retention_hours=120,
            retention_bytes=-1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this topic to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database topic.
        :param pulumi.Input[_builtins.int] partitions: The number of partitions for the new managed database topic.
        :param pulumi.Input[_builtins.int] replication: The replication factor for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_bytes: The retention bytes for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_hours: The retention hours for the new managed database topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database topic resource. This can be used to create, read, modify, and delete topics for a managed database on your Vultr account.

        ## Example Usage

        Create a new database topic:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_topic = vultr.DatabaseTopic("myDatabaseTopic",
            database_id=vultr_database["my_database"]["id"],
            name="my_database_topic",
            partitions=3,
            replication=2,
            retention_hours=120,
            retention_bytes=-1)
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseTopicArgs.__new__(DatabaseTopicArgs)

            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            if replication is None and not opts.urn:
                raise TypeError("Missing required property 'replication'")
            __props__.__dict__["replication"] = replication
            if retention_bytes is None and not opts.urn:
                raise TypeError("Missing required property 'retention_bytes'")
            __props__.__dict__["retention_bytes"] = retention_bytes
            if retention_hours is None and not opts.urn:
                raise TypeError("Missing required property 'retention_hours'")
            __props__.__dict__["retention_hours"] = retention_hours
        super(DatabaseTopic, __self__).__init__(
            'vultr:index/databaseTopic:DatabaseTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partitions: Optional[pulumi.Input[_builtins.int]] = None,
            replication: Optional[pulumi.Input[_builtins.int]] = None,
            retention_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            retention_hours: Optional[pulumi.Input[_builtins.int]] = None) -> 'DatabaseTopic':
        """
        Get an existing DatabaseTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this topic to.
        :param pulumi.Input[_builtins.str] name: The name for the new managed database topic.
        :param pulumi.Input[_builtins.int] partitions: The number of partitions for the new managed database topic.
        :param pulumi.Input[_builtins.int] replication: The replication factor for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_bytes: The retention bytes for the new managed database topic.
        :param pulumi.Input[_builtins.int] retention_hours: The retention hours for the new managed database topic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseTopicState.__new__(_DatabaseTopicState)

        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["name"] = name
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["replication"] = replication
        __props__.__dict__["retention_bytes"] = retention_bytes
        __props__.__dict__["retention_hours"] = retention_hours
        return DatabaseTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this topic to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the new managed database topic.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[_builtins.int]:
        """
        The number of partitions for the new managed database topic.
        """
        return pulumi.get(self, "partitions")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> pulumi.Output[_builtins.int]:
        """
        The replication factor for the new managed database topic.
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="retentionBytes")
    def retention_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        The retention bytes for the new managed database topic.
        """
        return pulumi.get(self, "retention_bytes")

    @_builtins.property
    @pulumi.getter(name="retentionHours")
    def retention_hours(self) -> pulumi.Output[_builtins.int]:
        """
        The retention hours for the new managed database topic.
        """
        return pulumi.get(self, "retention_hours")

