# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseUserArgs', 'DatabaseUser']

@pulumi.input_type
class DatabaseUserArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 access_control: Optional[pulumi.Input['DatabaseUserAccessControlArgs']] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseUser resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this user to.
        :param pulumi.Input[_builtins.str] username: The username of the new managed database user.
        :param pulumi.Input[_builtins.str] encryption: The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        :param pulumi.Input[_builtins.str] password: The password of the new managed database user.
        :param pulumi.Input[_builtins.str] permission: The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "username", username)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed database ID you want to attach this user to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the new managed database user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['DatabaseUserAccessControlArgs']]:
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['DatabaseUserAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the new managed database user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)


@pulumi.input_type
class _DatabaseUserState:
    def __init__(__self__, *,
                 access_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 access_control: Optional[pulumi.Input['DatabaseUserAccessControlArgs']] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseUser resources.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this user to.
        :param pulumi.Input[_builtins.str] encryption: The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        :param pulumi.Input[_builtins.str] password: The password of the new managed database user.
        :param pulumi.Input[_builtins.str] permission: The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        :param pulumi.Input[_builtins.str] username: The username of the new managed database user.
        """
        if access_cert is not None:
            pulumi.set(__self__, "access_cert", access_cert)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "access_cert")

    @access_cert.setter
    def access_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_cert", value)

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['DatabaseUserAccessControlArgs']]:
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['DatabaseUserAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed database ID you want to attach this user to.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the new managed database user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the new managed database user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("vultr:index/databaseUser:DatabaseUser")
class DatabaseUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control: Optional[pulumi.Input[Union['DatabaseUserAccessControlArgs', 'DatabaseUserAccessControlArgsDict']]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr database user resource. This can be used to create, read, modify, and delete users for a managed database on your Vultr account.

        ## Example Usage

        Create a new database user:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_user = vultr.DatabaseUser("myDatabaseUser",
            database_id=vultr_database["my_database"]["id"],
            username="my_database_user",
            password="randomTestPW40298")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this user to.
        :param pulumi.Input[_builtins.str] encryption: The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        :param pulumi.Input[_builtins.str] password: The password of the new managed database user.
        :param pulumi.Input[_builtins.str] permission: The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        :param pulumi.Input[_builtins.str] username: The username of the new managed database user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr database user resource. This can be used to create, read, modify, and delete users for a managed database on your Vultr account.

        ## Example Usage

        Create a new database user:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_database_user = vultr.DatabaseUser("myDatabaseUser",
            database_id=vultr_database["my_database"]["id"],
            username="my_database_user",
            password="randomTestPW40298")
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control: Optional[pulumi.Input[Union['DatabaseUserAccessControlArgs', 'DatabaseUserAccessControlArgsDict']]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseUserArgs.__new__(DatabaseUserArgs)

            __props__.__dict__["access_control"] = access_control
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["password"] = password
            __props__.__dict__["permission"] = permission
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["access_cert"] = None
            __props__.__dict__["access_key"] = None
        super(DatabaseUser, __self__).__init__(
            'vultr:index/databaseUser:DatabaseUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_cert: Optional[pulumi.Input[_builtins.str]] = None,
            access_control: Optional[pulumi.Input[Union['DatabaseUserAccessControlArgs', 'DatabaseUserAccessControlArgsDict']]] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseUser':
        """
        Get an existing DatabaseUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The managed database ID you want to attach this user to.
        :param pulumi.Input[_builtins.str] encryption: The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        :param pulumi.Input[_builtins.str] password: The password of the new managed database user.
        :param pulumi.Input[_builtins.str] permission: The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        :param pulumi.Input[_builtins.str] username: The username of the new managed database user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseUserState.__new__(_DatabaseUserState)

        __props__.__dict__["access_cert"] = access_cert
        __props__.__dict__["access_control"] = access_control
        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["password"] = password
        __props__.__dict__["permission"] = permission
        __props__.__dict__["username"] = username
        return DatabaseUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "access_cert")

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> pulumi.Output['outputs.DatabaseUserAccessControl']:
        return pulumi.get(self, "access_control")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed database ID you want to attach this user to.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[_builtins.str]:
        """
        The encryption type of the new managed database user's password (MySQL engine types only - `caching_sha2_password`, `mysql_native_password`).
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the new managed database user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        The permission level for the database user (Kafka engine types only - `admin`, `read`, `write`, `readwrite`).
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the new managed database user.
        """
        return pulumi.get(self, "username")

