# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DnsRecordArgs', 'DnsRecord']

@pulumi.input_type
class DnsRecordArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[_builtins.str],
                 domain: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DnsRecord resource.
        :param pulumi.Input[_builtins.str] data: IP Address of the instance the domain is associated with.
        :param pulumi.Input[_builtins.str] domain: Name of the DNS Domain this record will belong to.
        :param pulumi.Input[_builtins.str] type: Type of record.
        :param pulumi.Input[_builtins.str] name: Name (subdomain) for this record.
        :param pulumi.Input[_builtins.int] priority: Priority of this record (only required for MX and SRV).
        :param pulumi.Input[_builtins.int] ttl: The time to live of this record.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input[_builtins.str]:
        """
        IP Address of the instance the domain is associated with.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the DNS Domain this record will belong to.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of record.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name (subdomain) for this record.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of this record (only required for MX and SRV).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to live of this record.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _DnsRecordState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsRecord resources.
        :param pulumi.Input[_builtins.str] data: IP Address of the instance the domain is associated with.
        :param pulumi.Input[_builtins.str] domain: Name of the DNS Domain this record will belong to.
        :param pulumi.Input[_builtins.str] name: Name (subdomain) for this record.
        :param pulumi.Input[_builtins.int] priority: Priority of this record (only required for MX and SRV).
        :param pulumi.Input[_builtins.int] ttl: The time to live of this record.
        :param pulumi.Input[_builtins.str] type: Type of record.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP Address of the instance the domain is associated with.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the DNS Domain this record will belong to.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name (subdomain) for this record.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of this record (only required for MX and SRV).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to live of this record.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of record.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vultr:index/dnsRecord:DnsRecord")
class DnsRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr DNS Record resource. This can be used to create, read, modify, and delete DNS Records.

        ## Example Usage

        Create a new DNS Record

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_domain = vultr.DnsDomain("myDomain",
            domain="domain.com",
            ip="66.42.94.227")
        my_record = vultr.DnsRecord("myRecord",
            data="66.42.94.227",
            domain=my_domain.id,
            type="A")
        ```

        ## Import

        DNS Records can be imported using the Dns Domain `domain` and DNS Record `ID` e.g.

        ```sh
        $ pulumi import vultr:index/dnsRecord:DnsRecord rec domain.com,1a0019bd-7645-4310-81bd-03bc5906940f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data: IP Address of the instance the domain is associated with.
        :param pulumi.Input[_builtins.str] domain: Name of the DNS Domain this record will belong to.
        :param pulumi.Input[_builtins.str] name: Name (subdomain) for this record.
        :param pulumi.Input[_builtins.int] priority: Priority of this record (only required for MX and SRV).
        :param pulumi.Input[_builtins.int] ttl: The time to live of this record.
        :param pulumi.Input[_builtins.str] type: Type of record.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr DNS Record resource. This can be used to create, read, modify, and delete DNS Records.

        ## Example Usage

        Create a new DNS Record

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_domain = vultr.DnsDomain("myDomain",
            domain="domain.com",
            ip="66.42.94.227")
        my_record = vultr.DnsRecord("myRecord",
            data="66.42.94.227",
            domain=my_domain.id,
            type="A")
        ```

        ## Import

        DNS Records can be imported using the Dns Domain `domain` and DNS Record `ID` e.g.

        ```sh
        $ pulumi import vultr:index/dnsRecord:DnsRecord rec domain.com,1a0019bd-7645-4310-81bd-03bc5906940f
        ```

        :param str resource_name: The name of the resource.
        :param DnsRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsRecordArgs.__new__(DnsRecordArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(DnsRecord, __self__).__init__(
            'vultr:index/dnsRecord:DnsRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsRecord':
        """
        Get an existing DnsRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data: IP Address of the instance the domain is associated with.
        :param pulumi.Input[_builtins.str] domain: Name of the DNS Domain this record will belong to.
        :param pulumi.Input[_builtins.str] name: Name (subdomain) for this record.
        :param pulumi.Input[_builtins.int] priority: Priority of this record (only required for MX and SRV).
        :param pulumi.Input[_builtins.int] ttl: The time to live of this record.
        :param pulumi.Input[_builtins.str] type: Type of record.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsRecordState.__new__(_DnsRecordState)

        __props__.__dict__["data"] = data
        __props__.__dict__["domain"] = domain
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        return DnsRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[_builtins.str]:
        """
        IP Address of the instance the domain is associated with.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the DNS Domain this record will belong to.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name (subdomain) for this record.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Priority of this record (only required for MX and SRV).
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time to live of this record.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of record.
        """
        return pulumi.get(self, "type")

