# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, acls=None, balance=None, email=None, id=None, last_payment_amount=None, last_payment_date=None, name=None, pending_charges=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if balance and not isinstance(balance, float):
            raise TypeError("Expected argument 'balance' to be a float")
        pulumi.set(__self__, "balance", balance)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_payment_amount and not isinstance(last_payment_amount, float):
            raise TypeError("Expected argument 'last_payment_amount' to be a float")
        pulumi.set(__self__, "last_payment_amount", last_payment_amount)
        if last_payment_date and not isinstance(last_payment_date, str):
            raise TypeError("Expected argument 'last_payment_date' to be a str")
        pulumi.set(__self__, "last_payment_date", last_payment_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pending_charges and not isinstance(pending_charges, float):
            raise TypeError("Expected argument 'pending_charges' to be a float")
        pulumi.set(__self__, "pending_charges", pending_charges)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        The access control list on your Vultr account.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def balance(self) -> _builtins.float:
        """
        The current balance on your Vultr account.
        """
        return pulumi.get(self, "balance")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email address on your Vultr account.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastPaymentAmount")
    def last_payment_amount(self) -> _builtins.float:
        """
        The amount of the last payment made on your Vultr account.
        """
        return pulumi.get(self, "last_payment_amount")

    @_builtins.property
    @pulumi.getter(name="lastPaymentDate")
    def last_payment_date(self) -> _builtins.str:
        """
        The date of the last payment made on your Vultr account.
        """
        return pulumi.get(self, "last_payment_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name on your Vultr account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pendingCharges")
    def pending_charges(self) -> _builtins.float:
        """
        The pending charges on your Vultr account.
        """
        return pulumi.get(self, "pending_charges")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            acls=self.acls,
            balance=self.balance,
            email=self.email,
            id=self.id,
            last_payment_amount=self.last_payment_amount,
            last_payment_date=self.last_payment_date,
            name=self.name,
            pending_charges=self.pending_charges)


def get_account(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Get information about your Vultr account. This data source provides the balance, pending charges, last payment date, and last payment amount for your Vultr account.

    ## Example Usage

    Get the information for an account:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_account = vultr.get_account()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        acls=pulumi.get(__ret__, 'acls'),
        balance=pulumi.get(__ret__, 'balance'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        last_payment_amount=pulumi.get(__ret__, 'last_payment_amount'),
        last_payment_date=pulumi.get(__ret__, 'last_payment_date'),
        name=pulumi.get(__ret__, 'name'),
        pending_charges=pulumi.get(__ret__, 'pending_charges'))
def get_account_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Get information about your Vultr account. This data source provides the balance, pending charges, last payment date, and last payment amount for your Vultr account.

    ## Example Usage

    Get the information for an account:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_account = vultr.get_account()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        acls=pulumi.get(__response__, 'acls'),
        balance=pulumi.get(__response__, 'balance'),
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        last_payment_amount=pulumi.get(__response__, 'last_payment_amount'),
        last_payment_date=pulumi.get(__response__, 'last_payment_date'),
        name=pulumi.get(__response__, 'name'),
        pending_charges=pulumi.get(__response__, 'pending_charges')))
