# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, deploy_name=None, filters=None, id=None, image_id=None, name=None, short_name=None, type=None, vendor=None):
        if deploy_name and not isinstance(deploy_name, str):
            raise TypeError("Expected argument 'deploy_name' to be a str")
        pulumi.set(__self__, "deploy_name", deploy_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if short_name and not isinstance(short_name, str):
            raise TypeError("Expected argument 'short_name' to be a str")
        pulumi.set(__self__, "short_name", short_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter(name="deployName")
    def deploy_name(self) -> _builtins.str:
        """
        The deploy name of the application.
        """
        return pulumi.get(self, "deploy_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplicationFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The Marketplace ID for this application.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="shortName")
    def short_name(self) -> _builtins.str:
        """
        The short name of the application.
        """
        return pulumi.get(self, "short_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        This defines if an application is `one-click` or `marketplace` .
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> _builtins.str:
        """
        The vendor who authored the application.
        """
        return pulumi.get(self, "vendor")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            deploy_name=self.deploy_name,
            filters=self.filters,
            id=self.id,
            image_id=self.image_id,
            name=self.name,
            short_name=self.short_name,
            type=self.type,
            vendor=self.vendor)


def get_application(filters: Optional[Sequence[Union['GetApplicationFilterArgs', 'GetApplicationFilterArgsDict']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Get information about applications that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an application by `deploy_name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    docker = vultr.get_application(filters=[{
        "name": "deploy_name",
        "values": ["Docker on CentOS 7 x64"],
    }])
    ```


    :param Sequence[Union['GetApplicationFilterArgs', 'GetApplicationFilterArgsDict']] filters: Query parameters for finding applications.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        deploy_name=pulumi.get(__ret__, 'deploy_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        name=pulumi.get(__ret__, 'name'),
        short_name=pulumi.get(__ret__, 'short_name'),
        type=pulumi.get(__ret__, 'type'),
        vendor=pulumi.get(__ret__, 'vendor'))
def get_application_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApplicationFilterArgs', 'GetApplicationFilterArgsDict']]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Get information about applications that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an application by `deploy_name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    docker = vultr.get_application(filters=[{
        "name": "deploy_name",
        "values": ["Docker on CentOS 7 x64"],
    }])
    ```


    :param Sequence[Union['GetApplicationFilterArgs', 'GetApplicationFilterArgsDict']] filters: Query parameters for finding applications.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        deploy_name=pulumi.get(__response__, 'deploy_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        name=pulumi.get(__response__, 'name'),
        short_name=pulumi.get(__response__, 'short_name'),
        type=pulumi.get(__response__, 'type'),
        vendor=pulumi.get(__response__, 'vendor')))
