# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBareMetalPlanResult',
    'AwaitableGetBareMetalPlanResult',
    'get_bare_metal_plan',
    'get_bare_metal_plan_output',
]

@pulumi.output_type
class GetBareMetalPlanResult:
    """
    A collection of values returned by getBareMetalPlan.
    """
    def __init__(__self__, bandwidth=None, cpu_count=None, cpu_model=None, cpu_threads=None, disk=None, disk_count=None, filters=None, id=None, locations=None, monthly_cost=None, ram=None, type=None):
        if bandwidth and not isinstance(bandwidth, int):
            raise TypeError("Expected argument 'bandwidth' to be a int")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if cpu_count and not isinstance(cpu_count, int):
            raise TypeError("Expected argument 'cpu_count' to be a int")
        pulumi.set(__self__, "cpu_count", cpu_count)
        if cpu_model and not isinstance(cpu_model, str):
            raise TypeError("Expected argument 'cpu_model' to be a str")
        pulumi.set(__self__, "cpu_model", cpu_model)
        if cpu_threads and not isinstance(cpu_threads, int):
            raise TypeError("Expected argument 'cpu_threads' to be a int")
        pulumi.set(__self__, "cpu_threads", cpu_threads)
        if disk and not isinstance(disk, int):
            raise TypeError("Expected argument 'disk' to be a int")
        pulumi.set(__self__, "disk", disk)
        if disk_count and not isinstance(disk_count, int):
            raise TypeError("Expected argument 'disk_count' to be a int")
        pulumi.set(__self__, "disk_count", disk_count)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if monthly_cost and not isinstance(monthly_cost, int):
            raise TypeError("Expected argument 'monthly_cost' to be a int")
        pulumi.set(__self__, "monthly_cost", monthly_cost)
        if ram and not isinstance(ram, int):
            raise TypeError("Expected argument 'ram' to be a int")
        pulumi.set(__self__, "ram", ram)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth available on the plan.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> _builtins.int:
        """
        The number of CPUs available on the plan.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> _builtins.str:
        """
        The CPU model of the plan.
        """
        return pulumi.get(self, "cpu_model")

    @_builtins.property
    @pulumi.getter(name="cpuThreads")
    def cpu_threads(self) -> _builtins.int:
        """
        The number of CPU threads.
        """
        return pulumi.get(self, "cpu_threads")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.int:
        """
        The description of the disk(s) on the plan.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> _builtins.int:
        """
        The number of disks that this plan offers.
        """
        return pulumi.get(self, "disk_count")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBareMetalPlanFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="monthlyCost")
    def monthly_cost(self) -> _builtins.int:
        """
        The price per month of the plan in USD.
        """
        return pulumi.get(self, "monthly_cost")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The amount of memory available on the plan in MB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of plan it is.
        """
        return pulumi.get(self, "type")


class AwaitableGetBareMetalPlanResult(GetBareMetalPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBareMetalPlanResult(
            bandwidth=self.bandwidth,
            cpu_count=self.cpu_count,
            cpu_model=self.cpu_model,
            cpu_threads=self.cpu_threads,
            disk=self.disk,
            disk_count=self.disk_count,
            filters=self.filters,
            id=self.id,
            locations=self.locations,
            monthly_cost=self.monthly_cost,
            ram=self.ram,
            type=self.type)


def get_bare_metal_plan(filters: Optional[Sequence[Union['GetBareMetalPlanFilterArgs', 'GetBareMetalPlanFilterArgsDict']]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBareMetalPlanResult:
    """
    Get information about a Vultr bare metal server plan.

    ## Example Usage

    Get the information for a plan by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_plan = vultr.get_bare_metal_plan(filters=[{
        "name": "id",
        "values": ["vbm-4c-32gb"],
    }])
    ```


    :param Sequence[Union['GetBareMetalPlanFilterArgs', 'GetBareMetalPlanFilterArgsDict']] filters: Query parameters for finding plans.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getBareMetalPlan:getBareMetalPlan', __args__, opts=opts, typ=GetBareMetalPlanResult).value

    return AwaitableGetBareMetalPlanResult(
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        cpu_count=pulumi.get(__ret__, 'cpu_count'),
        cpu_model=pulumi.get(__ret__, 'cpu_model'),
        cpu_threads=pulumi.get(__ret__, 'cpu_threads'),
        disk=pulumi.get(__ret__, 'disk'),
        disk_count=pulumi.get(__ret__, 'disk_count'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'),
        monthly_cost=pulumi.get(__ret__, 'monthly_cost'),
        ram=pulumi.get(__ret__, 'ram'),
        type=pulumi.get(__ret__, 'type'))
def get_bare_metal_plan_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBareMetalPlanFilterArgs', 'GetBareMetalPlanFilterArgsDict']]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBareMetalPlanResult]:
    """
    Get information about a Vultr bare metal server plan.

    ## Example Usage

    Get the information for a plan by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_plan = vultr.get_bare_metal_plan(filters=[{
        "name": "id",
        "values": ["vbm-4c-32gb"],
    }])
    ```


    :param Sequence[Union['GetBareMetalPlanFilterArgs', 'GetBareMetalPlanFilterArgsDict']] filters: Query parameters for finding plans.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getBareMetalPlan:getBareMetalPlan', __args__, opts=opts, typ=GetBareMetalPlanResult)
    return __ret__.apply(lambda __response__: GetBareMetalPlanResult(
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        cpu_count=pulumi.get(__response__, 'cpu_count'),
        cpu_model=pulumi.get(__response__, 'cpu_model'),
        cpu_threads=pulumi.get(__response__, 'cpu_threads'),
        disk=pulumi.get(__response__, 'disk'),
        disk_count=pulumi.get(__response__, 'disk_count'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        locations=pulumi.get(__response__, 'locations'),
        monthly_cost=pulumi.get(__response__, 'monthly_cost'),
        ram=pulumi.get(__response__, 'ram'),
        type=pulumi.get(__response__, 'type')))
