# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBareMetalServerResult',
    'AwaitableGetBareMetalServerResult',
    'get_bare_metal_server',
    'get_bare_metal_server_output',
]

@pulumi.output_type
class GetBareMetalServerResult:
    """
    A collection of values returned by getBareMetalServer.
    """
    def __init__(__self__, app_id=None, cpu_count=None, date_created=None, disk=None, features=None, filters=None, gateway_v4=None, id=None, image_id=None, label=None, mac_address=None, main_ip=None, netmask_v4=None, os=None, os_id=None, plan=None, ram=None, region=None, status=None, tags=None, user_scheme=None, v6_main_ip=None, v6_network=None, v6_network_size=None, vpc2_ids=None, vpc_id=None):
        if app_id and not isinstance(app_id, int):
            raise TypeError("Expected argument 'app_id' to be a int")
        pulumi.set(__self__, "app_id", app_id)
        if cpu_count and not isinstance(cpu_count, int):
            raise TypeError("Expected argument 'cpu_count' to be a int")
        pulumi.set(__self__, "cpu_count", cpu_count)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if disk and not isinstance(disk, str):
            raise TypeError("Expected argument 'disk' to be a str")
        pulumi.set(__self__, "disk", disk)
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway_v4 and not isinstance(gateway_v4, str):
            raise TypeError("Expected argument 'gateway_v4' to be a str")
        pulumi.set(__self__, "gateway_v4", gateway_v4)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if mac_address and not isinstance(mac_address, int):
            raise TypeError("Expected argument 'mac_address' to be a int")
        pulumi.set(__self__, "mac_address", mac_address)
        if main_ip and not isinstance(main_ip, str):
            raise TypeError("Expected argument 'main_ip' to be a str")
        pulumi.set(__self__, "main_ip", main_ip)
        if netmask_v4 and not isinstance(netmask_v4, str):
            raise TypeError("Expected argument 'netmask_v4' to be a str")
        pulumi.set(__self__, "netmask_v4", netmask_v4)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if os_id and not isinstance(os_id, int):
            raise TypeError("Expected argument 'os_id' to be a int")
        pulumi.set(__self__, "os_id", os_id)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if ram and not isinstance(ram, str):
            raise TypeError("Expected argument 'ram' to be a str")
        pulumi.set(__self__, "ram", ram)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_scheme and not isinstance(user_scheme, str):
            raise TypeError("Expected argument 'user_scheme' to be a str")
        pulumi.set(__self__, "user_scheme", user_scheme)
        if v6_main_ip and not isinstance(v6_main_ip, str):
            raise TypeError("Expected argument 'v6_main_ip' to be a str")
        pulumi.set(__self__, "v6_main_ip", v6_main_ip)
        if v6_network and not isinstance(v6_network, str):
            raise TypeError("Expected argument 'v6_network' to be a str")
        pulumi.set(__self__, "v6_network", v6_network)
        if v6_network_size and not isinstance(v6_network_size, int):
            raise TypeError("Expected argument 'v6_network_size' to be a int")
        pulumi.set(__self__, "v6_network_size", v6_network_size)
        if vpc2_ids and not isinstance(vpc2_ids, list):
            raise TypeError("Expected argument 'vpc2_ids' to be a list")
        pulumi.set(__self__, "vpc2_ids", vpc2_ids)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.int:
        """
        The server's application ID.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> _builtins.int:
        """
        The number of CPUs available on the server.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.str:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBareMetalServerFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> _builtins.str:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The Marketplace ID for this application.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The server's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.int:
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> _builtins.str:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @_builtins.property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> _builtins.str:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operating system of the server.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> _builtins.int:
        """
        The server's operating system ID.
        """
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The server's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.str:
        """
        The amount of memory available on the server in MB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the server.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of tags applied to the server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> _builtins.str:
        """
        The scheme used for the default user (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @_builtins.property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> _builtins.str:
        return pulumi.get(self, "v6_main_ip")

    @_builtins.property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> _builtins.str:
        return pulumi.get(self, "v6_network")

    @_builtins.property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> _builtins.int:
        return pulumi.get(self, "v6_network_size")

    @_builtins.property
    @pulumi.getter(name="vpc2Ids")
    def vpc2_ids(self) -> Sequence[_builtins.str]:
        """
        (Deprecated) A list of VPC 2.0 IDs attached to the server.
        """
        return pulumi.get(self, "vpc2_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC which is attached to the bare metal server.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetBareMetalServerResult(GetBareMetalServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBareMetalServerResult(
            app_id=self.app_id,
            cpu_count=self.cpu_count,
            date_created=self.date_created,
            disk=self.disk,
            features=self.features,
            filters=self.filters,
            gateway_v4=self.gateway_v4,
            id=self.id,
            image_id=self.image_id,
            label=self.label,
            mac_address=self.mac_address,
            main_ip=self.main_ip,
            netmask_v4=self.netmask_v4,
            os=self.os,
            os_id=self.os_id,
            plan=self.plan,
            ram=self.ram,
            region=self.region,
            status=self.status,
            tags=self.tags,
            user_scheme=self.user_scheme,
            v6_main_ip=self.v6_main_ip,
            v6_network=self.v6_network,
            v6_network_size=self.v6_network_size,
            vpc2_ids=self.vpc2_ids,
            vpc_id=self.vpc_id)


def get_bare_metal_server(filters: Optional[Sequence[Union['GetBareMetalServerFilterArgs', 'GetBareMetalServerFilterArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBareMetalServerResult:
    """
    Get information about a Vultr bare metal server.

    ## Example Usage

    Get the information for a server by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_server = vultr.get_bare_metal_server(filters=[{
        "name": "label",
        "values": ["my-server-label"],
    }])
    ```


    :param Sequence[Union['GetBareMetalServerFilterArgs', 'GetBareMetalServerFilterArgsDict']] filters: Query parameters for finding servers.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getBareMetalServer:getBareMetalServer', __args__, opts=opts, typ=GetBareMetalServerResult).value

    return AwaitableGetBareMetalServerResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        cpu_count=pulumi.get(__ret__, 'cpu_count'),
        date_created=pulumi.get(__ret__, 'date_created'),
        disk=pulumi.get(__ret__, 'disk'),
        features=pulumi.get(__ret__, 'features'),
        filters=pulumi.get(__ret__, 'filters'),
        gateway_v4=pulumi.get(__ret__, 'gateway_v4'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        label=pulumi.get(__ret__, 'label'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        main_ip=pulumi.get(__ret__, 'main_ip'),
        netmask_v4=pulumi.get(__ret__, 'netmask_v4'),
        os=pulumi.get(__ret__, 'os'),
        os_id=pulumi.get(__ret__, 'os_id'),
        plan=pulumi.get(__ret__, 'plan'),
        ram=pulumi.get(__ret__, 'ram'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        user_scheme=pulumi.get(__ret__, 'user_scheme'),
        v6_main_ip=pulumi.get(__ret__, 'v6_main_ip'),
        v6_network=pulumi.get(__ret__, 'v6_network'),
        v6_network_size=pulumi.get(__ret__, 'v6_network_size'),
        vpc2_ids=pulumi.get(__ret__, 'vpc2_ids'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_bare_metal_server_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBareMetalServerFilterArgs', 'GetBareMetalServerFilterArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBareMetalServerResult]:
    """
    Get information about a Vultr bare metal server.

    ## Example Usage

    Get the information for a server by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_server = vultr.get_bare_metal_server(filters=[{
        "name": "label",
        "values": ["my-server-label"],
    }])
    ```


    :param Sequence[Union['GetBareMetalServerFilterArgs', 'GetBareMetalServerFilterArgsDict']] filters: Query parameters for finding servers.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getBareMetalServer:getBareMetalServer', __args__, opts=opts, typ=GetBareMetalServerResult)
    return __ret__.apply(lambda __response__: GetBareMetalServerResult(
        app_id=pulumi.get(__response__, 'app_id'),
        cpu_count=pulumi.get(__response__, 'cpu_count'),
        date_created=pulumi.get(__response__, 'date_created'),
        disk=pulumi.get(__response__, 'disk'),
        features=pulumi.get(__response__, 'features'),
        filters=pulumi.get(__response__, 'filters'),
        gateway_v4=pulumi.get(__response__, 'gateway_v4'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        label=pulumi.get(__response__, 'label'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        main_ip=pulumi.get(__response__, 'main_ip'),
        netmask_v4=pulumi.get(__response__, 'netmask_v4'),
        os=pulumi.get(__response__, 'os'),
        os_id=pulumi.get(__response__, 'os_id'),
        plan=pulumi.get(__response__, 'plan'),
        ram=pulumi.get(__response__, 'ram'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        user_scheme=pulumi.get(__response__, 'user_scheme'),
        v6_main_ip=pulumi.get(__response__, 'v6_main_ip'),
        v6_network=pulumi.get(__response__, 'v6_network'),
        v6_network_size=pulumi.get(__response__, 'v6_network_size'),
        vpc2_ids=pulumi.get(__response__, 'vpc2_ids'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
