# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerRegistryResult',
    'AwaitableGetContainerRegistryResult',
    'get_container_registry',
    'get_container_registry_output',
]

@pulumi.output_type
class GetContainerRegistryResult:
    """
    A collection of values returned by getContainerRegistry.
    """
    def __init__(__self__, date_created=None, filters=None, id=None, name=None, public=None, repositories=None, root_user=None, storage=None, urn=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public and not isinstance(public, bool):
            raise TypeError("Expected argument 'public' to be a bool")
        pulumi.set(__self__, "public", public)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if root_user and not isinstance(root_user, dict):
            raise TypeError("Expected argument 'root_user' to be a dict")
        pulumi.set(__self__, "root_user", root_user)
        if storage and not isinstance(storage, dict):
            raise TypeError("Expected argument 'storage' to be a dict")
        pulumi.set(__self__, "storage", storage)
        if urn and not isinstance(urn, str):
            raise TypeError("Expected argument 'urn' to be a str")
        pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        A date-time of when the root user was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerRegistryFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def public(self) -> _builtins.bool:
        """
        Boolean indicating whether or not the requires login credentials.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Sequence['outputs.GetContainerRegistryRepositoryResult']:
        """
        Listing of the repositories created within the registry and their metadata.
        """
        return pulumi.get(self, "repositories")

    @_builtins.property
    @pulumi.getter(name="rootUser")
    def root_user(self) -> Mapping[str, _builtins.str]:
        """
        The user associated with the container registry.
        """
        return pulumi.get(self, "root_user")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Mapping[str, _builtins.str]:
        """
        A listing of current storage usage relevant to the container registry.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> _builtins.str:
        """
        The URN of the container registry.
        """
        return pulumi.get(self, "urn")


class AwaitableGetContainerRegistryResult(GetContainerRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryResult(
            date_created=self.date_created,
            filters=self.filters,
            id=self.id,
            name=self.name,
            public=self.public,
            repositories=self.repositories,
            root_user=self.root_user,
            storage=self.storage,
            urn=self.urn)


def get_container_registry(filters: Optional[Sequence[Union['GetContainerRegistryFilterArgs', 'GetContainerRegistryFilterArgsDict']]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryResult:
    """
    Get information about a Vultr container registry.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vultr as vultr

    vcr_ds = vultr.get_container_registry(filters=[{
        "name": "name",
        "values": ["examplecontainerregistry"],
    }])
    ```


    :param Sequence[Union['GetContainerRegistryFilterArgs', 'GetContainerRegistryFilterArgsDict']] filters: Query parameters for finding the container registry.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts, typ=GetContainerRegistryResult).value

    return AwaitableGetContainerRegistryResult(
        date_created=pulumi.get(__ret__, 'date_created'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public=pulumi.get(__ret__, 'public'),
        repositories=pulumi.get(__ret__, 'repositories'),
        root_user=pulumi.get(__ret__, 'root_user'),
        storage=pulumi.get(__ret__, 'storage'),
        urn=pulumi.get(__ret__, 'urn'))
def get_container_registry_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetContainerRegistryFilterArgs', 'GetContainerRegistryFilterArgsDict']]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerRegistryResult]:
    """
    Get information about a Vultr container registry.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vultr as vultr

    vcr_ds = vultr.get_container_registry(filters=[{
        "name": "name",
        "values": ["examplecontainerregistry"],
    }])
    ```


    :param Sequence[Union['GetContainerRegistryFilterArgs', 'GetContainerRegistryFilterArgsDict']] filters: Query parameters for finding the container registry.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts, typ=GetContainerRegistryResult)
    return __ret__.apply(lambda __response__: GetContainerRegistryResult(
        date_created=pulumi.get(__response__, 'date_created'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public=pulumi.get(__response__, 'public'),
        repositories=pulumi.get(__response__, 'repositories'),
        root_user=pulumi.get(__response__, 'root_user'),
        storage=pulumi.get(__response__, 'storage'),
        urn=pulumi.get(__response__, 'urn')))
