# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    """
    A collection of values returned by getDatabase.
    """
    def __init__(__self__, access_cert=None, access_key=None, backup_hour=None, backup_minute=None, cluster_time_zone=None, database_engine=None, database_engine_version=None, date_created=None, dbname=None, enable_kafka_connect=None, enable_kafka_rest=None, enable_schema_registry=None, eviction_policy=None, ferretdb_credentials=None, filters=None, host=None, id=None, kafka_rest_uri=None, label=None, latest_backup=None, maintenance_dow=None, maintenance_time=None, mysql_long_query_time=None, mysql_require_primary_key=None, mysql_slow_query_log=None, mysql_sql_modes=None, password=None, plan=None, plan_brokers=None, plan_disk=None, plan_ram=None, plan_replicas=None, plan_vcpus=None, port=None, public_host=None, read_replicas=None, region=None, sasl_port=None, schema_registry_uri=None, status=None, tag=None, trusted_ips=None, user=None, vpc_id=None):
        if access_cert and not isinstance(access_cert, str):
            raise TypeError("Expected argument 'access_cert' to be a str")
        pulumi.set(__self__, "access_cert", access_cert)
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if backup_hour and not isinstance(backup_hour, str):
            raise TypeError("Expected argument 'backup_hour' to be a str")
        pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute and not isinstance(backup_minute, str):
            raise TypeError("Expected argument 'backup_minute' to be a str")
        pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone and not isinstance(cluster_time_zone, str):
            raise TypeError("Expected argument 'cluster_time_zone' to be a str")
        pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if database_engine and not isinstance(database_engine, str):
            raise TypeError("Expected argument 'database_engine' to be a str")
        pulumi.set(__self__, "database_engine", database_engine)
        if database_engine_version and not isinstance(database_engine_version, str):
            raise TypeError("Expected argument 'database_engine_version' to be a str")
        pulumi.set(__self__, "database_engine_version", database_engine_version)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if dbname and not isinstance(dbname, str):
            raise TypeError("Expected argument 'dbname' to be a str")
        pulumi.set(__self__, "dbname", dbname)
        if enable_kafka_connect and not isinstance(enable_kafka_connect, bool):
            raise TypeError("Expected argument 'enable_kafka_connect' to be a bool")
        pulumi.set(__self__, "enable_kafka_connect", enable_kafka_connect)
        if enable_kafka_rest and not isinstance(enable_kafka_rest, bool):
            raise TypeError("Expected argument 'enable_kafka_rest' to be a bool")
        pulumi.set(__self__, "enable_kafka_rest", enable_kafka_rest)
        if enable_schema_registry and not isinstance(enable_schema_registry, bool):
            raise TypeError("Expected argument 'enable_schema_registry' to be a bool")
        pulumi.set(__self__, "enable_schema_registry", enable_schema_registry)
        if eviction_policy and not isinstance(eviction_policy, str):
            raise TypeError("Expected argument 'eviction_policy' to be a str")
        pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials and not isinstance(ferretdb_credentials, dict):
            raise TypeError("Expected argument 'ferretdb_credentials' to be a dict")
        pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_rest_uri and not isinstance(kafka_rest_uri, str):
            raise TypeError("Expected argument 'kafka_rest_uri' to be a str")
        pulumi.set(__self__, "kafka_rest_uri", kafka_rest_uri)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if latest_backup and not isinstance(latest_backup, str):
            raise TypeError("Expected argument 'latest_backup' to be a str")
        pulumi.set(__self__, "latest_backup", latest_backup)
        if maintenance_dow and not isinstance(maintenance_dow, str):
            raise TypeError("Expected argument 'maintenance_dow' to be a str")
        pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time and not isinstance(maintenance_time, str):
            raise TypeError("Expected argument 'maintenance_time' to be a str")
        pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time and not isinstance(mysql_long_query_time, int):
            raise TypeError("Expected argument 'mysql_long_query_time' to be a int")
        pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key and not isinstance(mysql_require_primary_key, bool):
            raise TypeError("Expected argument 'mysql_require_primary_key' to be a bool")
        pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log and not isinstance(mysql_slow_query_log, bool):
            raise TypeError("Expected argument 'mysql_slow_query_log' to be a bool")
        pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes and not isinstance(mysql_sql_modes, list):
            raise TypeError("Expected argument 'mysql_sql_modes' to be a list")
        pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if plan_brokers and not isinstance(plan_brokers, int):
            raise TypeError("Expected argument 'plan_brokers' to be a int")
        pulumi.set(__self__, "plan_brokers", plan_brokers)
        if plan_disk and not isinstance(plan_disk, int):
            raise TypeError("Expected argument 'plan_disk' to be a int")
        pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_ram and not isinstance(plan_ram, int):
            raise TypeError("Expected argument 'plan_ram' to be a int")
        pulumi.set(__self__, "plan_ram", plan_ram)
        if plan_replicas and not isinstance(plan_replicas, int):
            raise TypeError("Expected argument 'plan_replicas' to be a int")
        pulumi.set(__self__, "plan_replicas", plan_replicas)
        if plan_vcpus and not isinstance(plan_vcpus, int):
            raise TypeError("Expected argument 'plan_vcpus' to be a int")
        pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        if port and not isinstance(port, str):
            raise TypeError("Expected argument 'port' to be a str")
        pulumi.set(__self__, "port", port)
        if public_host and not isinstance(public_host, str):
            raise TypeError("Expected argument 'public_host' to be a str")
        pulumi.set(__self__, "public_host", public_host)
        if read_replicas and not isinstance(read_replicas, list):
            raise TypeError("Expected argument 'read_replicas' to be a list")
        pulumi.set(__self__, "read_replicas", read_replicas)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sasl_port and not isinstance(sasl_port, str):
            raise TypeError("Expected argument 'sasl_port' to be a str")
        pulumi.set(__self__, "sasl_port", sasl_port)
        if schema_registry_uri and not isinstance(schema_registry_uri, str):
            raise TypeError("Expected argument 'schema_registry_uri' to be a str")
        pulumi.set(__self__, "schema_registry_uri", schema_registry_uri)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if trusted_ips and not isinstance(trusted_ips, list):
            raise TypeError("Expected argument 'trusted_ips' to be a list")
        pulumi.set(__self__, "trusted_ips", trusted_ips)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> _builtins.str:
        """
        The certificate to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_cert")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        The private key to authenticate the default user (Kafka engine types only).
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> _builtins.str:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> _builtins.str:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> _builtins.str:
        """
        The configured time zone for the Managed Database in TZ database format.
        """
        return pulumi.get(self, "cluster_time_zone")

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> _builtins.str:
        """
        The database engine of the managed database.
        """
        return pulumi.get(self, "database_engine")

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> _builtins.str:
        """
        The database engine version of the managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter(name="enableKafkaConnect")
    def enable_kafka_connect(self) -> _builtins.bool:
        """
        The configuration value for Kafka Connect support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_connect")

    @_builtins.property
    @pulumi.getter(name="enableKafkaRest")
    def enable_kafka_rest(self) -> _builtins.bool:
        """
        The configuration value for Kafka REST support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_kafka_rest")

    @_builtins.property
    @pulumi.getter(name="enableSchemaRegistry")
    def enable_schema_registry(self) -> _builtins.bool:
        """
        The configuration value for Schema Registry support (Kafka engine types only).
        """
        return pulumi.get(self, "enable_schema_registry")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> _builtins.str:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only).
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "ferretdb_credentials")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kafkaRestUri")
    def kafka_rest_uri(self) -> _builtins.str:
        """
        The URI to access the RESTful interface of your Kafka cluster if Kafka REST is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "kafka_rest_uri")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The managed database's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> _builtins.str:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> _builtins.str:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> _builtins.str:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> _builtins.int:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> _builtins.bool:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> _builtins.bool:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Sequence[_builtins.str]:
        """
        A list of SQL modes currently configured for the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The managed database's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planBrokers")
    def plan_brokers(self) -> _builtins.int:
        return pulumi.get(self, "plan_brokers")

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> _builtins.int:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> _builtins.int:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> _builtins.int:
        """
        The number of standby nodes available on the managed database.
        """
        return pulumi.get(self, "plan_replicas")

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> _builtins.int:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> _builtins.str:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @_builtins.property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Sequence['outputs.GetDatabaseReadReplicaResult']:
        """
        A list of read replicas attached to the managed database.
        """
        return pulumi.get(self, "read_replicas")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the managed database.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="saslPort")
    def sasl_port(self) -> _builtins.str:
        """
        The SASL connection port for the managed database (Kafka engine types only).
        """
        return pulumi.get(self, "sasl_port")

    @_builtins.property
    @pulumi.getter(name="schemaRegistryUri")
    def schema_registry_uri(self) -> _builtins.str:
        """
        The URI to access the Schema Registry service of your Kafka cluster if Schema Registry is enabled (Kafka engine types only).
        """
        return pulumi.get(self, "schema_registry_uri")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The managed database's tag.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Sequence[_builtins.str]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC Network attached to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            access_cert=self.access_cert,
            access_key=self.access_key,
            backup_hour=self.backup_hour,
            backup_minute=self.backup_minute,
            cluster_time_zone=self.cluster_time_zone,
            database_engine=self.database_engine,
            database_engine_version=self.database_engine_version,
            date_created=self.date_created,
            dbname=self.dbname,
            enable_kafka_connect=self.enable_kafka_connect,
            enable_kafka_rest=self.enable_kafka_rest,
            enable_schema_registry=self.enable_schema_registry,
            eviction_policy=self.eviction_policy,
            ferretdb_credentials=self.ferretdb_credentials,
            filters=self.filters,
            host=self.host,
            id=self.id,
            kafka_rest_uri=self.kafka_rest_uri,
            label=self.label,
            latest_backup=self.latest_backup,
            maintenance_dow=self.maintenance_dow,
            maintenance_time=self.maintenance_time,
            mysql_long_query_time=self.mysql_long_query_time,
            mysql_require_primary_key=self.mysql_require_primary_key,
            mysql_slow_query_log=self.mysql_slow_query_log,
            mysql_sql_modes=self.mysql_sql_modes,
            password=self.password,
            plan=self.plan,
            plan_brokers=self.plan_brokers,
            plan_disk=self.plan_disk,
            plan_ram=self.plan_ram,
            plan_replicas=self.plan_replicas,
            plan_vcpus=self.plan_vcpus,
            port=self.port,
            public_host=self.public_host,
            read_replicas=self.read_replicas,
            region=self.region,
            sasl_port=self.sasl_port,
            schema_registry_uri=self.schema_registry_uri,
            status=self.status,
            tag=self.tag,
            trusted_ips=self.trusted_ips,
            user=self.user,
            vpc_id=self.vpc_id)


def get_database(filters: Optional[Sequence[Union['GetDatabaseFilterArgs', 'GetDatabaseFilterArgsDict']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    Get information about a Vultr database.

    ## Example Usage

    Get the information for a database by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_database = vultr.get_database(filters=[{
        "name": "label",
        "values": ["my-database-label"],
    }])
    ```


    :param Sequence[Union['GetDatabaseFilterArgs', 'GetDatabaseFilterArgsDict']] filters: Query parameters for finding databases.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        access_cert=pulumi.get(__ret__, 'access_cert'),
        access_key=pulumi.get(__ret__, 'access_key'),
        backup_hour=pulumi.get(__ret__, 'backup_hour'),
        backup_minute=pulumi.get(__ret__, 'backup_minute'),
        cluster_time_zone=pulumi.get(__ret__, 'cluster_time_zone'),
        database_engine=pulumi.get(__ret__, 'database_engine'),
        database_engine_version=pulumi.get(__ret__, 'database_engine_version'),
        date_created=pulumi.get(__ret__, 'date_created'),
        dbname=pulumi.get(__ret__, 'dbname'),
        enable_kafka_connect=pulumi.get(__ret__, 'enable_kafka_connect'),
        enable_kafka_rest=pulumi.get(__ret__, 'enable_kafka_rest'),
        enable_schema_registry=pulumi.get(__ret__, 'enable_schema_registry'),
        eviction_policy=pulumi.get(__ret__, 'eviction_policy'),
        ferretdb_credentials=pulumi.get(__ret__, 'ferretdb_credentials'),
        filters=pulumi.get(__ret__, 'filters'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        kafka_rest_uri=pulumi.get(__ret__, 'kafka_rest_uri'),
        label=pulumi.get(__ret__, 'label'),
        latest_backup=pulumi.get(__ret__, 'latest_backup'),
        maintenance_dow=pulumi.get(__ret__, 'maintenance_dow'),
        maintenance_time=pulumi.get(__ret__, 'maintenance_time'),
        mysql_long_query_time=pulumi.get(__ret__, 'mysql_long_query_time'),
        mysql_require_primary_key=pulumi.get(__ret__, 'mysql_require_primary_key'),
        mysql_slow_query_log=pulumi.get(__ret__, 'mysql_slow_query_log'),
        mysql_sql_modes=pulumi.get(__ret__, 'mysql_sql_modes'),
        password=pulumi.get(__ret__, 'password'),
        plan=pulumi.get(__ret__, 'plan'),
        plan_brokers=pulumi.get(__ret__, 'plan_brokers'),
        plan_disk=pulumi.get(__ret__, 'plan_disk'),
        plan_ram=pulumi.get(__ret__, 'plan_ram'),
        plan_replicas=pulumi.get(__ret__, 'plan_replicas'),
        plan_vcpus=pulumi.get(__ret__, 'plan_vcpus'),
        port=pulumi.get(__ret__, 'port'),
        public_host=pulumi.get(__ret__, 'public_host'),
        read_replicas=pulumi.get(__ret__, 'read_replicas'),
        region=pulumi.get(__ret__, 'region'),
        sasl_port=pulumi.get(__ret__, 'sasl_port'),
        schema_registry_uri=pulumi.get(__ret__, 'schema_registry_uri'),
        status=pulumi.get(__ret__, 'status'),
        tag=pulumi.get(__ret__, 'tag'),
        trusted_ips=pulumi.get(__ret__, 'trusted_ips'),
        user=pulumi.get(__ret__, 'user'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_database_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseFilterArgs', 'GetDatabaseFilterArgsDict']]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    Get information about a Vultr database.

    ## Example Usage

    Get the information for a database by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_database = vultr.get_database(filters=[{
        "name": "label",
        "values": ["my-database-label"],
    }])
    ```


    :param Sequence[Union['GetDatabaseFilterArgs', 'GetDatabaseFilterArgsDict']] filters: Query parameters for finding databases.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult)
    return __ret__.apply(lambda __response__: GetDatabaseResult(
        access_cert=pulumi.get(__response__, 'access_cert'),
        access_key=pulumi.get(__response__, 'access_key'),
        backup_hour=pulumi.get(__response__, 'backup_hour'),
        backup_minute=pulumi.get(__response__, 'backup_minute'),
        cluster_time_zone=pulumi.get(__response__, 'cluster_time_zone'),
        database_engine=pulumi.get(__response__, 'database_engine'),
        database_engine_version=pulumi.get(__response__, 'database_engine_version'),
        date_created=pulumi.get(__response__, 'date_created'),
        dbname=pulumi.get(__response__, 'dbname'),
        enable_kafka_connect=pulumi.get(__response__, 'enable_kafka_connect'),
        enable_kafka_rest=pulumi.get(__response__, 'enable_kafka_rest'),
        enable_schema_registry=pulumi.get(__response__, 'enable_schema_registry'),
        eviction_policy=pulumi.get(__response__, 'eviction_policy'),
        ferretdb_credentials=pulumi.get(__response__, 'ferretdb_credentials'),
        filters=pulumi.get(__response__, 'filters'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        kafka_rest_uri=pulumi.get(__response__, 'kafka_rest_uri'),
        label=pulumi.get(__response__, 'label'),
        latest_backup=pulumi.get(__response__, 'latest_backup'),
        maintenance_dow=pulumi.get(__response__, 'maintenance_dow'),
        maintenance_time=pulumi.get(__response__, 'maintenance_time'),
        mysql_long_query_time=pulumi.get(__response__, 'mysql_long_query_time'),
        mysql_require_primary_key=pulumi.get(__response__, 'mysql_require_primary_key'),
        mysql_slow_query_log=pulumi.get(__response__, 'mysql_slow_query_log'),
        mysql_sql_modes=pulumi.get(__response__, 'mysql_sql_modes'),
        password=pulumi.get(__response__, 'password'),
        plan=pulumi.get(__response__, 'plan'),
        plan_brokers=pulumi.get(__response__, 'plan_brokers'),
        plan_disk=pulumi.get(__response__, 'plan_disk'),
        plan_ram=pulumi.get(__response__, 'plan_ram'),
        plan_replicas=pulumi.get(__response__, 'plan_replicas'),
        plan_vcpus=pulumi.get(__response__, 'plan_vcpus'),
        port=pulumi.get(__response__, 'port'),
        public_host=pulumi.get(__response__, 'public_host'),
        read_replicas=pulumi.get(__response__, 'read_replicas'),
        region=pulumi.get(__response__, 'region'),
        sasl_port=pulumi.get(__response__, 'sasl_port'),
        schema_registry_uri=pulumi.get(__response__, 'schema_registry_uri'),
        status=pulumi.get(__response__, 'status'),
        tag=pulumi.get(__response__, 'tag'),
        trusted_ips=pulumi.get(__response__, 'trusted_ips'),
        user=pulumi.get(__response__, 'user'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
