# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDnsDomainResult',
    'AwaitableGetDnsDomainResult',
    'get_dns_domain',
    'get_dns_domain_output',
]

@pulumi.output_type
class GetDnsDomainResult:
    """
    A collection of values returned by getDnsDomain.
    """
    def __init__(__self__, date_created=None, dns_sec=None, domain=None, id=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if dns_sec and not isinstance(dns_sec, str):
            raise TypeError("Expected argument 'dns_sec' to be a str")
        pulumi.set(__self__, "dns_sec", dns_sec)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the DNS domain was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dnsSec")
    def dns_sec(self) -> _builtins.str:
        """
        The Domain's DNSSEC status
        """
        return pulumi.get(self, "dns_sec")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Name of domain.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDnsDomainResult(GetDnsDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsDomainResult(
            date_created=self.date_created,
            dns_sec=self.dns_sec,
            domain=self.domain,
            id=self.id)


def get_dns_domain(domain: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsDomainResult:
    """
    Get information about a DNS domain associated with your Vultr account.

    ## Example Usage

    Get the information for a DNS domain:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_domain = vultr.get_dns_domain(domain="example.com")
    ```


    :param _builtins.str domain: The name you're searching for.
    """
    __args__ = dict()
    __args__['domain'] = domain
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getDnsDomain:getDnsDomain', __args__, opts=opts, typ=GetDnsDomainResult).value

    return AwaitableGetDnsDomainResult(
        date_created=pulumi.get(__ret__, 'date_created'),
        dns_sec=pulumi.get(__ret__, 'dns_sec'),
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'))
def get_dns_domain_output(domain: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsDomainResult]:
    """
    Get information about a DNS domain associated with your Vultr account.

    ## Example Usage

    Get the information for a DNS domain:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_domain = vultr.get_dns_domain(domain="example.com")
    ```


    :param _builtins.str domain: The name you're searching for.
    """
    __args__ = dict()
    __args__['domain'] = domain
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getDnsDomain:getDnsDomain', __args__, opts=opts, typ=GetDnsDomainResult)
    return __ret__.apply(lambda __response__: GetDnsDomainResult(
        date_created=pulumi.get(__response__, 'date_created'),
        dns_sec=pulumi.get(__response__, 'dns_sec'),
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id')))
