# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInferenceResult',
    'AwaitableGetInferenceResult',
    'get_inference',
    'get_inference_output',
]

@pulumi.output_type
class GetInferenceResult:
    """
    A collection of values returned by getInference.
    """
    def __init__(__self__, api_key=None, date_created=None, filters=None, id=None, label=None, usage=None):
        if api_key and not isinstance(api_key, str):
            raise TypeError("Expected argument 'api_key' to be a str")
        pulumi.set(__self__, "api_key", api_key)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if usage and not isinstance(usage, dict):
            raise TypeError("Expected argument 'usage' to be a dict")
        pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        The inference subscription's API key for accessing the Vultr Inference API.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the inference subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInferenceFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The inference subscription's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "usage")


class AwaitableGetInferenceResult(GetInferenceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInferenceResult(
            api_key=self.api_key,
            date_created=self.date_created,
            filters=self.filters,
            id=self.id,
            label=self.label,
            usage=self.usage)


def get_inference(filters: Optional[Sequence[Union['GetInferenceFilterArgs', 'GetInferenceFilterArgsDict']]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInferenceResult:
    """
    Get information about a Vultr Serverless Inference subscription.

    ## Example Usage

    Get the information for an inference subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    example_inference = vultr.get_inference(filters=[{
        "name": "label",
        "values": ["my_inference_label"],
    }])
    ```


    :param Sequence[Union['GetInferenceFilterArgs', 'GetInferenceFilterArgsDict']] filters: Query parameters for finding inference subscriptions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getInference:getInference', __args__, opts=opts, typ=GetInferenceResult).value

    return AwaitableGetInferenceResult(
        api_key=pulumi.get(__ret__, 'api_key'),
        date_created=pulumi.get(__ret__, 'date_created'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        usage=pulumi.get(__ret__, 'usage'))
def get_inference_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInferenceFilterArgs', 'GetInferenceFilterArgsDict']]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInferenceResult]:
    """
    Get information about a Vultr Serverless Inference subscription.

    ## Example Usage

    Get the information for an inference subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    example_inference = vultr.get_inference(filters=[{
        "name": "label",
        "values": ["my_inference_label"],
    }])
    ```


    :param Sequence[Union['GetInferenceFilterArgs', 'GetInferenceFilterArgsDict']] filters: Query parameters for finding inference subscriptions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getInference:getInference', __args__, opts=opts, typ=GetInferenceResult)
    return __ret__.apply(lambda __response__: GetInferenceResult(
        api_key=pulumi.get(__response__, 'api_key'),
        date_created=pulumi.get(__response__, 'date_created'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        usage=pulumi.get(__response__, 'usage')))
