# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    """
    A collection of values returned by getInstance.
    """
    def __init__(__self__, allowed_bandwidth=None, app_id=None, backups=None, backups_schedule=None, date_created=None, disk=None, features=None, filters=None, firewall_group_id=None, gateway_v4=None, hostname=None, id=None, image_id=None, internal_ip=None, kvm=None, label=None, location=None, main_ip=None, netmask_v4=None, os=None, os_id=None, plan=None, power_status=None, ram=None, region=None, server_status=None, status=None, tags=None, user_scheme=None, v6_main_ip=None, v6_network=None, v6_network_size=None, vcpu_count=None, vpc2_ids=None, vpc_ids=None):
        if allowed_bandwidth and not isinstance(allowed_bandwidth, int):
            raise TypeError("Expected argument 'allowed_bandwidth' to be a int")
        pulumi.set(__self__, "allowed_bandwidth", allowed_bandwidth)
        if app_id and not isinstance(app_id, int):
            raise TypeError("Expected argument 'app_id' to be a int")
        pulumi.set(__self__, "app_id", app_id)
        if backups and not isinstance(backups, str):
            raise TypeError("Expected argument 'backups' to be a str")
        pulumi.set(__self__, "backups", backups)
        if backups_schedule and not isinstance(backups_schedule, dict):
            raise TypeError("Expected argument 'backups_schedule' to be a dict")
        pulumi.set(__self__, "backups_schedule", backups_schedule)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if disk and not isinstance(disk, int):
            raise TypeError("Expected argument 'disk' to be a int")
        pulumi.set(__self__, "disk", disk)
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if firewall_group_id and not isinstance(firewall_group_id, str):
            raise TypeError("Expected argument 'firewall_group_id' to be a str")
        pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        if gateway_v4 and not isinstance(gateway_v4, str):
            raise TypeError("Expected argument 'gateway_v4' to be a str")
        pulumi.set(__self__, "gateway_v4", gateway_v4)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if internal_ip and not isinstance(internal_ip, str):
            raise TypeError("Expected argument 'internal_ip' to be a str")
        pulumi.set(__self__, "internal_ip", internal_ip)
        if kvm and not isinstance(kvm, str):
            raise TypeError("Expected argument 'kvm' to be a str")
        pulumi.set(__self__, "kvm", kvm)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if main_ip and not isinstance(main_ip, str):
            raise TypeError("Expected argument 'main_ip' to be a str")
        pulumi.set(__self__, "main_ip", main_ip)
        if netmask_v4 and not isinstance(netmask_v4, str):
            raise TypeError("Expected argument 'netmask_v4' to be a str")
        pulumi.set(__self__, "netmask_v4", netmask_v4)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if os_id and not isinstance(os_id, int):
            raise TypeError("Expected argument 'os_id' to be a int")
        pulumi.set(__self__, "os_id", os_id)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if power_status and not isinstance(power_status, str):
            raise TypeError("Expected argument 'power_status' to be a str")
        pulumi.set(__self__, "power_status", power_status)
        if ram and not isinstance(ram, int):
            raise TypeError("Expected argument 'ram' to be a int")
        pulumi.set(__self__, "ram", ram)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if server_status and not isinstance(server_status, str):
            raise TypeError("Expected argument 'server_status' to be a str")
        pulumi.set(__self__, "server_status", server_status)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_scheme and not isinstance(user_scheme, str):
            raise TypeError("Expected argument 'user_scheme' to be a str")
        pulumi.set(__self__, "user_scheme", user_scheme)
        if v6_main_ip and not isinstance(v6_main_ip, str):
            raise TypeError("Expected argument 'v6_main_ip' to be a str")
        pulumi.set(__self__, "v6_main_ip", v6_main_ip)
        if v6_network and not isinstance(v6_network, str):
            raise TypeError("Expected argument 'v6_network' to be a str")
        pulumi.set(__self__, "v6_network", v6_network)
        if v6_network_size and not isinstance(v6_network_size, int):
            raise TypeError("Expected argument 'v6_network_size' to be a int")
        pulumi.set(__self__, "v6_network_size", v6_network_size)
        if vcpu_count and not isinstance(vcpu_count, int):
            raise TypeError("Expected argument 'vcpu_count' to be a int")
        pulumi.set(__self__, "vcpu_count", vcpu_count)
        if vpc2_ids and not isinstance(vpc2_ids, list):
            raise TypeError("Expected argument 'vpc2_ids' to be a list")
        pulumi.set(__self__, "vpc2_ids", vpc2_ids)
        if vpc_ids and not isinstance(vpc_ids, list):
            raise TypeError("Expected argument 'vpc_ids' to be a list")
        pulumi.set(__self__, "vpc_ids", vpc_ids)

    @_builtins.property
    @pulumi.getter(name="allowedBandwidth")
    def allowed_bandwidth(self) -> _builtins.int:
        """
        The server's allowed bandwidth usage in GB.
        """
        return pulumi.get(self, "allowed_bandwidth")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.int:
        """
        The server's application ID.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> _builtins.str:
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="backupsSchedule")
    def backups_schedule(self) -> Mapping[str, _builtins.str]:
        """
        The current configuration for backups
        """
        return pulumi.get(self, "backups_schedule")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.int:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence[_builtins.str]:
        """
        Array of which features are enabled.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> _builtins.str:
        """
        The ID of the firewall group applied to this server.
        """
        return pulumi.get(self, "firewall_group_id")

    @_builtins.property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> _builtins.str:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname assigned to the server.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The Marketplace ID for this application.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> _builtins.str:
        """
        The server's internal IP address.
        """
        return pulumi.get(self, "internal_ip")

    @_builtins.property
    @pulumi.getter
    def kvm(self) -> _builtins.str:
        """
        The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        """
        return pulumi.get(self, "kvm")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The server's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> _builtins.str:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @_builtins.property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> _builtins.str:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operating system of the instance.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> _builtins.int:
        """
        The server's operating system ID.
        """
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The server's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> _builtins.str:
        """
        Whether the server is powered on or not.
        """
        return pulumi.get(self, "power_status")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The amount of memory available on the instance in MB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the server.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverStatus")
    def server_status(self) -> _builtins.str:
        """
        A more detailed server status (none, locked, installingbooting, isomounting, ok).
        """
        return pulumi.get(self, "server_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of tags applied to the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> _builtins.str:
        """
        The scheme used for the default user (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @_builtins.property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> _builtins.str:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @_builtins.property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> _builtins.str:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @_builtins.property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> _builtins.int:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @_builtins.property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> _builtins.int:
        """
        The number of virtual CPUs available on the server.
        """
        return pulumi.get(self, "vcpu_count")

    @_builtins.property
    @pulumi.getter(name="vpc2Ids")
    def vpc2_ids(self) -> Sequence[_builtins.str]:
        """
        (Deprecated) A list of VPC 2.0 IDs attached to the server.
        """
        return pulumi.get(self, "vpc2_ids")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "vpc_ids")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            allowed_bandwidth=self.allowed_bandwidth,
            app_id=self.app_id,
            backups=self.backups,
            backups_schedule=self.backups_schedule,
            date_created=self.date_created,
            disk=self.disk,
            features=self.features,
            filters=self.filters,
            firewall_group_id=self.firewall_group_id,
            gateway_v4=self.gateway_v4,
            hostname=self.hostname,
            id=self.id,
            image_id=self.image_id,
            internal_ip=self.internal_ip,
            kvm=self.kvm,
            label=self.label,
            location=self.location,
            main_ip=self.main_ip,
            netmask_v4=self.netmask_v4,
            os=self.os,
            os_id=self.os_id,
            plan=self.plan,
            power_status=self.power_status,
            ram=self.ram,
            region=self.region,
            server_status=self.server_status,
            status=self.status,
            tags=self.tags,
            user_scheme=self.user_scheme,
            v6_main_ip=self.v6_main_ip,
            v6_network=self.v6_network,
            v6_network_size=self.v6_network_size,
            vcpu_count=self.vcpu_count,
            vpc2_ids=self.vpc2_ids,
            vpc_ids=self.vpc_ids)


def get_instance(filters: Optional[Sequence[Union['GetInstanceFilterArgs', 'GetInstanceFilterArgsDict']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Get information about a Vultr instance.

    ## Example Usage

    Get the information for a instance by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_instance = vultr.get_instance(filters=[{
        "name": "label",
        "values": ["my-instance-label"],
    }])
    ```


    :param Sequence[Union['GetInstanceFilterArgs', 'GetInstanceFilterArgsDict']] filters: Query parameters for finding instances.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        allowed_bandwidth=pulumi.get(__ret__, 'allowed_bandwidth'),
        app_id=pulumi.get(__ret__, 'app_id'),
        backups=pulumi.get(__ret__, 'backups'),
        backups_schedule=pulumi.get(__ret__, 'backups_schedule'),
        date_created=pulumi.get(__ret__, 'date_created'),
        disk=pulumi.get(__ret__, 'disk'),
        features=pulumi.get(__ret__, 'features'),
        filters=pulumi.get(__ret__, 'filters'),
        firewall_group_id=pulumi.get(__ret__, 'firewall_group_id'),
        gateway_v4=pulumi.get(__ret__, 'gateway_v4'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        internal_ip=pulumi.get(__ret__, 'internal_ip'),
        kvm=pulumi.get(__ret__, 'kvm'),
        label=pulumi.get(__ret__, 'label'),
        location=pulumi.get(__ret__, 'location'),
        main_ip=pulumi.get(__ret__, 'main_ip'),
        netmask_v4=pulumi.get(__ret__, 'netmask_v4'),
        os=pulumi.get(__ret__, 'os'),
        os_id=pulumi.get(__ret__, 'os_id'),
        plan=pulumi.get(__ret__, 'plan'),
        power_status=pulumi.get(__ret__, 'power_status'),
        ram=pulumi.get(__ret__, 'ram'),
        region=pulumi.get(__ret__, 'region'),
        server_status=pulumi.get(__ret__, 'server_status'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        user_scheme=pulumi.get(__ret__, 'user_scheme'),
        v6_main_ip=pulumi.get(__ret__, 'v6_main_ip'),
        v6_network=pulumi.get(__ret__, 'v6_network'),
        v6_network_size=pulumi.get(__ret__, 'v6_network_size'),
        vcpu_count=pulumi.get(__ret__, 'vcpu_count'),
        vpc2_ids=pulumi.get(__ret__, 'vpc2_ids'),
        vpc_ids=pulumi.get(__ret__, 'vpc_ids'))
def get_instance_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstanceFilterArgs', 'GetInstanceFilterArgsDict']]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Get information about a Vultr instance.

    ## Example Usage

    Get the information for a instance by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_instance = vultr.get_instance(filters=[{
        "name": "label",
        "values": ["my-instance-label"],
    }])
    ```


    :param Sequence[Union['GetInstanceFilterArgs', 'GetInstanceFilterArgsDict']] filters: Query parameters for finding instances.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult)
    return __ret__.apply(lambda __response__: GetInstanceResult(
        allowed_bandwidth=pulumi.get(__response__, 'allowed_bandwidth'),
        app_id=pulumi.get(__response__, 'app_id'),
        backups=pulumi.get(__response__, 'backups'),
        backups_schedule=pulumi.get(__response__, 'backups_schedule'),
        date_created=pulumi.get(__response__, 'date_created'),
        disk=pulumi.get(__response__, 'disk'),
        features=pulumi.get(__response__, 'features'),
        filters=pulumi.get(__response__, 'filters'),
        firewall_group_id=pulumi.get(__response__, 'firewall_group_id'),
        gateway_v4=pulumi.get(__response__, 'gateway_v4'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        internal_ip=pulumi.get(__response__, 'internal_ip'),
        kvm=pulumi.get(__response__, 'kvm'),
        label=pulumi.get(__response__, 'label'),
        location=pulumi.get(__response__, 'location'),
        main_ip=pulumi.get(__response__, 'main_ip'),
        netmask_v4=pulumi.get(__response__, 'netmask_v4'),
        os=pulumi.get(__response__, 'os'),
        os_id=pulumi.get(__response__, 'os_id'),
        plan=pulumi.get(__response__, 'plan'),
        power_status=pulumi.get(__response__, 'power_status'),
        ram=pulumi.get(__response__, 'ram'),
        region=pulumi.get(__response__, 'region'),
        server_status=pulumi.get(__response__, 'server_status'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        user_scheme=pulumi.get(__response__, 'user_scheme'),
        v6_main_ip=pulumi.get(__response__, 'v6_main_ip'),
        v6_network=pulumi.get(__response__, 'v6_network'),
        v6_network_size=pulumi.get(__response__, 'v6_network_size'),
        vcpu_count=pulumi.get(__response__, 'vcpu_count'),
        vpc2_ids=pulumi.get(__response__, 'vpc2_ids'),
        vpc_ids=pulumi.get(__response__, 'vpc_ids')))
