# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIsoPublicResult',
    'AwaitableGetIsoPublicResult',
    'get_iso_public',
    'get_iso_public_output',
]

@pulumi.output_type
class GetIsoPublicResult:
    """
    A collection of values returned by getIsoPublic.
    """
    def __init__(__self__, description=None, filters=None, id=None, md5sum=None, name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if md5sum and not isinstance(md5sum, str):
            raise TypeError("Expected argument 'md5sum' to be a str")
        pulumi.set(__self__, "md5sum", md5sum)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the ISO file.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIsoPublicFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def md5sum(self) -> _builtins.str:
        """
        The MD5Sum of the ISO file.
        """
        return pulumi.get(self, "md5sum")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The ISO file's name.
        """
        return pulumi.get(self, "name")


class AwaitableGetIsoPublicResult(GetIsoPublicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIsoPublicResult(
            description=self.description,
            filters=self.filters,
            id=self.id,
            md5sum=self.md5sum,
            name=self.name)


def get_iso_public(filters: Optional[Sequence[Union['GetIsoPublicFilterArgs', 'GetIsoPublicFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIsoPublicResult:
    """
    Get information about an ISO file offered in the Vultr ISO library.

    ## Example Usage

    Get the information for a ISO file by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_iso = vultr.get_iso_public(filters=[{
        "name": "description",
        "values": ["iso-description"],
    }])
    ```


    :param Sequence[Union['GetIsoPublicFilterArgs', 'GetIsoPublicFilterArgsDict']] filters: Query parameters for finding ISO files.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getIsoPublic:getIsoPublic', __args__, opts=opts, typ=GetIsoPublicResult).value

    return AwaitableGetIsoPublicResult(
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        md5sum=pulumi.get(__ret__, 'md5sum'),
        name=pulumi.get(__ret__, 'name'))
def get_iso_public_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIsoPublicFilterArgs', 'GetIsoPublicFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIsoPublicResult]:
    """
    Get information about an ISO file offered in the Vultr ISO library.

    ## Example Usage

    Get the information for a ISO file by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_iso = vultr.get_iso_public(filters=[{
        "name": "description",
        "values": ["iso-description"],
    }])
    ```


    :param Sequence[Union['GetIsoPublicFilterArgs', 'GetIsoPublicFilterArgsDict']] filters: Query parameters for finding ISO files.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getIsoPublic:getIsoPublic', __args__, opts=opts, typ=GetIsoPublicResult)
    return __ret__.apply(lambda __response__: GetIsoPublicResult(
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        md5sum=pulumi.get(__response__, 'md5sum'),
        name=pulumi.get(__response__, 'name')))
