# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKubernetesResult',
    'AwaitableGetKubernetesResult',
    'get_kubernetes',
    'get_kubernetes_output',
]

@pulumi.output_type
class GetKubernetesResult:
    """
    A collection of values returned by getKubernetes.
    """
    def __init__(__self__, client_certificate=None, client_key=None, cluster_ca_certificate=None, cluster_subnet=None, date_created=None, endpoint=None, filters=None, firewall_group_id=None, ha_controlplanes=None, id=None, ip=None, kube_config=None, label=None, node_pools=None, region=None, service_subnet=None, status=None, version=None):
        if client_certificate and not isinstance(client_certificate, str):
            raise TypeError("Expected argument 'client_certificate' to be a str")
        pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key and not isinstance(client_key, str):
            raise TypeError("Expected argument 'client_key' to be a str")
        pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate and not isinstance(cluster_ca_certificate, str):
            raise TypeError("Expected argument 'cluster_ca_certificate' to be a str")
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if cluster_subnet and not isinstance(cluster_subnet, str):
            raise TypeError("Expected argument 'cluster_subnet' to be a str")
        pulumi.set(__self__, "cluster_subnet", cluster_subnet)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if firewall_group_id and not isinstance(firewall_group_id, str):
            raise TypeError("Expected argument 'firewall_group_id' to be a str")
        pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        if ha_controlplanes and not isinstance(ha_controlplanes, bool):
            raise TypeError("Expected argument 'ha_controlplanes' to be a bool")
        pulumi.set(__self__, "ha_controlplanes", ha_controlplanes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if kube_config and not isinstance(kube_config, str):
            raise TypeError("Expected argument 'kube_config' to be a str")
        pulumi.set(__self__, "kube_config", kube_config)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        pulumi.set(__self__, "node_pools", node_pools)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_subnet and not isinstance(service_subnet, str):
            raise TypeError("Expected argument 'service_subnet' to be a str")
        pulumi.set(__self__, "service_subnet", service_subnet)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> _builtins.str:
        """
        The base64 encoded public certificate used by clients to access the cluster.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        The base64 encoded private key used by clients to access the cluster.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> _builtins.str:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> _builtins.str:
        """
        IP range that your pods will run on in this cluster.
        """
        return pulumi.get(self, "cluster_subnet")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        Domain for your Kubernetes clusters control plane.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKubernetesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> _builtins.str:
        """
        The ID of the firewall group managed by this cluster.
        """
        return pulumi.get(self, "firewall_group_id")

    @_builtins.property
    @pulumi.getter(name="haControlplanes")
    def ha_controlplanes(self) -> _builtins.bool:
        """
        Boolean indicating whether or not the cluster has multiple, highly available controlplanes.
        """
        return pulumi.get(self, "ha_controlplanes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address of VKE cluster control plane.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> _builtins.str:
        """
        Base64 encoded Kubeconfig for this VKE cluster.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label of node.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence['outputs.GetKubernetesNodePoolResult']:
        """
        Contains the default node pool that was deployed.
        """
        return pulumi.get(self, "node_pools")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region your VKE cluster is deployed in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> _builtins.str:
        """
        IP range that services will run on this cluster.
        """
        return pulumi.get(self, "service_subnet")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The current kubernetes version your VKE cluster is running on.
        """
        return pulumi.get(self, "version")


class AwaitableGetKubernetesResult(GetKubernetesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesResult(
            client_certificate=self.client_certificate,
            client_key=self.client_key,
            cluster_ca_certificate=self.cluster_ca_certificate,
            cluster_subnet=self.cluster_subnet,
            date_created=self.date_created,
            endpoint=self.endpoint,
            filters=self.filters,
            firewall_group_id=self.firewall_group_id,
            ha_controlplanes=self.ha_controlplanes,
            id=self.id,
            ip=self.ip,
            kube_config=self.kube_config,
            label=self.label,
            node_pools=self.node_pools,
            region=self.region,
            service_subnet=self.service_subnet,
            status=self.status,
            version=self.version)


def get_kubernetes(filters: Optional[Sequence[Union['GetKubernetesFilterArgs', 'GetKubernetesFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesResult:
    """
    Get information about a Vultr Kubernetes Engine (VKE) Cluster.

    ## Example Usage

    Create a new VKE cluster:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vke = vultr.get_kubernetes(filters=[{
        "name": "label",
        "values": ["my-lb-label"],
    }])
    ```


    :param Sequence[Union['GetKubernetesFilterArgs', 'GetKubernetesFilterArgsDict']] filters: Query parameters for finding VKE.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getKubernetes:getKubernetes', __args__, opts=opts, typ=GetKubernetesResult).value

    return AwaitableGetKubernetesResult(
        client_certificate=pulumi.get(__ret__, 'client_certificate'),
        client_key=pulumi.get(__ret__, 'client_key'),
        cluster_ca_certificate=pulumi.get(__ret__, 'cluster_ca_certificate'),
        cluster_subnet=pulumi.get(__ret__, 'cluster_subnet'),
        date_created=pulumi.get(__ret__, 'date_created'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        filters=pulumi.get(__ret__, 'filters'),
        firewall_group_id=pulumi.get(__ret__, 'firewall_group_id'),
        ha_controlplanes=pulumi.get(__ret__, 'ha_controlplanes'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        kube_config=pulumi.get(__ret__, 'kube_config'),
        label=pulumi.get(__ret__, 'label'),
        node_pools=pulumi.get(__ret__, 'node_pools'),
        region=pulumi.get(__ret__, 'region'),
        service_subnet=pulumi.get(__ret__, 'service_subnet'),
        status=pulumi.get(__ret__, 'status'),
        version=pulumi.get(__ret__, 'version'))
def get_kubernetes_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetKubernetesFilterArgs', 'GetKubernetesFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesResult]:
    """
    Get information about a Vultr Kubernetes Engine (VKE) Cluster.

    ## Example Usage

    Create a new VKE cluster:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vke = vultr.get_kubernetes(filters=[{
        "name": "label",
        "values": ["my-lb-label"],
    }])
    ```


    :param Sequence[Union['GetKubernetesFilterArgs', 'GetKubernetesFilterArgsDict']] filters: Query parameters for finding VKE.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getKubernetes:getKubernetes', __args__, opts=opts, typ=GetKubernetesResult)
    return __ret__.apply(lambda __response__: GetKubernetesResult(
        client_certificate=pulumi.get(__response__, 'client_certificate'),
        client_key=pulumi.get(__response__, 'client_key'),
        cluster_ca_certificate=pulumi.get(__response__, 'cluster_ca_certificate'),
        cluster_subnet=pulumi.get(__response__, 'cluster_subnet'),
        date_created=pulumi.get(__response__, 'date_created'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        filters=pulumi.get(__response__, 'filters'),
        firewall_group_id=pulumi.get(__response__, 'firewall_group_id'),
        ha_controlplanes=pulumi.get(__response__, 'ha_controlplanes'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        kube_config=pulumi.get(__response__, 'kube_config'),
        label=pulumi.get(__response__, 'label'),
        node_pools=pulumi.get(__response__, 'node_pools'),
        region=pulumi.get(__response__, 'region'),
        service_subnet=pulumi.get(__response__, 'service_subnet'),
        status=pulumi.get(__response__, 'status'),
        version=pulumi.get(__response__, 'version')))
