# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectStorageResult',
    'AwaitableGetObjectStorageResult',
    'get_object_storage',
    'get_object_storage_output',
]

@pulumi.output_type
class GetObjectStorageResult:
    """
    A collection of values returned by getObjectStorage.
    """
    def __init__(__self__, cluster_id=None, date_created=None, filters=None, id=None, label=None, location=None, region=None, s3_access_key=None, s3_hostname=None, s3_secret_key=None, status=None):
        if cluster_id and not isinstance(cluster_id, int):
            raise TypeError("Expected argument 'cluster_id' to be a int")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if s3_access_key and not isinstance(s3_access_key, str):
            raise TypeError("Expected argument 's3_access_key' to be a str")
        pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_hostname and not isinstance(s3_hostname, str):
            raise TypeError("Expected argument 's3_hostname' to be a str")
        pulumi.set(__self__, "s3_hostname", s3_hostname)
        if s3_secret_key and not isinstance(s3_secret_key, str):
            raise TypeError("Expected argument 's3_secret_key' to be a str")
        pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.int:
        """
        The identifying cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date of creation for the object storage subscription.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectStorageFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label of the object storage subscription.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location which this subscription resides in.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the object storage subscription.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> _builtins.str:
        """
        Your access key.
        """
        return pulumi.get(self, "s3_access_key")

    @_builtins.property
    @pulumi.getter(name="s3Hostname")
    def s3_hostname(self) -> _builtins.str:
        """
        The hostname for this subscription.
        """
        return pulumi.get(self, "s3_hostname")

    @_builtins.property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> _builtins.str:
        """
        Your secret key.
        """
        return pulumi.get(self, "s3_secret_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status of this object storage subscription.
        """
        return pulumi.get(self, "status")


class AwaitableGetObjectStorageResult(GetObjectStorageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageResult(
            cluster_id=self.cluster_id,
            date_created=self.date_created,
            filters=self.filters,
            id=self.id,
            label=self.label,
            location=self.location,
            region=self.region,
            s3_access_key=self.s3_access_key,
            s3_hostname=self.s3_hostname,
            s3_secret_key=self.s3_secret_key,
            status=self.status)


def get_object_storage(filters: Optional[Sequence[Union['GetObjectStorageFilterArgs', 'GetObjectStorageFilterArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageResult:
    """
    Get information about an Object Storage subscription on Vultr.

    ## Example Usage

    Get the information for an object storage subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage(filters=[{
        "name": "label",
        "values": ["my-s3"],
    }])
    ```


    :param Sequence[Union['GetObjectStorageFilterArgs', 'GetObjectStorageFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getObjectStorage:getObjectStorage', __args__, opts=opts, typ=GetObjectStorageResult).value

    return AwaitableGetObjectStorageResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        date_created=pulumi.get(__ret__, 'date_created'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        location=pulumi.get(__ret__, 'location'),
        region=pulumi.get(__ret__, 'region'),
        s3_access_key=pulumi.get(__ret__, 's3_access_key'),
        s3_hostname=pulumi.get(__ret__, 's3_hostname'),
        s3_secret_key=pulumi.get(__ret__, 's3_secret_key'),
        status=pulumi.get(__ret__, 'status'))
def get_object_storage_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectStorageFilterArgs', 'GetObjectStorageFilterArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageResult]:
    """
    Get information about an Object Storage subscription on Vultr.

    ## Example Usage

    Get the information for an object storage subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage(filters=[{
        "name": "label",
        "values": ["my-s3"],
    }])
    ```


    :param Sequence[Union['GetObjectStorageFilterArgs', 'GetObjectStorageFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getObjectStorage:getObjectStorage', __args__, opts=opts, typ=GetObjectStorageResult)
    return __ret__.apply(lambda __response__: GetObjectStorageResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        date_created=pulumi.get(__response__, 'date_created'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        location=pulumi.get(__response__, 'location'),
        region=pulumi.get(__response__, 'region'),
        s3_access_key=pulumi.get(__response__, 's3_access_key'),
        s3_hostname=pulumi.get(__response__, 's3_hostname'),
        s3_secret_key=pulumi.get(__response__, 's3_secret_key'),
        status=pulumi.get(__response__, 'status')))
