# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectStorageClusterResult',
    'AwaitableGetObjectStorageClusterResult',
    'get_object_storage_cluster',
    'get_object_storage_cluster_output',
]

@pulumi.output_type
class GetObjectStorageClusterResult:
    """
    A collection of values returned by getObjectStorageCluster.
    """
    def __init__(__self__, deploy=None, filters=None, hostname=None, id=None, region=None):
        if deploy and not isinstance(deploy, str):
            raise TypeError("Expected argument 'deploy' to be a str")
        pulumi.set(__self__, "deploy", deploy)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> _builtins.str:
        """
        The Cluster is eligible for Object Storage deployment. (yes or no)
        """
        return pulumi.get(self, "deploy")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectStorageClusterFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The cluster hostname.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The identifying cluster ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the object storage cluster.
        """
        return pulumi.get(self, "region")


class AwaitableGetObjectStorageClusterResult(GetObjectStorageClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageClusterResult(
            deploy=self.deploy,
            filters=self.filters,
            hostname=self.hostname,
            id=self.id,
            region=self.region)


def get_object_storage_cluster(filters: Optional[Sequence[Union['GetObjectStorageClusterFilterArgs', 'GetObjectStorageClusterFilterArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageClusterResult:
    """
    Get information about Object Storage Clusters on Vultr.

    ## Example Usage

    Get the information for an object storage cluster by `region`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage_cluster(filters=[{
        "name": "region",
        "values": ["ewr"],
    }])
    ```


    :param Sequence[Union['GetObjectStorageClusterFilterArgs', 'GetObjectStorageClusterFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getObjectStorageCluster:getObjectStorageCluster', __args__, opts=opts, typ=GetObjectStorageClusterResult).value

    return AwaitableGetObjectStorageClusterResult(
        deploy=pulumi.get(__ret__, 'deploy'),
        filters=pulumi.get(__ret__, 'filters'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_object_storage_cluster_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectStorageClusterFilterArgs', 'GetObjectStorageClusterFilterArgsDict']]]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageClusterResult]:
    """
    Get information about Object Storage Clusters on Vultr.

    ## Example Usage

    Get the information for an object storage cluster by `region`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage_cluster(filters=[{
        "name": "region",
        "values": ["ewr"],
    }])
    ```


    :param Sequence[Union['GetObjectStorageClusterFilterArgs', 'GetObjectStorageClusterFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getObjectStorageCluster:getObjectStorageCluster', __args__, opts=opts, typ=GetObjectStorageClusterResult)
    return __ret__.apply(lambda __response__: GetObjectStorageClusterResult(
        deploy=pulumi.get(__response__, 'deploy'),
        filters=pulumi.get(__response__, 'filters'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
