# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectStorageTierResult',
    'AwaitableGetObjectStorageTierResult',
    'get_object_storage_tier',
    'get_object_storage_tier_output',
]

@pulumi.output_type
class GetObjectStorageTierResult:
    """
    A collection of values returned by getObjectStorageTier.
    """
    def __init__(__self__, filters=None, id=None, locations=None, price=None, rate_limit_bytes=None, rate_limit_operations=None, slug=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if price and not isinstance(price, int):
            raise TypeError("Expected argument 'price' to be a int")
        pulumi.set(__self__, "price", price)
        if rate_limit_bytes and not isinstance(rate_limit_bytes, int):
            raise TypeError("Expected argument 'rate_limit_bytes' to be a int")
        pulumi.set(__self__, "rate_limit_bytes", rate_limit_bytes)
        if rate_limit_operations and not isinstance(rate_limit_operations, int):
            raise TypeError("Expected argument 'rate_limit_operations' to be a int")
        pulumi.set(__self__, "rate_limit_operations", rate_limit_operations)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectStorageTierFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The identifying tier ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetObjectStorageTierLocationResult']:
        """
        A list of locations/clusters where the tier is available.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.int:
        """
        The monthly cost for the tier.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="rateLimitBytes")
    def rate_limit_bytes(self) -> _builtins.int:
        """
        The byte-per-second rate limit in the tier.
        """
        return pulumi.get(self, "rate_limit_bytes")

    @_builtins.property
    @pulumi.getter(name="rateLimitOperations")
    def rate_limit_operations(self) -> _builtins.int:
        """
        The operations-per-second rate limit in the tier.
        """
        return pulumi.get(self, "rate_limit_operations")

    @_builtins.property
    @pulumi.getter
    def slug(self) -> _builtins.str:
        """
        The unique name for the tier.
        """
        return pulumi.get(self, "slug")


class AwaitableGetObjectStorageTierResult(GetObjectStorageTierResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageTierResult(
            filters=self.filters,
            id=self.id,
            locations=self.locations,
            price=self.price,
            rate_limit_bytes=self.rate_limit_bytes,
            rate_limit_operations=self.rate_limit_operations,
            slug=self.slug)


def get_object_storage_tier(filters: Optional[Sequence[Union['GetObjectStorageTierFilterArgs', 'GetObjectStorageTierFilterArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageTierResult:
    """
    Get information about Object Storage tiers on Vultr.

    ## Example Usage

    Get the information for an object storage tier by `slug`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    obs_tier = vultr.get_object_storage_tier(filters=[{
        "name": "slug",
        "values": ["tier_010k_5000m"],
    }])
    ```

    `slug` values and associated details can be retrieved through [this API call](https://www.vultr.com/api/#tag/s3/operation/list-object-storage-tiers).


    :param Sequence[Union['GetObjectStorageTierFilterArgs', 'GetObjectStorageTierFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getObjectStorageTier:getObjectStorageTier', __args__, opts=opts, typ=GetObjectStorageTierResult).value

    return AwaitableGetObjectStorageTierResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'),
        price=pulumi.get(__ret__, 'price'),
        rate_limit_bytes=pulumi.get(__ret__, 'rate_limit_bytes'),
        rate_limit_operations=pulumi.get(__ret__, 'rate_limit_operations'),
        slug=pulumi.get(__ret__, 'slug'))
def get_object_storage_tier_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetObjectStorageTierFilterArgs', 'GetObjectStorageTierFilterArgsDict']]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageTierResult]:
    """
    Get information about Object Storage tiers on Vultr.

    ## Example Usage

    Get the information for an object storage tier by `slug`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    obs_tier = vultr.get_object_storage_tier(filters=[{
        "name": "slug",
        "values": ["tier_010k_5000m"],
    }])
    ```

    `slug` values and associated details can be retrieved through [this API call](https://www.vultr.com/api/#tag/s3/operation/list-object-storage-tiers).


    :param Sequence[Union['GetObjectStorageTierFilterArgs', 'GetObjectStorageTierFilterArgsDict']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getObjectStorageTier:getObjectStorageTier', __args__, opts=opts, typ=GetObjectStorageTierResult)
    return __ret__.apply(lambda __response__: GetObjectStorageTierResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        locations=pulumi.get(__response__, 'locations'),
        price=pulumi.get(__response__, 'price'),
        rate_limit_bytes=pulumi.get(__response__, 'rate_limit_bytes'),
        rate_limit_operations=pulumi.get(__response__, 'rate_limit_operations'),
        slug=pulumi.get(__response__, 'slug')))
