# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegionResult',
    'AwaitableGetRegionResult',
    'get_region',
    'get_region_output',
]

@pulumi.output_type
class GetRegionResult:
    """
    A collection of values returned by getRegion.
    """
    def __init__(__self__, city=None, continent=None, country=None, filters=None, id=None, options=None):
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if continent and not isinstance(continent, str):
            raise TypeError("Expected argument 'continent' to be a str")
        pulumi.set(__self__, "continent", continent)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if options and not isinstance(options, list):
            raise TypeError("Expected argument 'options' to be a list")
        pulumi.set(__self__, "options", options)

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        The city the region is in.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def continent(self) -> _builtins.str:
        """
        The continent the region is in.
        """
        return pulumi.get(self, "continent")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        The country the region is in.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRegionFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence[_builtins.str]:
        """
        Shows whether options like ddos protection or block storage are available in the region.
        """
        return pulumi.get(self, "options")


class AwaitableGetRegionResult(GetRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionResult(
            city=self.city,
            continent=self.continent,
            country=self.country,
            filters=self.filters,
            id=self.id,
            options=self.options)


def get_region(filters: Optional[Sequence[Union['GetRegionFilterArgs', 'GetRegionFilterArgsDict']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionResult:
    """
    Get information about a Vultr region.

    ## Example Usage

    Get the information for a region by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_region = vultr.get_region(filters=[{
        "name": "id",
        "values": ["sea"],
    }])
    ```


    :param Sequence[Union['GetRegionFilterArgs', 'GetRegionFilterArgsDict']] filters: Query parameters for finding regions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getRegion:getRegion', __args__, opts=opts, typ=GetRegionResult).value

    return AwaitableGetRegionResult(
        city=pulumi.get(__ret__, 'city'),
        continent=pulumi.get(__ret__, 'continent'),
        country=pulumi.get(__ret__, 'country'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        options=pulumi.get(__ret__, 'options'))
def get_region_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRegionFilterArgs', 'GetRegionFilterArgsDict']]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionResult]:
    """
    Get information about a Vultr region.

    ## Example Usage

    Get the information for a region by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_region = vultr.get_region(filters=[{
        "name": "id",
        "values": ["sea"],
    }])
    ```


    :param Sequence[Union['GetRegionFilterArgs', 'GetRegionFilterArgsDict']] filters: Query parameters for finding regions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getRegion:getRegion', __args__, opts=opts, typ=GetRegionResult)
    return __ret__.apply(lambda __response__: GetRegionResult(
        city=pulumi.get(__response__, 'city'),
        continent=pulumi.get(__response__, 'continent'),
        country=pulumi.get(__response__, 'country'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        options=pulumi.get(__response__, 'options')))
