# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReverseIpv4Result',
    'AwaitableGetReverseIpv4Result',
    'get_reverse_ipv4',
    'get_reverse_ipv4_output',
]

@pulumi.output_type
class GetReverseIpv4Result:
    """
    A collection of values returned by getReverseIpv4.
    """
    def __init__(__self__, filters=None, gateway=None, id=None, instance_id=None, ip=None, netmask=None, reverse=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway and not isinstance(gateway, str):
            raise TypeError("Expected argument 'gateway' to be a str")
        pulumi.set(__self__, "gateway", gateway)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if netmask and not isinstance(netmask, str):
            raise TypeError("Expected argument 'netmask' to be a str")
        pulumi.set(__self__, "netmask", netmask)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReverseIpv4FilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        The gateway IP address.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance the IPv4 reverse DNS record was set for.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IPv4 address in canonical format used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> _builtins.str:
        """
        The IPv4 netmask in dot-decimal notation.
        """
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The hostname used in the IPv4 reverse DNS record.
        """
        return pulumi.get(self, "reverse")


class AwaitableGetReverseIpv4Result(GetReverseIpv4Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReverseIpv4Result(
            filters=self.filters,
            gateway=self.gateway,
            id=self.id,
            instance_id=self.instance_id,
            ip=self.ip,
            netmask=self.netmask,
            reverse=self.reverse)


def get_reverse_ipv4(filters: Optional[Sequence[Union['GetReverseIpv4FilterArgs', 'GetReverseIpv4FilterArgsDict']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReverseIpv4Result:
    """
    Get information about a Vultr Reverse IPv4.

    ## Example Usage

    Get the information for an IPv4 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv4 = vultr.get_reverse_ipv4(filters=[{
        "name": "reverse",
        "values": ["host.example.com"],
    }])
    ```


    :param Sequence[Union['GetReverseIpv4FilterArgs', 'GetReverseIpv4FilterArgsDict']] filters: Query parameters for finding IPv4 reverse DNS records.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getReverseIpv4:getReverseIpv4', __args__, opts=opts, typ=GetReverseIpv4Result).value

    return AwaitableGetReverseIpv4Result(
        filters=pulumi.get(__ret__, 'filters'),
        gateway=pulumi.get(__ret__, 'gateway'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        ip=pulumi.get(__ret__, 'ip'),
        netmask=pulumi.get(__ret__, 'netmask'),
        reverse=pulumi.get(__ret__, 'reverse'))
def get_reverse_ipv4_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReverseIpv4FilterArgs', 'GetReverseIpv4FilterArgsDict']]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReverseIpv4Result]:
    """
    Get information about a Vultr Reverse IPv4.

    ## Example Usage

    Get the information for an IPv4 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv4 = vultr.get_reverse_ipv4(filters=[{
        "name": "reverse",
        "values": ["host.example.com"],
    }])
    ```


    :param Sequence[Union['GetReverseIpv4FilterArgs', 'GetReverseIpv4FilterArgsDict']] filters: Query parameters for finding IPv4 reverse DNS records.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getReverseIpv4:getReverseIpv4', __args__, opts=opts, typ=GetReverseIpv4Result)
    return __ret__.apply(lambda __response__: GetReverseIpv4Result(
        filters=pulumi.get(__response__, 'filters'),
        gateway=pulumi.get(__response__, 'gateway'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        ip=pulumi.get(__response__, 'ip'),
        netmask=pulumi.get(__response__, 'netmask'),
        reverse=pulumi.get(__response__, 'reverse')))
