# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReverseIpv6Result',
    'AwaitableGetReverseIpv6Result',
    'get_reverse_ipv6',
    'get_reverse_ipv6_output',
]

@pulumi.output_type
class GetReverseIpv6Result:
    """
    A collection of values returned by getReverseIpv6.
    """
    def __init__(__self__, filters=None, id=None, instance_id=None, ip=None, reverse=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReverseIpv6FilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance the IPv6 reverse DNS record was set for.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IPv6 address in canonical format used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The hostname used in the IPv6 reverse DNS record.
        """
        return pulumi.get(self, "reverse")


class AwaitableGetReverseIpv6Result(GetReverseIpv6Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReverseIpv6Result(
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            ip=self.ip,
            reverse=self.reverse)


def get_reverse_ipv6(filters: Optional[Sequence[Union['GetReverseIpv6FilterArgs', 'GetReverseIpv6FilterArgsDict']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReverseIpv6Result:
    """
    Get information about a Vultr Reverse IPv6.

    ## Example Usage

    Get the information for an IPv6 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv6 = vultr.get_reverse_ipv6(filters=[{
        "name": "reverse",
        "values": ["host.example.com"],
    }])
    ```


    :param Sequence[Union['GetReverseIpv6FilterArgs', 'GetReverseIpv6FilterArgsDict']] filters: Query parameters for finding IPv6 reverse DNS records.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getReverseIpv6:getReverseIpv6', __args__, opts=opts, typ=GetReverseIpv6Result).value

    return AwaitableGetReverseIpv6Result(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        ip=pulumi.get(__ret__, 'ip'),
        reverse=pulumi.get(__ret__, 'reverse'))
def get_reverse_ipv6_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReverseIpv6FilterArgs', 'GetReverseIpv6FilterArgsDict']]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReverseIpv6Result]:
    """
    Get information about a Vultr Reverse IPv6.

    ## Example Usage

    Get the information for an IPv6 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv6 = vultr.get_reverse_ipv6(filters=[{
        "name": "reverse",
        "values": ["host.example.com"],
    }])
    ```


    :param Sequence[Union['GetReverseIpv6FilterArgs', 'GetReverseIpv6FilterArgsDict']] filters: Query parameters for finding IPv6 reverse DNS records.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getReverseIpv6:getReverseIpv6', __args__, opts=opts, typ=GetReverseIpv6Result)
    return __ret__.apply(lambda __response__: GetReverseIpv6Result(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        ip=pulumi.get(__response__, 'ip'),
        reverse=pulumi.get(__response__, 'reverse')))
