# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, app_id=None, date_created=None, description=None, filters=None, id=None, os_id=None, size=None, status=None):
        if app_id and not isinstance(app_id, int):
            raise TypeError("Expected argument 'app_id' to be a int")
        pulumi.set(__self__, "app_id", app_id)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if os_id and not isinstance(os_id, int):
            raise TypeError("Expected argument 'os_id' to be a int")
        pulumi.set(__self__, "os_id", os_id)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.int:
        """
        The application ID of the snapshot.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the snapshot was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the snapshot.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSnapshotFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> _builtins.int:
        """
        The operating system ID of the snapshot.
        """
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the snapshot in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            app_id=self.app_id,
            date_created=self.date_created,
            description=self.description,
            filters=self.filters,
            id=self.id,
            os_id=self.os_id,
            size=self.size,
            status=self.status)


def get_snapshot(filters: Optional[Sequence[Union['GetSnapshotFilterArgs', 'GetSnapshotFilterArgsDict']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    Get information about a Vultr snapshot.

    ## Example Usage

    Get the information for a snapshot by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_snapshot = vultr.get_snapshot(filters=[{
        "name": "description",
        "values": ["my-snapshot-description"],
    }])
    ```


    :param Sequence[Union['GetSnapshotFilterArgs', 'GetSnapshotFilterArgsDict']] filters: Query parameters for finding snapshots.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        date_created=pulumi.get(__ret__, 'date_created'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        os_id=pulumi.get(__ret__, 'os_id'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'))
def get_snapshot_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSnapshotFilterArgs', 'GetSnapshotFilterArgsDict']]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    Get information about a Vultr snapshot.

    ## Example Usage

    Get the information for a snapshot by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_snapshot = vultr.get_snapshot(filters=[{
        "name": "description",
        "values": ["my-snapshot-description"],
    }])
    ```


    :param Sequence[Union['GetSnapshotFilterArgs', 'GetSnapshotFilterArgsDict']] filters: Query parameters for finding snapshots.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult)
    return __ret__.apply(lambda __response__: GetSnapshotResult(
        app_id=pulumi.get(__response__, 'app_id'),
        date_created=pulumi.get(__response__, 'date_created'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        os_id=pulumi.get(__response__, 'os_id'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status')))
