# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStartupScriptResult',
    'AwaitableGetStartupScriptResult',
    'get_startup_script',
    'get_startup_script_output',
]

@pulumi.output_type
class GetStartupScriptResult:
    """
    A collection of values returned by getStartupScript.
    """
    def __init__(__self__, date_created=None, date_modified=None, filters=None, id=None, name=None, script=None, type=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if script and not isinstance(script, str):
            raise TypeError("Expected argument 'script' to be a str")
        pulumi.set(__self__, "script", script)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the startup script was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        The date the startup script was last modified.
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStartupScriptFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the startup script.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        The contents of the startup script base64 encoded.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the startup script.
        """
        return pulumi.get(self, "type")


class AwaitableGetStartupScriptResult(GetStartupScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStartupScriptResult(
            date_created=self.date_created,
            date_modified=self.date_modified,
            filters=self.filters,
            id=self.id,
            name=self.name,
            script=self.script,
            type=self.type)


def get_startup_script(filters: Optional[Sequence[Union['GetStartupScriptFilterArgs', 'GetStartupScriptFilterArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStartupScriptResult:
    """
    Get information about a Vultr startup script. This data source provides the name, script, type, creation date, and the last modification date for your Vultr startup script.

    ## Example Usage

    Get the information for a startup script by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_startup_script = vultr.get_startup_script(filters=[{
        "name": "name",
        "values": ["my-startup-script-name"],
    }])
    ```


    :param Sequence[Union['GetStartupScriptFilterArgs', 'GetStartupScriptFilterArgsDict']] filters: Query parameters for finding startup scripts.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getStartupScript:getStartupScript', __args__, opts=opts, typ=GetStartupScriptResult).value

    return AwaitableGetStartupScriptResult(
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        script=pulumi.get(__ret__, 'script'),
        type=pulumi.get(__ret__, 'type'))
def get_startup_script_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStartupScriptFilterArgs', 'GetStartupScriptFilterArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStartupScriptResult]:
    """
    Get information about a Vultr startup script. This data source provides the name, script, type, creation date, and the last modification date for your Vultr startup script.

    ## Example Usage

    Get the information for a startup script by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_startup_script = vultr.get_startup_script(filters=[{
        "name": "name",
        "values": ["my-startup-script-name"],
    }])
    ```


    :param Sequence[Union['GetStartupScriptFilterArgs', 'GetStartupScriptFilterArgsDict']] filters: Query parameters for finding startup scripts.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getStartupScript:getStartupScript', __args__, opts=opts, typ=GetStartupScriptResult)
    return __ret__.apply(lambda __response__: GetStartupScriptResult(
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        script=pulumi.get(__response__, 'script'),
        type=pulumi.get(__response__, 'type')))
