# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, acls=None, api_enabled=None, email=None, filters=None, id=None, name=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if api_enabled and not isinstance(api_enabled, bool):
            raise TypeError("Expected argument 'api_enabled' to be a bool")
        pulumi.set(__self__, "api_enabled", api_enabled)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        The access control list for the user.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="apiEnabled")
    def api_enabled(self) -> _builtins.bool:
        """
        Whether API is enabled for the user.
        """
        return pulumi.get(self, "api_enabled")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            acls=self.acls,
            api_enabled=self.api_enabled,
            email=self.email,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_user(filters: Optional[Sequence[Union['GetUserFilterArgs', 'GetUserFilterArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Get information about a Vultr user associated with your account. This data source provides the name, email, access control list, and API status for a Vultr user associated with your account.

    ## Example Usage

    Get the information for a user by `email`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[{
        "name": "email",
        "values": ["jdoe@example.com"],
    }])
    ```

    Get the information for a user by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[{
        "name": "name",
        "values": ["John Doe"],
    }])
    ```


    :param Sequence[Union['GetUserFilterArgs', 'GetUserFilterArgsDict']] filters: Query parameters for finding users.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        acls=pulumi.get(__ret__, 'acls'),
        api_enabled=pulumi.get(__ret__, 'api_enabled'),
        email=pulumi.get(__ret__, 'email'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_user_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUserFilterArgs', 'GetUserFilterArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Get information about a Vultr user associated with your account. This data source provides the name, email, access control list, and API status for a Vultr user associated with your account.

    ## Example Usage

    Get the information for a user by `email`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[{
        "name": "email",
        "values": ["jdoe@example.com"],
    }])
    ```

    Get the information for a user by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[{
        "name": "name",
        "values": ["John Doe"],
    }])
    ```


    :param Sequence[Union['GetUserFilterArgs', 'GetUserFilterArgsDict']] filters: Query parameters for finding users.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        acls=pulumi.get(__response__, 'acls'),
        api_enabled=pulumi.get(__response__, 'api_enabled'),
        email=pulumi.get(__response__, 'email'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
