# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualFileSystemStorageResult',
    'AwaitableGetVirtualFileSystemStorageResult',
    'get_virtual_file_system_storage',
    'get_virtual_file_system_storage_output',
]

@pulumi.output_type
class GetVirtualFileSystemStorageResult:
    """
    A collection of values returned by getVirtualFileSystemStorage.
    """
    def __init__(__self__, attached_instances=None, attachments=None, charges=None, cost=None, date_created=None, disk_type=None, filters=None, id=None, label=None, region=None, size_gb=None, status=None, tags=None):
        if attached_instances and not isinstance(attached_instances, list):
            raise TypeError("Expected argument 'attached_instances' to be a list")
        pulumi.set(__self__, "attached_instances", attached_instances)
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if charges and not isinstance(charges, float):
            raise TypeError("Expected argument 'charges' to be a float")
        pulumi.set(__self__, "charges", charges)
        if cost and not isinstance(cost, float):
            raise TypeError("Expected argument 'cost' to be a float")
        pulumi.set(__self__, "cost", cost)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if disk_type and not isinstance(disk_type, str):
            raise TypeError("Expected argument 'disk_type' to be a str")
        pulumi.set(__self__, "disk_type", disk_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size_gb and not isinstance(size_gb, int):
            raise TypeError("Expected argument 'size_gb' to be a int")
        pulumi.set(__self__, "size_gb", size_gb)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> Sequence[_builtins.str]:
        """
        A list of instance IDs currently attached to the virtual file system storage.
        """
        return pulumi.get(self, "attached_instances")

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetVirtualFileSystemStorageAttachmentResult']:
        """
        A list of attchment states for instances currently attached to the virtual file system storage.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter
    def charges(self) -> _builtins.float:
        """
        The current pending charges for the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "charges")

    @_builtins.property
    @pulumi.getter
    def cost(self) -> _builtins.float:
        """
        The cost per month of the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "cost")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the virtual file system storage subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        The underlying disk type used by the virtual file system storage subscription.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualFileSystemStorageFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label of the virtual file system storage subscription.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the virtual file system storage subscription.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        The size of the virtual file system storage subscription in GB.
        """
        return pulumi.get(self, "size_gb")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the virtual file system storage subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of tags used on the virtual file system storage subscription.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVirtualFileSystemStorageResult(GetVirtualFileSystemStorageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualFileSystemStorageResult(
            attached_instances=self.attached_instances,
            attachments=self.attachments,
            charges=self.charges,
            cost=self.cost,
            date_created=self.date_created,
            disk_type=self.disk_type,
            filters=self.filters,
            id=self.id,
            label=self.label,
            region=self.region,
            size_gb=self.size_gb,
            status=self.status,
            tags=self.tags)


def get_virtual_file_system_storage(filters: Optional[Sequence[Union['GetVirtualFileSystemStorageFilterArgs', 'GetVirtualFileSystemStorageFilterArgsDict']]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualFileSystemStorageResult:
    """
    Get information about a Vultr virtual file system storage subscription.

    ## Example Usage

    Get the information for a virtual file system storage subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vfs_storage = vultr.get_virtual_file_system_storage(filters=[{
        "name": "label",
        "values": ["my-vfs-storage-label"],
    }])
    ```


    :param Sequence[Union['GetVirtualFileSystemStorageFilterArgs', 'GetVirtualFileSystemStorageFilterArgsDict']] filters: Query parameters for finding virtual file system storage subscriptions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getVirtualFileSystemStorage:getVirtualFileSystemStorage', __args__, opts=opts, typ=GetVirtualFileSystemStorageResult).value

    return AwaitableGetVirtualFileSystemStorageResult(
        attached_instances=pulumi.get(__ret__, 'attached_instances'),
        attachments=pulumi.get(__ret__, 'attachments'),
        charges=pulumi.get(__ret__, 'charges'),
        cost=pulumi.get(__ret__, 'cost'),
        date_created=pulumi.get(__ret__, 'date_created'),
        disk_type=pulumi.get(__ret__, 'disk_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        region=pulumi.get(__ret__, 'region'),
        size_gb=pulumi.get(__ret__, 'size_gb'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_virtual_file_system_storage_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVirtualFileSystemStorageFilterArgs', 'GetVirtualFileSystemStorageFilterArgsDict']]]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualFileSystemStorageResult]:
    """
    Get information about a Vultr virtual file system storage subscription.

    ## Example Usage

    Get the information for a virtual file system storage subscription by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vfs_storage = vultr.get_virtual_file_system_storage(filters=[{
        "name": "label",
        "values": ["my-vfs-storage-label"],
    }])
    ```


    :param Sequence[Union['GetVirtualFileSystemStorageFilterArgs', 'GetVirtualFileSystemStorageFilterArgsDict']] filters: Query parameters for finding virtual file system storage subscriptions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getVirtualFileSystemStorage:getVirtualFileSystemStorage', __args__, opts=opts, typ=GetVirtualFileSystemStorageResult)
    return __ret__.apply(lambda __response__: GetVirtualFileSystemStorageResult(
        attached_instances=pulumi.get(__response__, 'attached_instances'),
        attachments=pulumi.get(__response__, 'attachments'),
        charges=pulumi.get(__response__, 'charges'),
        cost=pulumi.get(__response__, 'cost'),
        date_created=pulumi.get(__response__, 'date_created'),
        disk_type=pulumi.get(__response__, 'disk_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        region=pulumi.get(__response__, 'region'),
        size_gb=pulumi.get(__response__, 'size_gb'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
