# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpc2Result',
    'AwaitableGetVpc2Result',
    'get_vpc2',
    'get_vpc2_output',
]

@pulumi.output_type
class GetVpc2Result:
    """
    A collection of values returned by getVpc2.
    """
    def __init__(__self__, date_created=None, description=None, filters=None, id=None, ip_block=None, prefix_length=None, region=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_block and not isinstance(ip_block, str):
            raise TypeError("Expected argument 'ip_block' to be a str")
        pulumi.set(__self__, "ip_block", ip_block)
        if prefix_length and not isinstance(prefix_length, int):
            raise TypeError("Expected argument 'prefix_length' to be a int")
        pulumi.set(__self__, "prefix_length", prefix_length)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the VPC 2.0 was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The VPC 2.0's description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpc2FilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> _builtins.str:
        """
        The IPv4 network address. For example: 10.1.1.0.
        """
        return pulumi.get(self, "ip_block")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> _builtins.int:
        """
        The number of bits for the netmask in CIDR notation. Example: 20
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The ID of the region that the VPC 2.0 is in.
        """
        return pulumi.get(self, "region")


class AwaitableGetVpc2Result(GetVpc2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpc2Result(
            date_created=self.date_created,
            description=self.description,
            filters=self.filters,
            id=self.id,
            ip_block=self.ip_block,
            prefix_length=self.prefix_length,
            region=self.region)


def get_vpc2(filters: Optional[Sequence[Union['GetVpc2FilterArgs', 'GetVpc2FilterArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpc2Result:
    """
    ** Deprecated: Use `Vpc` instead **

    Get information about a Vultr VPC 2.0.

    ## Example Usage

    Get the information for a VPC 2.0 by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vpc2 = vultr.get_vpc2(filters=[{
        "name": "description",
        "values": ["my-vpc2-description"],
    }])
    ```


    :param Sequence[Union['GetVpc2FilterArgs', 'GetVpc2FilterArgsDict']] filters: Query parameters for finding VPCs 2.0.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getVpc2:getVpc2', __args__, opts=opts, typ=GetVpc2Result).value

    return AwaitableGetVpc2Result(
        date_created=pulumi.get(__ret__, 'date_created'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ip_block=pulumi.get(__ret__, 'ip_block'),
        prefix_length=pulumi.get(__ret__, 'prefix_length'),
        region=pulumi.get(__ret__, 'region'))
def get_vpc2_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpc2FilterArgs', 'GetVpc2FilterArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpc2Result]:
    """
    ** Deprecated: Use `Vpc` instead **

    Get information about a Vultr VPC 2.0.

    ## Example Usage

    Get the information for a VPC 2.0 by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_vpc2 = vultr.get_vpc2(filters=[{
        "name": "description",
        "values": ["my-vpc2-description"],
    }])
    ```


    :param Sequence[Union['GetVpc2FilterArgs', 'GetVpc2FilterArgsDict']] filters: Query parameters for finding VPCs 2.0.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vultr:index/getVpc2:getVpc2', __args__, opts=opts, typ=GetVpc2Result)
    return __ret__.apply(lambda __response__: GetVpc2Result(
        date_created=pulumi.get(__response__, 'date_created'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ip_block=pulumi.get(__response__, 'ip_block'),
        prefix_length=pulumi.get(__response__, 'prefix_length'),
        region=pulumi.get(__response__, 'region')))
