# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['InferenceArgs', 'Inference']

@pulumi.input_type
class InferenceArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Inference resource.
        :param pulumi.Input[_builtins.str] label: A label for the inference subscription.
        """
        pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A label for the inference subscription.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class _InferenceState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Inference resources.
        :param pulumi.Input[_builtins.str] api_key: The inference subscription's API key for accessing the Vultr Inference API.
        :param pulumi.Input[_builtins.str] date_created: The date the inference subscription was added to your Vultr account.
        :param pulumi.Input[_builtins.str] label: A label for the inference subscription.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The inference subscription's API key for accessing the Vultr Inference API.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the inference subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the inference subscription.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "usage", value)


@pulumi.type_token("vultr:index/inference:Inference")
class Inference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr Serverless Inference resource. This can be used to create, read, modify, and delete managed inference subscriptions on your Vultr account.

        ## Example Usage

        Create a new inference subscription:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_inference_subscription = vultr.Inference("myInferenceSubscription", label="my_inference_label")
        ```

        ## Import

        Inference subscriptions can be imported using the subscription's `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/inference:Inference my_inference_subscription b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] label: A label for the inference subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InferenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr Serverless Inference resource. This can be used to create, read, modify, and delete managed inference subscriptions on your Vultr account.

        ## Example Usage

        Create a new inference subscription:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_inference_subscription = vultr.Inference("myInferenceSubscription", label="my_inference_label")
        ```

        ## Import

        Inference subscriptions can be imported using the subscription's `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/inference:Inference my_inference_subscription b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param InferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InferenceArgs.__new__(InferenceArgs)

            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["api_key"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["usage"] = None
        super(Inference, __self__).__init__(
            'vultr:index/inference:Inference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            usage: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Inference':
        """
        Get an existing Inference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The inference subscription's API key for accessing the Vultr Inference API.
        :param pulumi.Input[_builtins.str] date_created: The date the inference subscription was added to your Vultr account.
        :param pulumi.Input[_builtins.str] label: A label for the inference subscription.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InferenceState.__new__(_InferenceState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["label"] = label
        __props__.__dict__["usage"] = usage
        return Inference(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        The inference subscription's API key for accessing the Vultr Inference API.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the inference subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A label for the inference subscription.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "usage")

