# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesArgs', 'Kubernetes']

@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 enable_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_controlplanes: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_pools: Optional[pulumi.Input['KubernetesNodePoolsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Kubernetes resource.
        :param pulumi.Input[_builtins.str] label: The VKE clusters label.
        :param pulumi.Input[_builtins.str] region: The region your VKE cluster will be deployed in.
        :param pulumi.Input[_builtins.str] version: The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        :param pulumi.Input[_builtins.bool] enable_firewall: Boolean indicating if the cluster should be created with a managed firewall.
        :param pulumi.Input[_builtins.bool] ha_controlplanes: Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        :param pulumi.Input['KubernetesNodePoolsArgs'] node_pools: Contains the default node pool that was deployed.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "version", version)
        if enable_firewall is not None:
            pulumi.set(__self__, "enable_firewall", enable_firewall)
        if ha_controlplanes is not None:
            pulumi.set(__self__, "ha_controlplanes", ha_controlplanes)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The VKE clusters label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region your VKE cluster will be deployed in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="enableFirewall")
    def enable_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with a managed firewall.
        """
        return pulumi.get(self, "enable_firewall")

    @enable_firewall.setter
    def enable_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_firewall", value)

    @_builtins.property
    @pulumi.getter(name="haControlplanes")
    def ha_controlplanes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        """
        return pulumi.get(self, "ha_controlplanes")

    @ha_controlplanes.setter
    def ha_controlplanes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_controlplanes", value)

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[pulumi.Input['KubernetesNodePoolsArgs']]:
        """
        Contains the default node pool that was deployed.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: Optional[pulumi.Input['KubernetesNodePoolsArgs']]):
        pulumi.set(self, "node_pools", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _KubernetesState:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_controlplanes: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pools: Optional[pulumi.Input['KubernetesNodePoolsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Kubernetes resources.
        :param pulumi.Input[_builtins.str] client_certificate: The base64 encoded public certificate used by clients to access the cluster.
        :param pulumi.Input[_builtins.str] client_key: The base64 encoded private key used by clients to access the cluster.
        :param pulumi.Input[_builtins.str] cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param pulumi.Input[_builtins.str] cluster_subnet: IP range that your pods will run on in this cluster.
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.bool] enable_firewall: Boolean indicating if the cluster should be created with a managed firewall.
        :param pulumi.Input[_builtins.str] endpoint: Domain for your Kubernetes clusters control plane.
        :param pulumi.Input[_builtins.str] firewall_group_id: The ID of the firewall group managed by this cluster.
        :param pulumi.Input[_builtins.bool] ha_controlplanes: Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        :param pulumi.Input[_builtins.str] ip: IP address of VKE cluster control plane.
        :param pulumi.Input[_builtins.str] kube_config: Base64 encoded Kubeconfig for this VKE cluster.
        :param pulumi.Input[_builtins.str] label: The VKE clusters label.
        :param pulumi.Input['KubernetesNodePoolsArgs'] node_pools: Contains the default node pool that was deployed.
        :param pulumi.Input[_builtins.str] region: The region your VKE cluster will be deployed in.
        :param pulumi.Input[_builtins.str] service_subnet: IP range that services will run on this cluster.
        :param pulumi.Input[_builtins.str] status: Status of node.
        :param pulumi.Input[_builtins.str] version: The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if cluster_subnet is not None:
            pulumi.set(__self__, "cluster_subnet", cluster_subnet)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if enable_firewall is not None:
            pulumi.set(__self__, "enable_firewall", enable_firewall)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if firewall_group_id is not None:
            pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        if ha_controlplanes is not None:
            pulumi.set(__self__, "ha_controlplanes", ha_controlplanes)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_subnet is not None:
            pulumi.set(__self__, "service_subnet", service_subnet)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64 encoded public certificate used by clients to access the cluster.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64 encoded private key used by clients to access the cluster.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP range that your pods will run on in this cluster.
        """
        return pulumi.get(self, "cluster_subnet")

    @cluster_subnet.setter
    def cluster_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_subnet", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="enableFirewall")
    def enable_firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with a managed firewall.
        """
        return pulumi.get(self, "enable_firewall")

    @enable_firewall.setter
    def enable_firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_firewall", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain for your Kubernetes clusters control plane.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the firewall group managed by this cluster.
        """
        return pulumi.get(self, "firewall_group_id")

    @firewall_group_id.setter
    def firewall_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_group_id", value)

    @_builtins.property
    @pulumi.getter(name="haControlplanes")
    def ha_controlplanes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        """
        return pulumi.get(self, "ha_controlplanes")

    @ha_controlplanes.setter
    def ha_controlplanes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_controlplanes", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of VKE cluster control plane.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded Kubeconfig for this VKE cluster.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VKE clusters label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[pulumi.Input['KubernetesNodePoolsArgs']]:
        """
        Contains the default node pool that was deployed.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: Optional[pulumi.Input['KubernetesNodePoolsArgs']]):
        pulumi.set(self, "node_pools", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region your VKE cluster will be deployed in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP range that services will run on this cluster.
        """
        return pulumi.get(self, "service_subnet")

    @service_subnet.setter
    def service_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_subnet", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("vultr:index/kubernetes:Kubernetes")
class Kubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_controlplanes: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pools: Optional[pulumi.Input[Union['KubernetesNodePoolsArgs', 'KubernetesNodePoolsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Create a new VKE cluster:

        ```python
        import pulumi
        import ediri_vultr as vultr

        k8 = vultr.Kubernetes("k8",
            label="vke-test",
            node_pools={
                "auto_scaler": True,
                "label": "vke-nodepool",
                "labels": {
                    "my-label": "a-label-on-all-nodes",
                    "my-second-label": "another-label-on-all-nodes",
                },
                "max_nodes": 2,
                "min_nodes": 1,
                "node_quantity": 1,
                "plan": "vc2-1c-2gb",
                "taints": [{
                    "effect": "NoExecute",
                    "key": "a-taint",
                    "value": "is-tainted",
                }],
            },
            region="ewr",
            version="v1.28.2+1")
        ```

        A default node pool is required when first creating the resource but it can be removed at a later point so long as there is a separate `KubernetesNodePools` resource attached. For example:

        ```python
        import pulumi
        import ediri_vultr as vultr

        k8 = vultr.Kubernetes("k8",
            region="ewr",
            label="vke-test",
            version="v1.28.2+1")
        # This resource must be created and attached to the cluster
        # before removing the default node from the vultr_kubernetes resource
        np = vultr.KubernetesNodePools("np",
            cluster_id=k8.id,
            node_quantity=1,
            plan="vc2-1c-2gb",
            label="vke-nodepool",
            auto_scaler=True,
            min_nodes=1,
            max_nodes=2)
        ```

        There is still a requirement that there be one node pool attached to the cluster but this should allow more flexibility about which node pool that is.

        ## Import

        A kubernetes cluster created outside of terraform can be imported into the

        terraform state using the UUID.  One thing to note is that all kubernetes

        resources have a default node pool with a tag of `tf-vke-default`. In order to

        avoid errors, ensure that there is a node pool with that tag set.

        ```sh
        $ pulumi import vultr:index/kubernetes:Kubernetes my-k8s 7365a98b-5a43-450f-bd27-d768827100e5
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_firewall: Boolean indicating if the cluster should be created with a managed firewall.
        :param pulumi.Input[_builtins.bool] ha_controlplanes: Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        :param pulumi.Input[_builtins.str] label: The VKE clusters label.
        :param pulumi.Input[Union['KubernetesNodePoolsArgs', 'KubernetesNodePoolsArgsDict']] node_pools: Contains the default node pool that was deployed.
        :param pulumi.Input[_builtins.str] region: The region your VKE cluster will be deployed in.
        :param pulumi.Input[_builtins.str] version: The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Create a new VKE cluster:

        ```python
        import pulumi
        import ediri_vultr as vultr

        k8 = vultr.Kubernetes("k8",
            label="vke-test",
            node_pools={
                "auto_scaler": True,
                "label": "vke-nodepool",
                "labels": {
                    "my-label": "a-label-on-all-nodes",
                    "my-second-label": "another-label-on-all-nodes",
                },
                "max_nodes": 2,
                "min_nodes": 1,
                "node_quantity": 1,
                "plan": "vc2-1c-2gb",
                "taints": [{
                    "effect": "NoExecute",
                    "key": "a-taint",
                    "value": "is-tainted",
                }],
            },
            region="ewr",
            version="v1.28.2+1")
        ```

        A default node pool is required when first creating the resource but it can be removed at a later point so long as there is a separate `KubernetesNodePools` resource attached. For example:

        ```python
        import pulumi
        import ediri_vultr as vultr

        k8 = vultr.Kubernetes("k8",
            region="ewr",
            label="vke-test",
            version="v1.28.2+1")
        # This resource must be created and attached to the cluster
        # before removing the default node from the vultr_kubernetes resource
        np = vultr.KubernetesNodePools("np",
            cluster_id=k8.id,
            node_quantity=1,
            plan="vc2-1c-2gb",
            label="vke-nodepool",
            auto_scaler=True,
            min_nodes=1,
            max_nodes=2)
        ```

        There is still a requirement that there be one node pool attached to the cluster but this should allow more flexibility about which node pool that is.

        ## Import

        A kubernetes cluster created outside of terraform can be imported into the

        terraform state using the UUID.  One thing to note is that all kubernetes

        resources have a default node pool with a tag of `tf-vke-default`. In order to

        avoid errors, ensure that there is a node pool with that tag set.

        ```sh
        $ pulumi import vultr:index/kubernetes:Kubernetes my-k8s 7365a98b-5a43-450f-bd27-d768827100e5
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_controlplanes: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pools: Optional[pulumi.Input[Union['KubernetesNodePoolsArgs', 'KubernetesNodePoolsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesArgs.__new__(KubernetesArgs)

            __props__.__dict__["enable_firewall"] = enable_firewall
            __props__.__dict__["ha_controlplanes"] = ha_controlplanes
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["node_pools"] = node_pools
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["client_certificate"] = None
            __props__.__dict__["client_key"] = None
            __props__.__dict__["cluster_ca_certificate"] = None
            __props__.__dict__["cluster_subnet"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["firewall_group_id"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["service_subnet"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientCertificate", "clientKey", "clusterCaCertificate", "kubeConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Kubernetes, __self__).__init__(
            'vultr:index/kubernetes:Kubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            enable_firewall: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ha_controlplanes: Optional[pulumi.Input[_builtins.bool]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            node_pools: Optional[pulumi.Input[Union['KubernetesNodePoolsArgs', 'KubernetesNodePoolsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Kubernetes':
        """
        Get an existing Kubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_certificate: The base64 encoded public certificate used by clients to access the cluster.
        :param pulumi.Input[_builtins.str] client_key: The base64 encoded private key used by clients to access the cluster.
        :param pulumi.Input[_builtins.str] cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param pulumi.Input[_builtins.str] cluster_subnet: IP range that your pods will run on in this cluster.
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.bool] enable_firewall: Boolean indicating if the cluster should be created with a managed firewall.
        :param pulumi.Input[_builtins.str] endpoint: Domain for your Kubernetes clusters control plane.
        :param pulumi.Input[_builtins.str] firewall_group_id: The ID of the firewall group managed by this cluster.
        :param pulumi.Input[_builtins.bool] ha_controlplanes: Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        :param pulumi.Input[_builtins.str] ip: IP address of VKE cluster control plane.
        :param pulumi.Input[_builtins.str] kube_config: Base64 encoded Kubeconfig for this VKE cluster.
        :param pulumi.Input[_builtins.str] label: The VKE clusters label.
        :param pulumi.Input[Union['KubernetesNodePoolsArgs', 'KubernetesNodePoolsArgsDict']] node_pools: Contains the default node pool that was deployed.
        :param pulumi.Input[_builtins.str] region: The region your VKE cluster will be deployed in.
        :param pulumi.Input[_builtins.str] service_subnet: IP range that services will run on this cluster.
        :param pulumi.Input[_builtins.str] status: Status of node.
        :param pulumi.Input[_builtins.str] version: The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesState.__new__(_KubernetesState)

        __props__.__dict__["client_certificate"] = client_certificate
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_certificate"] = cluster_ca_certificate
        __props__.__dict__["cluster_subnet"] = cluster_subnet
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["enable_firewall"] = enable_firewall
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["firewall_group_id"] = firewall_group_id
        __props__.__dict__["ha_controlplanes"] = ha_controlplanes
        __props__.__dict__["ip"] = ip
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["label"] = label
        __props__.__dict__["node_pools"] = node_pools
        __props__.__dict__["region"] = region
        __props__.__dict__["service_subnet"] = service_subnet
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return Kubernetes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The base64 encoded public certificate used by clients to access the cluster.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[_builtins.str]:
        """
        The base64 encoded private key used by clients to access the cluster.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="clusterSubnet")
    def cluster_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        IP range that your pods will run on in this cluster.
        """
        return pulumi.get(self, "cluster_subnet")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="enableFirewall")
    def enable_firewall(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with a managed firewall.
        """
        return pulumi.get(self, "enable_firewall")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Domain for your Kubernetes clusters control plane.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the firewall group managed by this cluster.
        """
        return pulumi.get(self, "firewall_group_id")

    @_builtins.property
    @pulumi.getter(name="haControlplanes")
    def ha_controlplanes(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean indicating if the cluster should be created with multiple, highly available controlplanes.
        """
        return pulumi.get(self, "ha_controlplanes")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP address of VKE cluster control plane.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[_builtins.str]:
        """
        Base64 encoded Kubeconfig for this VKE cluster.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The VKE clusters label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> pulumi.Output[Optional['outputs.KubernetesNodePools']]:
        """
        Contains the default node pool that was deployed.
        """
        return pulumi.get(self, "node_pools")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region your VKE cluster will be deployed in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceSubnet")
    def service_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        IP range that services will run on this cluster.
        """
        return pulumi.get(self, "service_subnet")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version your VKE cluster you want deployed. [See Available Version](https://www.vultr.com/api/#operation/get-kubernetes-versions)
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the VPC to use when creating the cluster. If not provided a new VPC will be created instead.
        """
        return pulumi.get(self, "vpc_id")

