# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesNodePoolsInitArgs', 'KubernetesNodePools']

@pulumi.input_type
class KubernetesNodePoolsInitArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 node_quantity: pulumi.Input[_builtins.int],
                 plan: pulumi.Input[_builtins.str],
                 auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KubernetesNodePools resource.
        :param pulumi.Input[_builtins.str] cluster_id: The VKE cluster ID you want to attach this nodepool to.
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[_builtins.int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[_builtins.str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[_builtins.bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value pairs for Kubernetes node labels.
        :param pulumi.Input[_builtins.int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.str] tag: A tag that is assigned to this node pool.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        :param pulumi.Input[_builtins.str] user_data: A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "plan", plan)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VKE cluster ID you want to attach this nodepool to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> pulumi.Input[_builtins.int]:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @node_quantity.setter
    def node_quantity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_quantity", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @auto_scaler.setter
    def auto_scaler(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaler", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A tag that is assigned to this node pool.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]:
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _KubernetesNodePoolsState:
    def __init__(__self__, *,
                 auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 node_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KubernetesNodePools resources.
        :param pulumi.Input[_builtins.bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[_builtins.str] cluster_id: The VKE cluster ID you want to attach this nodepool to.
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.str] date_updated: Date of node pool updates.
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value pairs for Kubernetes node labels.
        :param pulumi.Input[_builtins.int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]] nodes: Array that contains information about nodes within this node pool.
        :param pulumi.Input[_builtins.str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[_builtins.str] status: Status of node.
        :param pulumi.Input[_builtins.str] tag: A tag that is assigned to this node pool.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        :param pulumi.Input[_builtins.str] user_data: A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if node_quantity is not None:
            pulumi.set(__self__, "node_quantity", node_quantity)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @auto_scaler.setter
    def auto_scaler(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaler", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VKE cluster ID you want to attach this nodepool to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @date_updated.setter
    def date_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_updated", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @node_quantity.setter
    def node_quantity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_quantity", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A tag that is assigned to this node pool.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]:
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("vultr:index/kubernetesNodePools:KubernetesNodePools")
class KubernetesNodePools(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 node_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsTaintArgs', 'KubernetesNodePoolsTaintArgsDict']]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Deploy additional node pools to an existing Vultr Kubernetes Engine (VKE) cluster.

        ## Import

        Node pool resources are able to be imported into terraform state like other

        resources, however, since they rely on a kubernetes cluster, the import state

        requires the UUID of the cluster as well. With that in mind, format the second

        argument to the `pulumi import` command as a space delimited string of

        UUIDs, the first is the cluster ID, the second is the node pool ID. It will

        look like this:

        "clusterID nodePoolID"

        ```sh
        $ pulumi import vultr:index/kubernetesNodePools:KubernetesNodePools my-k8s-np "7365a98b-5a43-450f-bd27-d768827100e5 ec330340-4f50-4526-858f-a39199f568ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[_builtins.str] cluster_id: The VKE cluster ID you want to attach this nodepool to.
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value pairs for Kubernetes node labels.
        :param pulumi.Input[_builtins.int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[_builtins.str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[_builtins.str] tag: A tag that is assigned to this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsTaintArgs', 'KubernetesNodePoolsTaintArgsDict']]]] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        :param pulumi.Input[_builtins.str] user_data: A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesNodePoolsInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deploy additional node pools to an existing Vultr Kubernetes Engine (VKE) cluster.

        ## Import

        Node pool resources are able to be imported into terraform state like other

        resources, however, since they rely on a kubernetes cluster, the import state

        requires the UUID of the cluster as well. With that in mind, format the second

        argument to the `pulumi import` command as a space delimited string of

        UUIDs, the first is the cluster ID, the second is the node pool ID. It will

        look like this:

        "clusterID nodePoolID"

        ```sh
        $ pulumi import vultr:index/kubernetesNodePools:KubernetesNodePools my-k8s-np "7365a98b-5a43-450f-bd27-d768827100e5 ec330340-4f50-4526-858f-a39199f568ac"
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesNodePoolsInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesNodePoolsInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 node_quantity: Optional[pulumi.Input[_builtins.int]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsTaintArgs', 'KubernetesNodePoolsTaintArgsDict']]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesNodePoolsInitArgs.__new__(KubernetesNodePoolsInitArgs)

            __props__.__dict__["auto_scaler"] = auto_scaler
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_nodes"] = max_nodes
            __props__.__dict__["min_nodes"] = min_nodes
            if node_quantity is None and not opts.urn:
                raise TypeError("Missing required property 'node_quantity'")
            __props__.__dict__["node_quantity"] = node_quantity
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["tag"] = tag
            __props__.__dict__["taints"] = taints
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_updated"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
        super(KubernetesNodePools, __self__).__init__(
            'vultr:index/kubernetesNodePools:KubernetesNodePools',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scaler: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_updated: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            node_quantity: Optional[pulumi.Input[_builtins.int]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsNodeArgs', 'KubernetesNodePoolsNodeArgsDict']]]]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsTaintArgs', 'KubernetesNodePoolsTaintArgsDict']]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'KubernetesNodePools':
        """
        Get an existing KubernetesNodePools resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[_builtins.str] cluster_id: The VKE cluster ID you want to attach this nodepool to.
        :param pulumi.Input[_builtins.str] date_created: Date node was created.
        :param pulumi.Input[_builtins.str] date_updated: Date of node pool updates.
        :param pulumi.Input[_builtins.str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value pairs for Kubernetes node labels.
        :param pulumi.Input[_builtins.int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[_builtins.int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsNodeArgs', 'KubernetesNodePoolsNodeArgsDict']]]] nodes: Array that contains information about nodes within this node pool.
        :param pulumi.Input[_builtins.str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[_builtins.str] status: Status of node.
        :param pulumi.Input[_builtins.str] tag: A tag that is assigned to this node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodePoolsTaintArgs', 'KubernetesNodePoolsTaintArgsDict']]]] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        :param pulumi.Input[_builtins.str] user_data: A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesNodePoolsState.__new__(_KubernetesNodePoolsState)

        __props__.__dict__["auto_scaler"] = auto_scaler
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_updated"] = date_updated
        __props__.__dict__["label"] = label
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_nodes"] = max_nodes
        __props__.__dict__["min_nodes"] = min_nodes
        __props__.__dict__["node_quantity"] = node_quantity
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["plan"] = plan
        __props__.__dict__["status"] = status
        __props__.__dict__["tag"] = tag
        __props__.__dict__["taints"] = taints
        __props__.__dict__["user_data"] = user_data
        return KubernetesNodePools(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VKE cluster ID you want to attach this nodepool to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> pulumi.Output[_builtins.int]:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.KubernetesNodePoolsNode']]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A tag that is assigned to this node pool.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesNodePoolsTaint']]]:
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A base64 encoded string containing the user data to apply to nodes in the node pool.
        """
        return pulumi.get(self, "user_data")

