# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'DatabaseReadReplica',
    'DatabaseUserAccessControl',
    'InstanceBackupsSchedule',
    'KubernetesNodePools',
    'KubernetesNodePoolsNode',
    'KubernetesNodePoolsTaint',
    'LoadBalancerFirewallRule',
    'LoadBalancerForwardingRule',
    'LoadBalancerHealthCheck',
    'LoadBalancerSsl',
    'VirtualFileSystemStorageAttachment',
    'GetApplicationFilterResult',
    'GetBackupFilterResult',
    'GetBareMetalPlanFilterResult',
    'GetBareMetalServerFilterResult',
    'GetBlockStorageFilterResult',
    'GetContainerRegistryFilterResult',
    'GetContainerRegistryRepositoryResult',
    'GetDatabaseFilterResult',
    'GetDatabaseReadReplicaResult',
    'GetFirewallGroupFilterResult',
    'GetInferenceFilterResult',
    'GetInstanceFilterResult',
    'GetInstanceIpv4FilterResult',
    'GetInstancesFilterResult',
    'GetInstancesInstanceResult',
    'GetIsoPrivateFilterResult',
    'GetIsoPublicFilterResult',
    'GetKubernetesFilterResult',
    'GetKubernetesNodePoolResult',
    'GetKubernetesNodePoolNodeResult',
    'GetKubernetesNodePoolTaintResult',
    'GetLoadBalancerFilterResult',
    'GetObjectStorageClusterFilterResult',
    'GetObjectStorageFilterResult',
    'GetObjectStorageTierFilterResult',
    'GetObjectStorageTierLocationResult',
    'GetOsFilterResult',
    'GetPlanFilterResult',
    'GetRegionFilterResult',
    'GetReservedIpFilterResult',
    'GetReverseIpv4FilterResult',
    'GetReverseIpv6FilterResult',
    'GetSnapshotFilterResult',
    'GetSshKeyFilterResult',
    'GetStartupScriptFilterResult',
    'GetUserFilterResult',
    'GetVirtualFileSystemStorageAttachmentResult',
    'GetVirtualFileSystemStorageFilterResult',
    'GetVpc2FilterResult',
    'GetVpcFilterResult',
]

@pulumi.output_type
class DatabaseReadReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupHour":
            suggest = "backup_hour"
        elif key == "backupMinute":
            suggest = "backup_minute"
        elif key == "clusterTimeZone":
            suggest = "cluster_time_zone"
        elif key == "databaseEngine":
            suggest = "database_engine"
        elif key == "databaseEngineVersion":
            suggest = "database_engine_version"
        elif key == "dateCreated":
            suggest = "date_created"
        elif key == "evictionPolicy":
            suggest = "eviction_policy"
        elif key == "ferretdbCredentials":
            suggest = "ferretdb_credentials"
        elif key == "latestBackup":
            suggest = "latest_backup"
        elif key == "maintenanceDow":
            suggest = "maintenance_dow"
        elif key == "maintenanceTime":
            suggest = "maintenance_time"
        elif key == "mysqlLongQueryTime":
            suggest = "mysql_long_query_time"
        elif key == "mysqlRequirePrimaryKey":
            suggest = "mysql_require_primary_key"
        elif key == "mysqlSlowQueryLog":
            suggest = "mysql_slow_query_log"
        elif key == "mysqlSqlModes":
            suggest = "mysql_sql_modes"
        elif key == "planDisk":
            suggest = "plan_disk"
        elif key == "planRam":
            suggest = "plan_ram"
        elif key == "planReplicas":
            suggest = "plan_replicas"
        elif key == "planVcpus":
            suggest = "plan_vcpus"
        elif key == "publicHost":
            suggest = "public_host"
        elif key == "trustedIps":
            suggest = "trusted_ips"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseReadReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseReadReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseReadReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 region: _builtins.str,
                 backup_hour: Optional[_builtins.str] = None,
                 backup_minute: Optional[_builtins.str] = None,
                 cluster_time_zone: Optional[_builtins.str] = None,
                 database_engine: Optional[_builtins.str] = None,
                 database_engine_version: Optional[_builtins.str] = None,
                 date_created: Optional[_builtins.str] = None,
                 dbname: Optional[_builtins.str] = None,
                 eviction_policy: Optional[_builtins.str] = None,
                 ferretdb_credentials: Optional[Mapping[str, _builtins.str]] = None,
                 host: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 latest_backup: Optional[_builtins.str] = None,
                 maintenance_dow: Optional[_builtins.str] = None,
                 maintenance_time: Optional[_builtins.str] = None,
                 mysql_long_query_time: Optional[_builtins.int] = None,
                 mysql_require_primary_key: Optional[_builtins.bool] = None,
                 mysql_slow_query_log: Optional[_builtins.bool] = None,
                 mysql_sql_modes: Optional[Sequence[_builtins.str]] = None,
                 password: Optional[_builtins.str] = None,
                 plan: Optional[_builtins.str] = None,
                 plan_disk: Optional[_builtins.int] = None,
                 plan_ram: Optional[_builtins.int] = None,
                 plan_replicas: Optional[_builtins.int] = None,
                 plan_vcpus: Optional[_builtins.int] = None,
                 port: Optional[_builtins.str] = None,
                 public_host: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 trusted_ips: Optional[Sequence[_builtins.str]] = None,
                 user: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: A label for the managed database.
        :param _builtins.str region: The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param _builtins.str backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param _builtins.str backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param _builtins.str cluster_time_zone: The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        :param _builtins.str database_engine: The database engine of the new managed database.
        :param _builtins.str database_engine_version: The database engine version of the new managed database.
        :param _builtins.str date_created: The date the managed database was added to your Vultr account.
        :param _builtins.str dbname: The managed database's default logical database.
        :param _builtins.str eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        :param _builtins.str host: The hostname assigned to the managed database.
        :param _builtins.str id: The ID of the managed database.
        :param _builtins.str latest_backup: The date of the latest backup available on the managed database.
        :param _builtins.str maintenance_dow: The preferred maintenance day of week for the managed database.
        :param _builtins.str maintenance_time: The preferred maintenance time for the managed database.
        :param _builtins.int mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param _builtins.bool mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param _builtins.bool mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param Sequence[_builtins.str] mysql_sql_modes: A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        :param _builtins.str password: The password for the managed database's primary admin user.
        :param _builtins.str plan: The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        :param _builtins.int plan_disk: The description of the disk(s) on the managed database.
        :param _builtins.int plan_ram: The amount of memory available on the managed database in MB.
        :param _builtins.int plan_replicas: The number of standby nodes available on the managed database (excluded for Kafka engine types).
        :param _builtins.int plan_vcpus: The number of virtual CPUs available on the managed database.
        :param _builtins.str port: The connection port for the managed database.
        :param _builtins.str public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param _builtins.str status: The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        :param _builtins.str tag: The tag to assign to the managed database.
        :param Sequence[_builtins.str] trusted_ips: A list of allowed IP addresses for the managed database.
        :param _builtins.str user: The primary admin user for the managed database.
        :param _builtins.str vpc_id: The ID of the VPC Network to attach to the Managed Database.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if database_engine is not None:
            pulumi.set(__self__, "database_engine", database_engine)
        if database_engine_version is not None:
            pulumi.set(__self__, "database_engine_version", database_engine_version)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if ferretdb_credentials is not None:
            pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if latest_backup is not None:
            pulumi.set(__self__, "latest_backup", latest_backup)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if mysql_long_query_time is not None:
            pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        if mysql_require_primary_key is not None:
            pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        if mysql_slow_query_log is not None:
            pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        if mysql_sql_modes is not None:
            pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_disk is not None:
            pulumi.set(__self__, "plan_disk", plan_disk)
        if plan_ram is not None:
            pulumi.set(__self__, "plan_ram", plan_ram)
        if plan_replicas is not None:
            pulumi.set(__self__, "plan_replicas", plan_replicas)
        if plan_vcpus is not None:
            pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_host is not None:
            pulumi.set(__self__, "public_host", public_host)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if trusted_ips is not None:
            pulumi.set(__self__, "trusted_ips", trusted_ips)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        A label for the managed database.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The ID of the region that the managed database is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[_builtins.str]:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[_builtins.str]:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[_builtins.str]:
        """
        The configured time zone for the Managed Database in TZ database format (e.g. `UTC`, `America/New_York`, `Europe/London`).
        """
        return pulumi.get(self, "cluster_time_zone")

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> Optional[_builtins.str]:
        """
        The database engine of the new managed database.
        """
        return pulumi.get(self, "database_engine")

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> Optional[_builtins.str]:
        """
        The database engine version of the new managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[_builtins.str]:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[_builtins.str]:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[_builtins.str]:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only - `noeviction`, `allkeys-lru`, `volatile-lru`, `allkeys-random`, `volatile-random`, `volatile-ttl`, `volatile-lfu`, `allkeys-lfu`).
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "ferretdb_credentials")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the managed database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> Optional[_builtins.str]:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[_builtins.str]:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[_builtins.str]:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> Optional[_builtins.int]:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> Optional[_builtins.bool]:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> Optional[_builtins.bool]:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of SQL modes to configure for the managed database (MySQL engine types only - `ALLOW_INVALID_DATES`, `ANSI`, `ANSI_QUOTES`, `ERROR_FOR_DIVISION_BY_ZERO`, `HIGH_NOT_PRECEDENCE`, `IGNORE_SPACE`, `NO_AUTO_VALUE_ON_ZERO`, `NO_DIR_IN_CREATE`, `NO_ENGINE_SUBSTITUTION`, `NO_UNSIGNED_SUBTRACTION`, `NO_ZERO_DATE`, `NO_ZERO_IN_DATE`, `ONLY_FULL_GROUP_BY`, `PIPES_AS_CONCAT`, `REAL_AS_FLOAT`, `STRICT_ALL_TABLES`, `STRICT_TRANS_TABLES`, `TIME_TRUNCATE_FRACTIONAL`, `TRADITIONAL`).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[_builtins.str]:
        """
        The ID of the plan that you want the managed database to subscribe to. [See List Managed Database Plans](https://www.vultr.com/api/#tag/managed-databases/operation/list-database-plans)
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> Optional[_builtins.int]:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> Optional[_builtins.int]:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> Optional[_builtins.int]:
        """
        The number of standby nodes available on the managed database (excluded for Kafka engine types).
        """
        return pulumi.get(self, "plan_replicas")

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> Optional[_builtins.int]:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> Optional[_builtins.str]:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The tag to assign to the managed database.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC Network to attach to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class DatabaseUserAccessControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclCategories":
            suggest = "acl_categories"
        elif key == "aclChannels":
            suggest = "acl_channels"
        elif key == "aclCommands":
            suggest = "acl_commands"
        elif key == "aclKeys":
            suggest = "acl_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseUserAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseUserAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseUserAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_categories: Sequence[_builtins.str],
                 acl_channels: Sequence[_builtins.str],
                 acl_commands: Sequence[_builtins.str],
                 acl_keys: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] acl_categories: The list of command category rules for this managed database user.
        :param Sequence[_builtins.str] acl_channels: The list of publish/subscribe channel patterns for this managed database user.
        :param Sequence[_builtins.str] acl_commands: The list of individual command rules for this managed database user.
        :param Sequence[_builtins.str] acl_keys: The list of access rules for this managed database user.
        """
        pulumi.set(__self__, "acl_categories", acl_categories)
        pulumi.set(__self__, "acl_channels", acl_channels)
        pulumi.set(__self__, "acl_commands", acl_commands)
        pulumi.set(__self__, "acl_keys", acl_keys)

    @_builtins.property
    @pulumi.getter(name="aclCategories")
    def acl_categories(self) -> Sequence[_builtins.str]:
        """
        The list of command category rules for this managed database user.
        """
        return pulumi.get(self, "acl_categories")

    @_builtins.property
    @pulumi.getter(name="aclChannels")
    def acl_channels(self) -> Sequence[_builtins.str]:
        """
        The list of publish/subscribe channel patterns for this managed database user.
        """
        return pulumi.get(self, "acl_channels")

    @_builtins.property
    @pulumi.getter(name="aclCommands")
    def acl_commands(self) -> Sequence[_builtins.str]:
        """
        The list of individual command rules for this managed database user.
        """
        return pulumi.get(self, "acl_commands")

    @_builtins.property
    @pulumi.getter(name="aclKeys")
    def acl_keys(self) -> Sequence[_builtins.str]:
        """
        The list of access rules for this managed database user.
        """
        return pulumi.get(self, "acl_keys")


@pulumi.output_type
class InstanceBackupsSchedule(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 dom: Optional[_builtins.int] = None,
                 dow: Optional[_builtins.int] = None,
                 hour: Optional[_builtins.int] = None):
        """
        :param _builtins.str type: Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        :param _builtins.int dom: Day of month to run. Use values between 1 and 28.
        :param _builtins.int dow: Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        :param _builtins.int hour: Hour of day to run in UTC.
        """
        pulumi.set(__self__, "type", type)
        if dom is not None:
            pulumi.set(__self__, "dom", dom)
        if dow is not None:
            pulumi.set(__self__, "dow", dow)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def dom(self) -> Optional[_builtins.int]:
        """
        Day of month to run. Use values between 1 and 28.
        """
        return pulumi.get(self, "dom")

    @_builtins.property
    @pulumi.getter
    def dow(self) -> Optional[_builtins.int]:
        """
        Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        """
        return pulumi.get(self, "dow")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Hour of day to run in UTC.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class KubernetesNodePools(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeQuantity":
            suggest = "node_quantity"
        elif key == "autoScaler":
            suggest = "auto_scaler"
        elif key == "dateCreated":
            suggest = "date_created"
        elif key == "dateUpdated":
            suggest = "date_updated"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "userData":
            suggest = "user_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePools. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePools.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePools.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: _builtins.str,
                 node_quantity: _builtins.int,
                 plan: _builtins.str,
                 auto_scaler: Optional[_builtins.bool] = None,
                 date_created: Optional[_builtins.str] = None,
                 date_updated: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 max_nodes: Optional[_builtins.int] = None,
                 min_nodes: Optional[_builtins.int] = None,
                 nodes: Optional[Sequence['outputs.KubernetesNodePoolsNode']] = None,
                 status: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 taints: Optional[Sequence['outputs.KubernetesNodePoolsTaint']] = None,
                 user_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str label: The label to be used as a prefix for nodes in this node pool.
        :param _builtins.int node_quantity: The number of nodes in this node pool.
        :param _builtins.str plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param _builtins.bool auto_scaler: Enable the auto scaler for the default node pool.
        :param _builtins.str date_created: Date node was created.
        :param _builtins.str date_updated: Date of node pool updates.
        :param _builtins.str id: ID of node.
        :param Mapping[str, _builtins.str] labels: A map of key/value pairs for Kubernetes node labels.
        :param _builtins.int max_nodes: The maximum number of nodes to use with the auto scaler.
        :param _builtins.int min_nodes: The minimum number of nodes to use with the auto scaler.
        :param Sequence['KubernetesNodePoolsNodeArgs'] nodes: Array that contains information about nodes within this node pool.
        :param _builtins.str status: Status of node.
        :param _builtins.str tag: Tag for node pool.
        :param Sequence['KubernetesNodePoolsTaintArgs'] taints: Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "plan", plan)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> _builtins.int:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[_builtins.bool]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[_builtins.str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[_builtins.str]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key/value pairs for Kubernetes node labels.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[_builtins.int]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.KubernetesNodePoolsNode']]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.KubernetesNodePoolsTaint']]:
        """
        Taints to apply to the nodes in the node pool. Should contain `key`, `value` and `effect`.  The `effect` should be one of `NoSchedule`, `PreferNoSchedule` or `NoExecute`.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_data")


@pulumi.output_type
class KubernetesNodePoolsNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateCreated":
            suggest = "date_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolsNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolsNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolsNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_created: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str date_created: Date node was created.
        :param _builtins.str id: ID of node.
        :param _builtins.str label: The label to be used as a prefix for nodes in this node pool.
        :param _builtins.str status: Status of node.
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[_builtins.str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class KubernetesNodePoolsTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerFirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipType":
            suggest = "ip_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_type: _builtins.str,
                 port: _builtins.int,
                 source: _builtins.str,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_type: The type of ip this rule is - may be either v4 or v6.
        :param _builtins.int port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param _builtins.str source: IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        :param _builtins.str id: The load balancer ID.
        """
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source", source)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> _builtins.str:
        """
        The type of ip this rule is - may be either v4 or v6.
        """
        return pulumi.get(self, "ip_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The load balancer ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerForwardingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "backendProtocol":
            suggest = "backend_protocol"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "frontendProtocol":
            suggest = "frontend_protocol"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerForwardingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: _builtins.int,
                 backend_protocol: _builtins.str,
                 frontend_port: _builtins.int,
                 frontend_protocol: _builtins.str,
                 rule_id: Optional[_builtins.str] = None):
        """
        :param _builtins.int backend_port: Port on instance side.
        :param _builtins.str backend_protocol: Protocol on instance side. Possible values: "http", "https", "tcp".
        :param _builtins.int frontend_port: Port on load balancer side.
        :param _builtins.str frontend_protocol: Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "backend_protocol", backend_protocol)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "frontend_protocol", frontend_protocol)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        Port on instance side.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="backendProtocol")
    def backend_protocol(self) -> _builtins.str:
        """
        Protocol on instance side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "backend_protocol")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        """
        Port on load balancer side.
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter(name="frontendProtocol")
    def frontend_protocol(self) -> _builtins.str:
        """
        Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "frontend_protocol")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class LoadBalancerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "responseTimeout":
            suggest = "response_timeout"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 check_interval: Optional[_builtins.int] = None,
                 healthy_threshold: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 response_timeout: Optional[_builtins.int] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param _builtins.str protocol: The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        :param _builtins.int check_interval: Time in seconds to perform health check. Default value is 15.
        :param _builtins.int healthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param _builtins.str path: The path on the attached instances that the load balancer should check against. Default value is `/`
        :param _builtins.int response_timeout: Time in seconds to wait for a health check response. Default value is 5.
        :param _builtins.int unhealthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[_builtins.int]:
        """
        Time in seconds to perform health check. Default value is 15.
        """
        return pulumi.get(self, "check_interval")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds to wait for a health check response. Default value is 5.
        """
        return pulumi.get(self, "response_timeout")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class LoadBalancerSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: _builtins.str,
                 private_key: _builtins.str,
                 chain: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate: The SSL Certificate.
        :param _builtins.str private_key: The SSL certificates private key.
        :param _builtins.str chain: The SSL certificate chain.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        The SSL Certificate.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        The SSL certificates private key.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[_builtins.str]:
        """
        The SSL certificate chain.
        """
        return pulumi.get(self, "chain")


@pulumi.output_type
class VirtualFileSystemStorageAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualFileSystemStorageAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualFileSystemStorageAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualFileSystemStorageAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.int] = None,
                 state: Optional[_builtins.str] = None):
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetApplicationFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBackupFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBareMetalPlanFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBareMetalServerFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBlockStorageFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetContainerRegistryFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetContainerRegistryRepositoryResult(dict):
    def __init__(__self__, *,
                 artifact_count: _builtins.int,
                 date_created: _builtins.str,
                 date_modified: _builtins.str,
                 description: _builtins.str,
                 image: _builtins.str,
                 name: _builtins.str,
                 pull_count: _builtins.int):
        """
        :param _builtins.int artifact_count: A count of the artifacts in the repository.
        :param _builtins.str date_created: A date-time of when the root user was created.
        :param _builtins.str date_modified: The date-time that the repository was last updated.
        :param _builtins.str description: A description of the repo, if set.
        :param _builtins.str image: The image name in the repository.
        :param _builtins.str name: The name of the repository.
        :param _builtins.int pull_count: A count of the number of pulls against the repository.
        """
        pulumi.set(__self__, "artifact_count", artifact_count)
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "date_modified", date_modified)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pull_count", pull_count)

    @_builtins.property
    @pulumi.getter(name="artifactCount")
    def artifact_count(self) -> _builtins.int:
        """
        A count of the artifacts in the repository.
        """
        return pulumi.get(self, "artifact_count")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        A date-time of when the root user was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        The date-time that the repository was last updated.
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the repo, if set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image name in the repository.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pullCount")
    def pull_count(self) -> _builtins.int:
        """
        A count of the number of pulls against the repository.
        """
        return pulumi.get(self, "pull_count")


@pulumi.output_type
class GetDatabaseFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDatabaseReadReplicaResult(dict):
    def __init__(__self__, *,
                 backup_hour: _builtins.str,
                 backup_minute: _builtins.str,
                 cluster_time_zone: _builtins.str,
                 database_engine: _builtins.str,
                 database_engine_version: _builtins.str,
                 date_created: _builtins.str,
                 dbname: _builtins.str,
                 eviction_policy: _builtins.str,
                 ferretdb_credentials: Mapping[str, _builtins.str],
                 host: _builtins.str,
                 id: _builtins.str,
                 label: _builtins.str,
                 latest_backup: _builtins.str,
                 maintenance_dow: _builtins.str,
                 maintenance_time: _builtins.str,
                 mysql_long_query_time: _builtins.int,
                 mysql_require_primary_key: _builtins.bool,
                 mysql_slow_query_log: _builtins.bool,
                 mysql_sql_modes: Sequence[_builtins.str],
                 password: _builtins.str,
                 plan: _builtins.str,
                 plan_disk: _builtins.int,
                 plan_ram: _builtins.int,
                 plan_replicas: _builtins.int,
                 plan_vcpus: _builtins.int,
                 port: _builtins.str,
                 public_host: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str,
                 tag: _builtins.str,
                 trusted_ips: Sequence[_builtins.str],
                 user: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str backup_hour: The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        :param _builtins.str backup_minute: The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        :param _builtins.str cluster_time_zone: The configured time zone for the Managed Database in TZ database format.
        :param _builtins.str database_engine: The database engine of the managed database.
        :param _builtins.str database_engine_version: The database engine version of the managed database.
        :param _builtins.str date_created: The date the managed database was added to your Vultr account.
        :param _builtins.str dbname: The managed database's default logical database.
        :param _builtins.str eviction_policy: The configuration value for the data eviction policy on the managed database (Valkey engine types only).
        :param _builtins.str host: The hostname assigned to the managed database.
        :param _builtins.str label: The managed database's label.
        :param _builtins.str latest_backup: The date of the latest backup available on the managed database.
        :param _builtins.str maintenance_dow: The preferred maintenance day of week for the managed database.
        :param _builtins.str maintenance_time: The preferred maintenance time for the managed database.
        :param _builtins.int mysql_long_query_time: The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        :param _builtins.bool mysql_require_primary_key: The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        :param _builtins.bool mysql_slow_query_log: The configuration value for slow query logging on the managed database (MySQL engine types only).
        :param Sequence[_builtins.str] mysql_sql_modes: A list of SQL modes currently configured for the managed database (MySQL engine types only).
        :param _builtins.str password: The password for the managed database's primary admin user.
        :param _builtins.str plan: The managed database's plan ID.
        :param _builtins.int plan_disk: The description of the disk(s) on the managed database.
        :param _builtins.int plan_ram: The amount of memory available on the managed database in MB.
        :param _builtins.int plan_replicas: The number of standby nodes available on the managed database.
        :param _builtins.int plan_vcpus: The number of virtual CPUs available on the managed database.
        :param _builtins.str port: The connection port for the managed database.
        :param _builtins.str public_host: The public hostname assigned to the managed database (VPC-attached only).
        :param _builtins.str region: The region ID of the managed database.
        :param _builtins.str status: The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        :param _builtins.str tag: The managed database's tag.
        :param Sequence[_builtins.str] trusted_ips: A list of allowed IP addresses for the managed database.
        :param _builtins.str user: The primary admin user for the managed database.
        :param _builtins.str vpc_id: The ID of the VPC Network attached to the Managed Database.
        """
        pulumi.set(__self__, "backup_hour", backup_hour)
        pulumi.set(__self__, "backup_minute", backup_minute)
        pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        pulumi.set(__self__, "database_engine", database_engine)
        pulumi.set(__self__, "database_engine_version", database_engine_version)
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "eviction_policy", eviction_policy)
        pulumi.set(__self__, "ferretdb_credentials", ferretdb_credentials)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "latest_backup", latest_backup)
        pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        pulumi.set(__self__, "maintenance_time", maintenance_time)
        pulumi.set(__self__, "mysql_long_query_time", mysql_long_query_time)
        pulumi.set(__self__, "mysql_require_primary_key", mysql_require_primary_key)
        pulumi.set(__self__, "mysql_slow_query_log", mysql_slow_query_log)
        pulumi.set(__self__, "mysql_sql_modes", mysql_sql_modes)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "plan_disk", plan_disk)
        pulumi.set(__self__, "plan_ram", plan_ram)
        pulumi.set(__self__, "plan_replicas", plan_replicas)
        pulumi.set(__self__, "plan_vcpus", plan_vcpus)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "public_host", public_host)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "trusted_ips", trusted_ips)
        pulumi.set(__self__, "user", user)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> _builtins.str:
        """
        The preferred hour of the day (UTC) for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> _builtins.str:
        """
        The preferred minute of the backup hour for daily backups to take place (unavailable for Kafka engine types).
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> _builtins.str:
        """
        The configured time zone for the Managed Database in TZ database format.
        """
        return pulumi.get(self, "cluster_time_zone")

    @_builtins.property
    @pulumi.getter(name="databaseEngine")
    def database_engine(self) -> _builtins.str:
        """
        The database engine of the managed database.
        """
        return pulumi.get(self, "database_engine")

    @_builtins.property
    @pulumi.getter(name="databaseEngineVersion")
    def database_engine_version(self) -> _builtins.str:
        """
        The database engine version of the managed database.
        """
        return pulumi.get(self, "database_engine_version")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the managed database was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The managed database's default logical database.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> _builtins.str:
        """
        The configuration value for the data eviction policy on the managed database (Valkey engine types only).
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="ferretdbCredentials")
    def ferretdb_credentials(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "ferretdb_credentials")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The hostname assigned to the managed database.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The managed database's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestBackup")
    def latest_backup(self) -> _builtins.str:
        """
        The date of the latest backup available on the managed database.
        """
        return pulumi.get(self, "latest_backup")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> _builtins.str:
        """
        The preferred maintenance day of week for the managed database.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> _builtins.str:
        """
        The preferred maintenance time for the managed database.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter(name="mysqlLongQueryTime")
    def mysql_long_query_time(self) -> _builtins.int:
        """
        The configuration value for the long query time (in seconds) on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_long_query_time")

    @_builtins.property
    @pulumi.getter(name="mysqlRequirePrimaryKey")
    def mysql_require_primary_key(self) -> _builtins.bool:
        """
        The configuration value for whether primary keys are required on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="mysqlSlowQueryLog")
    def mysql_slow_query_log(self) -> _builtins.bool:
        """
        The configuration value for slow query logging on the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_slow_query_log")

    @_builtins.property
    @pulumi.getter(name="mysqlSqlModes")
    def mysql_sql_modes(self) -> Sequence[_builtins.str]:
        """
        A list of SQL modes currently configured for the managed database (MySQL engine types only).
        """
        return pulumi.get(self, "mysql_sql_modes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the managed database's primary admin user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The managed database's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="planDisk")
    def plan_disk(self) -> _builtins.int:
        """
        The description of the disk(s) on the managed database.
        """
        return pulumi.get(self, "plan_disk")

    @_builtins.property
    @pulumi.getter(name="planRam")
    def plan_ram(self) -> _builtins.int:
        """
        The amount of memory available on the managed database in MB.
        """
        return pulumi.get(self, "plan_ram")

    @_builtins.property
    @pulumi.getter(name="planReplicas")
    def plan_replicas(self) -> _builtins.int:
        """
        The number of standby nodes available on the managed database.
        """
        return pulumi.get(self, "plan_replicas")

    @_builtins.property
    @pulumi.getter(name="planVcpus")
    def plan_vcpus(self) -> _builtins.int:
        """
        The number of virtual CPUs available on the managed database.
        """
        return pulumi.get(self, "plan_vcpus")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The connection port for the managed database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicHost")
    def public_host(self) -> _builtins.str:
        """
        The public hostname assigned to the managed database (VPC-attached only).
        """
        return pulumi.get(self, "public_host")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the managed database.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the managed database (poweroff, rebuilding, rebalancing, configuring, running).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The managed database's tag.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> Sequence[_builtins.str]:
        """
        A list of allowed IP addresses for the managed database.
        """
        return pulumi.get(self, "trusted_ips")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The primary admin user for the managed database.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC Network attached to the Managed Database.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetFirewallGroupFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInferenceFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstanceFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstanceIpv4FilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 allowed_bandwidth: _builtins.int,
                 app_id: _builtins.int,
                 backups: _builtins.str,
                 backups_schedule: Mapping[str, _builtins.str],
                 date_created: _builtins.str,
                 disk: _builtins.int,
                 features: Sequence[_builtins.str],
                 firewall_group_id: _builtins.str,
                 gateway_v4: _builtins.str,
                 hostname: _builtins.str,
                 id: _builtins.str,
                 image_id: _builtins.str,
                 internal_ip: _builtins.str,
                 kvm: _builtins.str,
                 label: _builtins.str,
                 location: _builtins.str,
                 main_ip: _builtins.str,
                 netmask_v4: _builtins.str,
                 os: _builtins.str,
                 os_id: _builtins.int,
                 plan: _builtins.str,
                 power_status: _builtins.str,
                 private_network_ids: Sequence[_builtins.str],
                 ram: _builtins.int,
                 region: _builtins.str,
                 server_status: _builtins.str,
                 status: _builtins.str,
                 tags: Sequence[_builtins.str],
                 user_scheme: _builtins.str,
                 v6_main_ip: _builtins.str,
                 v6_network: _builtins.str,
                 v6_network_size: _builtins.int,
                 vcpu_count: _builtins.int,
                 vpc_ids: Sequence[_builtins.str]):
        """
        :param _builtins.int allowed_bandwidth: The server's allowed bandwidth usage in GB.
        :param _builtins.int app_id: The server's application ID.
        :param Mapping[str, _builtins.str] backups_schedule: The current configuration for backups
        :param _builtins.str date_created: The date the server was added to your Vultr account.
        :param _builtins.int disk: The description of the disk(s) on the server.
        :param Sequence[_builtins.str] features: Array of which features are enabled.
        :param _builtins.str firewall_group_id: The ID of the firewall group applied to this server.
        :param _builtins.str gateway_v4: The server's IPv4 gateway.
        :param _builtins.str hostname: The hostname assigned to the server.
        :param _builtins.str image_id: The Marketplace ID for this application.
        :param _builtins.str internal_ip: The server's internal IP address.
        :param _builtins.str kvm: The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        :param _builtins.str label: The server's label.
        :param _builtins.str main_ip: The server's main IP address.
        :param _builtins.str netmask_v4: The server's IPv4 netmask.
        :param _builtins.str os: The operating system of the instance.
        :param _builtins.int os_id: The server's operating system ID.
        :param _builtins.str plan: The server's plan ID.
        :param _builtins.str power_status: Whether the server is powered on or not.
        :param _builtins.int ram: The amount of memory available on the instance in MB.
        :param _builtins.str region: The region ID of the server.
        :param _builtins.str server_status: A more detailed server status (none, locked, installingbooting, isomounting, ok).
        :param _builtins.str status: The status of the server's subscription.
        :param Sequence[_builtins.str] tags: A list of tags applied to the instance.
        :param _builtins.str user_scheme: The scheme used for the default user (linux servers only).
        :param _builtins.str v6_main_ip: The main IPv6 network address.
        :param _builtins.str v6_network: The IPv6 subnet.
        :param _builtins.int v6_network_size: The IPv6 network size in bits.
        :param _builtins.int vcpu_count: The number of virtual CPUs available on the server.
        """
        pulumi.set(__self__, "allowed_bandwidth", allowed_bandwidth)
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "backups_schedule", backups_schedule)
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        pulumi.set(__self__, "gateway_v4", gateway_v4)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "kvm", kvm)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "main_ip", main_ip)
        pulumi.set(__self__, "netmask_v4", netmask_v4)
        pulumi.set(__self__, "os", os)
        pulumi.set(__self__, "os_id", os_id)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "power_status", power_status)
        pulumi.set(__self__, "private_network_ids", private_network_ids)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "server_status", server_status)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_scheme", user_scheme)
        pulumi.set(__self__, "v6_main_ip", v6_main_ip)
        pulumi.set(__self__, "v6_network", v6_network)
        pulumi.set(__self__, "v6_network_size", v6_network_size)
        pulumi.set(__self__, "vcpu_count", vcpu_count)
        pulumi.set(__self__, "vpc_ids", vpc_ids)

    @_builtins.property
    @pulumi.getter(name="allowedBandwidth")
    def allowed_bandwidth(self) -> _builtins.int:
        """
        The server's allowed bandwidth usage in GB.
        """
        return pulumi.get(self, "allowed_bandwidth")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.int:
        """
        The server's application ID.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> _builtins.str:
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="backupsSchedule")
    def backups_schedule(self) -> Mapping[str, _builtins.str]:
        """
        The current configuration for backups
        """
        return pulumi.get(self, "backups_schedule")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.int:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence[_builtins.str]:
        """
        Array of which features are enabled.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> _builtins.str:
        """
        The ID of the firewall group applied to this server.
        """
        return pulumi.get(self, "firewall_group_id")

    @_builtins.property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> _builtins.str:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname assigned to the server.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The Marketplace ID for this application.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> _builtins.str:
        """
        The server's internal IP address.
        """
        return pulumi.get(self, "internal_ip")

    @_builtins.property
    @pulumi.getter
    def kvm(self) -> _builtins.str:
        """
        The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        """
        return pulumi.get(self, "kvm")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The server's label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> _builtins.str:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @_builtins.property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> _builtins.str:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operating system of the instance.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> _builtins.int:
        """
        The server's operating system ID.
        """
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The server's plan ID.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> _builtins.str:
        """
        Whether the server is powered on or not.
        """
        return pulumi.get(self, "power_status")

    @_builtins.property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "private_network_ids")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The amount of memory available on the instance in MB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region ID of the server.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverStatus")
    def server_status(self) -> _builtins.str:
        """
        A more detailed server status (none, locked, installingbooting, isomounting, ok).
        """
        return pulumi.get(self, "server_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of tags applied to the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userScheme")
    def user_scheme(self) -> _builtins.str:
        """
        The scheme used for the default user (linux servers only).
        """
        return pulumi.get(self, "user_scheme")

    @_builtins.property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> _builtins.str:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @_builtins.property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> _builtins.str:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @_builtins.property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> _builtins.int:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @_builtins.property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> _builtins.int:
        """
        The number of virtual CPUs available on the server.
        """
        return pulumi.get(self, "vcpu_count")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "vpc_ids")


@pulumi.output_type
class GetIsoPrivateFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetIsoPublicFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetKubernetesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetKubernetesNodePoolResult(dict):
    def __init__(__self__, *,
                 date_created: _builtins.str,
                 date_updated: _builtins.str,
                 id: _builtins.str,
                 label: _builtins.str,
                 node_quantity: _builtins.int,
                 nodes: Sequence['outputs.GetKubernetesNodePoolNodeResult'],
                 plan: _builtins.str,
                 status: _builtins.str,
                 tag: _builtins.str,
                 auto_scaler: Optional[_builtins.bool] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 max_nodes: Optional[_builtins.int] = None,
                 min_nodes: Optional[_builtins.int] = None,
                 taints: Optional[Sequence['outputs.GetKubernetesNodePoolTaintResult']] = None,
                 user_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str date_created: Date node was created.
        :param _builtins.str date_updated: Date of node pool updates.
        :param _builtins.str id: ID of node.
        :param _builtins.str label: Label of node.
        :param _builtins.int node_quantity: Number of nodes within node pool.
        :param Sequence['GetKubernetesNodePoolNodeArgs'] nodes: Array that contains information about nodes within this node pool.
        :param _builtins.str plan: Node plan that nodes are using within this node pool.
        :param _builtins.str status: Status of node.
        :param _builtins.str tag: Tag for node pool.
        :param _builtins.bool auto_scaler: Boolean indicating if the auto scaler for the default node pool is active.
        :param Mapping[str, _builtins.str] labels: Kubernetes node labels applied to the node pool.
        :param _builtins.int max_nodes: The maximum number of nodes used by the auto scaler.
        :param _builtins.int min_nodes: The minimum number of nodes used by the auto scaler.
        :param Sequence['GetKubernetesNodePoolTaintArgs'] taints: Kubernetes node taints applied to the node pool.
        :param _builtins.str user_data: The base64 encoded string containing the user data applied to nodes in the node pool.
        """
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "date_updated", date_updated)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> _builtins.str:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label of node.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> _builtins.int:
        """
        Number of nodes within node pool.
        """
        return pulumi.get(self, "node_quantity")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetKubernetesNodePoolNodeResult']:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        Node plan that nodes are using within this node pool.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[_builtins.bool]:
        """
        Boolean indicating if the auto scaler for the default node pool is active.
        """
        return pulumi.get(self, "auto_scaler")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Kubernetes node labels applied to the node pool.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes used by the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[_builtins.int]:
        """
        The minimum number of nodes used by the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.GetKubernetesNodePoolTaintResult']]:
        """
        Kubernetes node taints applied to the node pool.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[_builtins.str]:
        """
        The base64 encoded string containing the user data applied to nodes in the node pool.
        """
        return pulumi.get(self, "user_data")


@pulumi.output_type
class GetKubernetesNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 date_created: _builtins.str,
                 id: _builtins.str,
                 label: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str date_created: Date node was created.
        :param _builtins.str id: ID of node.
        :param _builtins.str label: Label of node.
        :param _builtins.str status: Status of node.
        """
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label of node.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetKubernetesNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetLoadBalancerFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageClusterFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageTierFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageTierLocationResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 id: _builtins.int,
                 name: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.int id: The identifying tier ID.
        :param _builtins.str name: Attribute name to filter with.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The identifying tier ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetOsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPlanFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetRegionFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReservedIpFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReverseIpv4FilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReverseIpv6FilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSnapshotFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSshKeyFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetStartupScriptFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetUserFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVirtualFileSystemStorageAttachmentResult(dict):
    def __init__(__self__, *,
                 instance_id: _builtins.str,
                 mount: _builtins.int,
                 state: _builtins.str):
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "mount", mount)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> _builtins.int:
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetVirtualFileSystemStorageFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVpc2FilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVpcFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Attribute name to filter with.
        :param Sequence[_builtins.str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


