# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_limit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] api_key: The API Key that allows interaction with the API
        :param pulumi.Input[_builtins.int] rate_limit: Allows users to set the speed of API calls to work with the Vultr Rate Limit
        :param pulumi.Input[_builtins.int] retry_limit: Allows users to set the maximum number of retries allowed for a failed API call.
        """
        if api_key is None:
            api_key = _utilities.get_env('VULTR_API_KEY')
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if rate_limit is None:
            rate_limit = 500
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if retry_limit is None:
            retry_limit = 3
        if retry_limit is not None:
            pulumi.set(__self__, "retry_limit", retry_limit)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API Key that allows interaction with the API
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Allows users to set the speed of API calls to work with the Vultr Rate Limit
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="retryLimit")
    def retry_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Allows users to set the maximum number of retries allowed for a failed API call.
        """
        return pulumi.get(self, "retry_limit")

    @retry_limit.setter
    def retry_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_limit", value)


@pulumi.type_token("pulumi:providers:vultr")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The provider type for the vultr package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The API Key that allows interaction with the API
        :param pulumi.Input[_builtins.int] rate_limit: Allows users to set the speed of API calls to work with the Vultr Rate Limit
        :param pulumi.Input[_builtins.int] retry_limit: Allows users to set the maximum number of retries allowed for a failed API call.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the vultr package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if api_key is None:
                api_key = _utilities.get_env('VULTR_API_KEY')
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            if rate_limit is None:
                rate_limit = 500
            __props__.__dict__["rate_limit"] = pulumi.Output.from_input(rate_limit).apply(pulumi.runtime.to_json) if rate_limit is not None else None
            if retry_limit is None:
                retry_limit = 3
            __props__.__dict__["retry_limit"] = pulumi.Output.from_input(retry_limit).apply(pulumi.runtime.to_json) if retry_limit is not None else None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'vultr',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API Key that allows interaction with the API
        """
        return pulumi.get(self, "api_key")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:vultr/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

