# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReverseIpv6Args', 'ReverseIpv6']

@pulumi.input_type
class ReverseIpv6Args:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 ip: pulumi.Input[_builtins.str],
                 reverse: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ReverseIpv6 resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the server you want to set an IPv6
               reverse DNS record for.
        :param pulumi.Input[_builtins.str] ip: The IPv6 address used in the reverse DNS record.
        :param pulumi.Input[_builtins.str] reverse: The hostname used in the IPv6 reverse DNS record.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "reverse", reverse)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the server you want to set an IPv6
        reverse DNS record for.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        The IPv6 address used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname used in the IPv6 reverse DNS record.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reverse", value)


@pulumi.input_type
class _ReverseIpv6State:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReverseIpv6 resources.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the server you want to set an IPv6
               reverse DNS record for.
        :param pulumi.Input[_builtins.str] ip: The IPv6 address used in the reverse DNS record.
        :param pulumi.Input[_builtins.str] reverse: The hostname used in the IPv6 reverse DNS record.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the server you want to set an IPv6
        reverse DNS record for.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname used in the IPv6 reverse DNS record.
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reverse", value)


@pulumi.type_token("vultr:index/reverseIpv6:ReverseIpv6")
class ReverseIpv6(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr Reverse IPv6 resource. This can be used to create, read,
        modify, and delete reverse DNS records for IPv6 addresses. Upon success, DNS
        changes may take 6-12 hours to become active.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the server you want to set an IPv6
               reverse DNS record for.
        :param pulumi.Input[_builtins.str] ip: The IPv6 address used in the reverse DNS record.
        :param pulumi.Input[_builtins.str] reverse: The hostname used in the IPv6 reverse DNS record.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReverseIpv6Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr Reverse IPv6 resource. This can be used to create, read,
        modify, and delete reverse DNS records for IPv6 addresses. Upon success, DNS
        changes may take 6-12 hours to become active.

        :param str resource_name: The name of the resource.
        :param ReverseIpv6Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReverseIpv6Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReverseIpv6Args.__new__(ReverseIpv6Args)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            if reverse is None and not opts.urn:
                raise TypeError("Missing required property 'reverse'")
            __props__.__dict__["reverse"] = reverse
        super(ReverseIpv6, __self__).__init__(
            'vultr:index/reverseIpv6:ReverseIpv6',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            reverse: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReverseIpv6':
        """
        Get an existing ReverseIpv6 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the server you want to set an IPv6
               reverse DNS record for.
        :param pulumi.Input[_builtins.str] ip: The IPv6 address used in the reverse DNS record.
        :param pulumi.Input[_builtins.str] reverse: The hostname used in the IPv6 reverse DNS record.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReverseIpv6State.__new__(_ReverseIpv6State)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip"] = ip
        __props__.__dict__["reverse"] = reverse
        return ReverseIpv6(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the server you want to set an IPv6
        reverse DNS record for.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 address used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname used in the IPv6 reverse DNS record.
        """
        return pulumi.get(self, "reverse")

