# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SSHKeyArgs', 'SSHKey']

@pulumi.input_type
class SSHKeyArgs:
    def __init__(__self__, *,
                 ssh_key: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SSHKey resource.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH key.
        :param pulumi.Input[_builtins.str] name: The name/label of the SSH key.
        """
        pulumi.set(__self__, "ssh_key", ssh_key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Input[_builtins.str]:
        """
        The public SSH key.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ssh_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name/label of the SSH key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SSHKeyState:
    def __init__(__self__, *,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SSHKey resources.
        :param pulumi.Input[_builtins.str] date_created: The date the SSH key was added to your Vultr account.
        :param pulumi.Input[_builtins.str] name: The name/label of the SSH key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH key.
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the SSH key was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name/label of the SSH key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public SSH key.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_key", value)


@pulumi.type_token("vultr:index/sSHKey:SSHKey")
class SSHKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Vultr SSH key resource. This can be used to create, read, modify, and delete SSH keys.

        ## Example Usage

        Create an SSH key

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_ssh_key = vultr.SSHKey("mySshKey", ssh_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCyVGaw1PuEl98f4/7Kq3O9ZIvDw2OFOSXAFVqilSFNkHlefm1iMtPeqsIBp2t9cbGUf55xNDULz/bD/4BCV43yZ5lh0cUYuXALg9NI29ui7PEGReXjSpNwUD6ceN/78YOK41KAcecq+SS0bJ4b4amKZIJG3JWmDKljtv1dmSBCrTmEAQaOorxqGGBYmZS7NQumRe4lav5r6wOs8OACMANE1ejkeZsGFzJFNqvr5DuHdDL5FAudW23me3BDmrM9ifUzzjl1Jwku3bnRaCcjaxH8oTumt1a00mWci/1qUlaVFft085yvVq7KZbF2OPPbl+erDW91+EZ2FgEi+v1/CSJ5 your_username@hostname")
        ```

        ## Import

        SSH keys can be imported using the SSH key `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/sSHKey:SSHKey my_key 6b0876a7-f709-41ba-aed8-abed9d38ae45
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name/label of the SSH key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SSHKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr SSH key resource. This can be used to create, read, modify, and delete SSH keys.

        ## Example Usage

        Create an SSH key

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_ssh_key = vultr.SSHKey("mySshKey", ssh_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCyVGaw1PuEl98f4/7Kq3O9ZIvDw2OFOSXAFVqilSFNkHlefm1iMtPeqsIBp2t9cbGUf55xNDULz/bD/4BCV43yZ5lh0cUYuXALg9NI29ui7PEGReXjSpNwUD6ceN/78YOK41KAcecq+SS0bJ4b4amKZIJG3JWmDKljtv1dmSBCrTmEAQaOorxqGGBYmZS7NQumRe4lav5r6wOs8OACMANE1ejkeZsGFzJFNqvr5DuHdDL5FAudW23me3BDmrM9ifUzzjl1Jwku3bnRaCcjaxH8oTumt1a00mWci/1qUlaVFft085yvVq7KZbF2OPPbl+erDW91+EZ2FgEi+v1/CSJ5 your_username@hostname")
        ```

        ## Import

        SSH keys can be imported using the SSH key `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/sSHKey:SSHKey my_key 6b0876a7-f709-41ba-aed8-abed9d38ae45
        ```

        :param str resource_name: The name of the resource.
        :param SSHKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SSHKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SSHKeyArgs.__new__(SSHKeyArgs)

            __props__.__dict__["name"] = name
            if ssh_key is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_key'")
            __props__.__dict__["ssh_key"] = ssh_key
            __props__.__dict__["date_created"] = None
        super(SSHKey, __self__).__init__(
            'vultr:index/sSHKey:SSHKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'SSHKey':
        """
        Get an existing SSHKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] date_created: The date the SSH key was added to your Vultr account.
        :param pulumi.Input[_builtins.str] name: The name/label of the SSH key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SSHKeyState.__new__(_SSHKeyState)

        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["name"] = name
        __props__.__dict__["ssh_key"] = ssh_key
        return SSHKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the SSH key was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name/label of the SSH key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[_builtins.str]:
        """
        The public SSH key.
        """
        return pulumi.get(self, "ssh_key")

